/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.cssbox;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermAngle;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.layout.model.Rectangular;

public class BoxTransform {
    private Box box;
    private AffineTransform transform;

    public BoxTransform(Box box) {
        this.box = box;
        this.transform = box instanceof ElementBox ? this.createTransform((ElementBox)box) : null;
    }

    public BoxTransform(BoxTransform src) {
        this.box = src.box;
        this.transform = src.transform;
    }

    public Box getBox() {
        return this.box;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public boolean isEmpty() {
        return this.transform == null;
    }

    public BoxTransform concatenate(BoxTransform src) {
        if (src.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return src;
        }
        BoxTransform ret = new BoxTransform(this);
        ret.transform = new AffineTransform(this.transform);
        ret.transform.concatenate(src.transform);
        return ret;
    }

    public Rectangular transformRect(Rectangular rect) {
        if (this.transform != null) {
            Rectangle src = new Rectangle(rect.getX1(), rect.getY1(), rect.getWidth(), rect.getHeight());
            Shape dest = this.transform.createTransformedShape(src);
            Rectangle destr = dest instanceof Rectangle ? (Rectangle)dest : dest.getBounds();
            return new Rectangular(destr);
        }
        return rect;
    }

    protected AffineTransform createTransform(ElementBox elem) {
        if (elem.isBlock() || elem.isReplaced()) {
            int oy;
            int ox;
            CSSDecoder dec = new CSSDecoder(elem.getVisualContext());
            Rectangle bounds = elem.getAbsoluteBorderBounds();
            CSSProperty.TransformOrigin origin = (CSSProperty.TransformOrigin)elem.getStyle().getProperty("transform-origin");
            if (origin == CSSProperty.TransformOrigin.list_values) {
                TermList values = (TermList)elem.getStyle().getValue(TermList.class, "transform-origin");
                ox = dec.getLength((TermLengthOrPercent)values.get(0), false, bounds.width / 2, 0, bounds.width);
                oy = dec.getLength((TermLengthOrPercent)values.get(1), false, bounds.height / 2, 0, bounds.height);
            } else {
                ox = bounds.width / 2;
                oy = bounds.height / 2;
            }
            ox += bounds.x;
            oy += bounds.y;
            AffineTransform ret = null;
            CSSProperty.Transform trans = (CSSProperty.Transform)elem.getStyle().getProperty("transform");
            if (trans == CSSProperty.Transform.list_values) {
                ret = new AffineTransform();
                ret.translate(ox, oy);
                TermList values = (TermList)elem.getStyle().getValue(TermList.class, "transform");
                for (Term term : values) {
                    if (!(term instanceof TermFunction)) continue;
                    TermFunction func = (TermFunction)term;
                    String fname = func.getFunctionName().toLowerCase();
                    if (fname.equals("rotate")) {
                        if (func.size() != 1 || !(func.get(0) instanceof TermAngle)) continue;
                        double theta = dec.getAngle((TermAngle)func.get(0));
                        ret.rotate(theta);
                        continue;
                    }
                    if (fname.equals("translate")) {
                        if (func.size() == 1 && func.get(0) instanceof TermLengthOrPercent) {
                            int tx = dec.getLength((TermLengthOrPercent)func.get(0), false, 0, 0, bounds.width);
                            ret.translate(tx, 0.0);
                            continue;
                        }
                        if (func.size() != 2 || !(func.get(0) instanceof TermLengthOrPercent) || !(func.get(1) instanceof TermLengthOrPercent)) continue;
                        int tx = dec.getLength((TermLengthOrPercent)func.get(0), false, 0, 0, bounds.width);
                        int ty = dec.getLength((TermLengthOrPercent)func.get(1), false, 0, 0, bounds.height);
                        ret.translate(tx, ty);
                        continue;
                    }
                    if (fname.equals("translatex")) {
                        if (func.size() != 1 || !(func.get(0) instanceof TermLengthOrPercent)) continue;
                        int tx = dec.getLength((TermLengthOrPercent)func.get(0), false, 0, 0, bounds.width);
                        ret.translate(tx, 0.0);
                        continue;
                    }
                    if (fname.equals("translatey")) {
                        if (func.size() != 1 || !(func.get(0) instanceof TermLengthOrPercent)) continue;
                        int ty = dec.getLength((TermLengthOrPercent)func.get(0), false, 0, 0, bounds.height);
                        ret.translate(0.0, ty);
                        continue;
                    }
                    if (fname.equals("scale")) {
                        if (func.size() == 1 && this.isNumber((Term)func.get(0))) {
                            float sx = this.getNumber((Term)func.get(0));
                            ret.scale(sx, sx);
                            continue;
                        }
                        if (func.size() != 2 || !this.isNumber((Term)func.get(0)) || !this.isNumber((Term)func.get(1))) continue;
                        float sx = this.getNumber((Term)func.get(0));
                        float sy = this.getNumber((Term)func.get(1));
                        ret.scale(sx, sy);
                        continue;
                    }
                    if (fname.equals("scalex")) {
                        if (func.size() != 1 || !this.isNumber((Term)func.get(0))) continue;
                        float sx = this.getNumber((Term)func.get(0));
                        ret.scale(sx, 1.0);
                        continue;
                    }
                    if (fname.equals("scaley")) {
                        if (func.size() != 1 || !this.isNumber((Term)func.get(0))) continue;
                        float sy = this.getNumber((Term)func.get(0));
                        ret.scale(1.0, sy);
                        continue;
                    }
                    if (fname.equals("skew")) {
                        if (func.size() == 1 && func.get(0) instanceof TermAngle) {
                            double ax = dec.getAngle((TermAngle)func.get(0));
                            ret.shear(Math.tan(ax), 0.0);
                            continue;
                        }
                        if (func.size() != 2 || !(func.get(0) instanceof TermAngle) || !(func.get(1) instanceof TermAngle)) continue;
                        double ax = dec.getAngle((TermAngle)func.get(0));
                        double ay = dec.getAngle((TermAngle)func.get(1));
                        ret.shear(Math.tan(ax), Math.tan(ay));
                        continue;
                    }
                    if (fname.equals("skewx")) {
                        if (func.size() != 1 || !(func.get(0) instanceof TermAngle)) continue;
                        double ax = dec.getAngle((TermAngle)func.get(0));
                        ret.shear(Math.tan(ax), 0.0);
                        continue;
                    }
                    if (fname.equals("skewy")) {
                        if (func.size() != 1 || !(func.get(0) instanceof TermAngle)) continue;
                        double ay = dec.getAngle((TermAngle)func.get(0));
                        ret.shear(0.0, Math.tan(ay));
                        continue;
                    }
                    if (!fname.equals("matrix") || func.size() != 6) continue;
                    double[] vals = new double[6];
                    boolean typesOk = true;
                    for (int i = 0; i < 6; ++i) {
                        if (this.isNumber((Term)func.get(i))) {
                            vals[i] = this.getNumber((Term)func.get(i));
                            continue;
                        }
                        typesOk = false;
                    }
                    if (!typesOk) continue;
                    ret.concatenate(new AffineTransform(vals));
                }
                ret.translate(-ox, -oy);
            }
            return ret;
        }
        return null;
    }

    private boolean isNumber(Term<?> term) {
        return term instanceof TermNumber || term instanceof TermInteger;
    }

    private float getNumber(Term<?> term) {
        if (term instanceof TermNumber) {
            return ((Float)((TermNumber)term).getValue()).floatValue();
        }
        return ((Float)((TermInteger)term).getValue()).floatValue();
    }
}

