/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.cssbox;

import cz.vutbr.web.css.MediaSpec;
import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.pdf.PdfBrowserCanvas;
import org.fit.layout.cssbox.BoxNode;
import org.fit.layout.cssbox.PageImpl;
import org.fit.layout.impl.DefaultBox;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.Box;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CSSBoxTreeBuilder {
    private static Logger log = LoggerFactory.getLogger(CSSBoxTreeBuilder.class);
    protected URL pageUrl;
    protected String pageTitle;
    protected PageImpl page;
    protected Viewport viewport;
    protected Dimension pageSize;
    protected boolean useVisualBounds;
    protected boolean preserveAux;
    protected boolean replaceImagesWithAlt;
    private int order_counter;

    public CSSBoxTreeBuilder(Dimension pageSize, boolean useVisualBounds, boolean preserveAux, boolean replaceImagesWithAlt) {
        this.pageSize = pageSize;
        this.useVisualBounds = useVisualBounds;
        this.preserveAux = preserveAux;
        this.replaceImagesWithAlt = replaceImagesWithAlt;
    }

    public void parse(URL url) throws IOException, SAXException {
        BrowserCanvas canvas = this.renderUrl(url, this.pageSize);
        this.viewport = canvas.getViewport();
        PageImpl pg = this.page = new PageImpl(this.pageUrl);
        pg.setTitle(this.pageTitle);
        Viewport rootbox = canvas.getViewport();
        BoxNode root = this.buildTree((ElementBox)rootbox);
        pg.setRoot(root);
        pg.setWidth(rootbox.getWidth());
        pg.setHeight(rootbox.getHeight());
    }

    public void parseList(List<URL> list) throws IOException, SAXException {
        int twidth = 0;
        int theight = 0;
        this.page = new PageImpl(list.get(0));
        DefaultBox main = new DefaultBox();
        main.setPage((Page)this.page);
        main.setTagName("pageset");
        for (URL url : list) {
            log.info("Parsing: {}", (Object)url);
            BrowserCanvas canvas = this.renderUrl(url, this.pageSize);
            Viewport rootbox = canvas.getViewport();
            BoxNode root = this.buildTree((ElementBox)rootbox);
            DefaultBox pageBox = new DefaultBox();
            pageBox.setPage((Page)this.page);
            pageBox.add((GenericTreeNode)root);
            pageBox.setTagName("page");
            pageBox.setDisplayType(Box.DisplayType.BLOCK);
            pageBox.setBounds(new Rectangular(root.getBounds()));
            pageBox.setVisualBounds(new Rectangular(root.getBounds()));
            pageBox.setContentBounds(new Rectangular(root.getBounds()));
            pageBox.move(0, theight);
            pageBox.setBackgroundSeparated(true);
            log.info("Rendered: {}x{}", (Object)pageBox.getWidth(), (Object)pageBox.getHeight());
            main.add((GenericTreeNode)pageBox);
            twidth = Math.max(twidth, pageBox.getWidth());
            theight += pageBox.getHeight();
        }
        main.setBounds(new Rectangular(0, 0, twidth, theight));
        main.setVisualBounds(new Rectangular(0, 0, twidth, theight));
        this.page.setRoot((org.fit.layout.model.Box)main);
        this.page.setWidth(twidth);
        this.page.setHeight(theight);
    }

    public void parse(String urlstring) throws MalformedURLException, IOException, SAXException {
        if ((urlstring = urlstring.trim()).startsWith("http:") || urlstring.startsWith("https:") || urlstring.startsWith("ftp:") || urlstring.startsWith("file:")) {
            this.parse(new URL(urlstring));
        } else if (urlstring.startsWith("list:")) {
            List<URL> list = this.loadList(urlstring.substring(5));
            this.parseList(list);
        } else {
            throw new MalformedURLException("Unsupported protocol in " + urlstring);
        }
    }

    public Page getPage() {
        return this.page;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    protected BrowserCanvas renderUrl(URL url, Dimension pageSize) throws IOException, SAXException {
        int p;
        DefaultDocumentSource src = new DefaultDocumentSource(url);
        this.pageUrl = src.getURL();
        InputStream is = src.getInputStream();
        String mime = src.getContentType();
        if (mime == null) {
            mime = "text/html";
        }
        if ((p = mime.indexOf(59)) != -1) {
            mime = mime.substring(0, p).trim();
        }
        log.info("File type: " + mime);
        if (mime.equals("application/pdf")) {
            PDDocument doc = this.loadPdf(is);
            PdfBrowserCanvas canvas = new PdfBrowserCanvas(doc, null, pageSize, src.getURL());
            doc.close();
            this.pageTitle = "";
            return canvas;
        }
        DefaultDOMSource parser = new DefaultDOMSource((DocumentSource)src);
        Document doc = parser.parse();
        this.pageTitle = this.findPageTitle(doc);
        String encoding = parser.getCharset();
        MediaSpec media = new MediaSpec("screen");
        DOMAnalyzer da = new DOMAnalyzer(doc, src.getURL());
        if (encoding == null) {
            encoding = da.getCharacterEncoding();
        }
        da.setDefaultEncoding(encoding);
        da.setMediaSpec(media);
        da.attributesToStyles();
        da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.addStyleSheet(null, CSSNorm.formsStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.getStyleSheets();
        BrowserCanvas contentCanvas = new BrowserCanvas(da.getRoot(), da, src.getURL());
        contentCanvas.getConfig().setLoadImages(false);
        contentCanvas.getConfig().setLoadBackgroundImages(false);
        contentCanvas.getConfig().setReplaceImagesWithAlt(this.replaceImagesWithAlt);
        contentCanvas.createLayout(pageSize);
        src.close();
        return contentCanvas;
    }

    private PDDocument loadPdf(InputStream is) throws IOException {
        PDDocument document = null;
        document = PDDocument.load((InputStream)is);
        return document;
    }

    private String findPageTitle(Document doc) {
        Element head;
        NodeList titles;
        NodeList heads = doc.getElementsByTagName("head");
        if (heads.getLength() > 0 && (titles = (head = (Element)heads.item(0)).getElementsByTagName("title")).getLength() > 0) {
            String ret = titles.item(0).getTextContent();
            return ret == null ? null : ret.trim();
        }
        return "";
    }

    protected BoxNode buildTree(ElementBox rootbox) {
        log.trace("LIST");
        Vector<BoxNode> boxlist = new Vector<BoxNode>();
        this.order_counter = 1;
        this.createBoxList((Box)rootbox, boxlist);
        if (this.useVisualBounds) {
            log.trace("A1");
            BoxNode root = this.createBoxTree(rootbox, boxlist, true, true, true);
            log.trace("A2");
            Color bg = rootbox.getBgcolor();
            if (bg == null) {
                bg = Color.WHITE;
            }
            this.computeBackgrounds(root, bg);
            log.trace("A2.5");
            root.recomputeVisualBounds();
            log.trace("A3");
            root = this.createBoxTree(rootbox, boxlist, true, true, this.preserveAux);
            root.recomputeVisualBounds();
            root.recomputeBounds();
            log.trace("A4");
            return root;
        }
        BoxNode root = this.createBoxTree(rootbox, boxlist, false, true, true);
        Color bg = rootbox.getBgcolor();
        if (bg == null) {
            bg = Color.WHITE;
        }
        this.computeBackgrounds(root, bg);
        root.recomputeVisualBounds();
        root.recomputeBounds();
        root.applyTransforms();
        return root;
    }

    private void createBoxList(Box root, Vector<BoxNode> list) {
        if (root.isDisplayed()) {
            if (!(root instanceof Viewport) && root.isVisible()) {
                BoxNode newnode = new BoxNode(root, (Page)this.page);
                newnode.setOrder(this.order_counter++);
                list.add(newnode);
            }
            if (root instanceof ElementBox) {
                ElementBox elem = (ElementBox)root;
                for (int i = elem.getStartChild(); i < elem.getEndChild(); ++i) {
                    this.createBoxList(elem.getSubBox(i), list);
                }
            }
        }
    }

    private BoxNode createBoxTree(ElementBox rootbox, Vector<BoxNode> boxlist, boolean useBounds, boolean useVisualBounds, boolean preserveAux) {
        Iterator<BoxNode> it;
        BoxNode node2;
        Vector<BoxNode> list = new Vector<BoxNode>(boxlist);
        BoxNode root = new BoxNode((Box)rootbox, (Page)this.page);
        root.setOrder(0);
        for (BoxNode node2 : list) {
            node2.removeFromTree();
        }
        if (!preserveAux) {
            it = list.iterator();
            while (it.hasNext()) {
                node2 = it.next();
                if (node2.isVisuallySeparated() && node2.isVisible()) continue;
                it.remove();
            }
        }
        for (BoxNode node2 : list) {
            if (useBounds) {
                node2.markNodesInside(list, useVisualBounds);
                continue;
            }
            node2.markChildNodes(list);
        }
        it = list.iterator();
        while (it.hasNext()) {
            node2 = it.next();
            if (!node2.isRootNode()) continue;
            root.add(node2);
            it.remove();
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            root.getChildBox(i).takeChildren(list);
        }
        return root;
    }

    private void computeBackgrounds(BoxNode root, Color currentbg) {
        Color newbg = root.getBackgroundColor();
        if (newbg == null) {
            newbg = currentbg;
        }
        root.setEfficientBackground(newbg);
        root.setBackgroundSeparated(!newbg.equals(currentbg));
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.computeBackgrounds(root.getChildBox(i), newbg);
        }
    }

    private List<URL> loadList(String filename) {
        ArrayList<URL> ret = new ArrayList<URL>();
        try {
            String line;
            BufferedReader read = new BufferedReader(new FileReader(filename));
            while ((line = read.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                ret.add(new URL(line));
            }
            read.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

