/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.fit.layout.impl.DefaultArea;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.Area;
import org.fit.layout.model.Box;
import org.fit.layout.model.ContentObject;
import org.fit.layout.model.Rectangular;
import org.fit.segm.grouping.AreaStyle;
import org.fit.segm.grouping.Config;
import org.fit.segm.grouping.op.Separator;
import org.fit.segm.grouping.op.SeparatorSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaImpl
extends DefaultArea
implements Area {
    private static Logger log = LoggerFactory.getLogger(AreaImpl.class);
    private SeparatorSet seps;
    private int level = 0;
    private boolean separated;
    private float fontSizeSum;
    private int fontSizeCnt;
    private float fontWeightSum;
    private int fontWeightCnt;
    private float fontStyleSum;
    private int fontStyleCnt;
    private float underlineSum;
    private int underlineCnt;
    private float lineThroughSum;
    private int lineThroughCnt;

    public AreaImpl(int x1, int y1, int x2, int y2) {
        this(new Rectangular(x1, y1, x2, y2));
    }

    public AreaImpl(Rectangular r) {
        super(r);
    }

    public AreaImpl(Box box) {
        super(box);
    }

    public AreaImpl(List<Box> boxList) {
        super(boxList);
    }

    public AreaImpl(AreaImpl src) {
        super((DefaultArea)src);
        this.level = src.level;
        this.fontSizeSum = src.fontSizeSum;
        this.fontSizeCnt = src.fontStyleCnt;
        this.fontStyleSum = src.fontStyleSum;
        this.fontStyleCnt = src.fontStyleCnt;
        this.fontWeightSum = src.fontWeightSum;
        this.fontWeightCnt = src.fontWeightCnt;
        this.underlineCnt = src.underlineCnt;
        this.underlineSum = src.underlineSum;
        this.lineThroughCnt = src.lineThroughCnt;
        this.lineThroughSum = src.lineThroughSum;
    }

    public void appendChild(Area child) {
        super.appendChild(child);
        this.updateAverages(child);
    }

    public void appendChildren(List<Area> list) {
        for (Area child : list) {
            this.appendChild(child);
        }
    }

    public void removeAllChildren() {
        super.removeAllChildren();
        this.resetAverages();
    }

    public void joinArea(AreaImpl other, Rectangular pos, boolean horizontal) {
        this.setGridPosition(pos);
        if (other.getChildCount() > 0) {
            Vector adopt = new Vector(other.getChildren());
            Iterator it = adopt.iterator();
            while (it.hasNext()) {
                this.appendChild((AreaImpl)((Object)it.next()));
            }
        }
        this.join(other, horizontal);
        for (Map.Entry entry : other.getTags().entrySet()) {
            if (this.getTags().containsKey(entry.getKey()) && !(((Float)entry.getValue()).floatValue() > ((Float)this.getTags().get(entry.getKey())).floatValue())) continue;
            this.getTags().put(entry.getKey(), entry.getValue());
        }
    }

    public void join(AreaImpl other, boolean horizontal) {
        this.getBounds().expandToEnclose(other.getBounds());
        this.setName(this.getName() + " . " + other.getName());
        if (horizontal) {
            if (this.getX1() <= other.getX1()) {
                if (other.hasRightBorder()) {
                    this.setRightBorder(other.getRightBorder());
                }
            } else if (other.hasLeftBorder()) {
                this.setLeftBorder(other.getLeftBorder());
            }
        } else if (this.getY1() <= other.getY1()) {
            if (other.hasBottomBorder()) {
                this.setBottomBorder(other.getBottomBorder());
            }
        } else if (other.hasTopBorder()) {
            this.setTopBorder(other.getTopBorder());
        }
        this.getBoxes().addAll(other.getBoxes());
        this.updateAverages(other);
        if (!this.hasSameBackground(other)) {
            System.err.println("Area: Warning: joining areas " + this.getName() + " and " + other.getName() + " of different background colors " + this.getBackgroundColor() + " x " + other.getBackgroundColor());
        }
    }

    public void joinChild(AreaImpl other) {
        for (Box box : other.getBoxes()) {
            this.addBox(box);
        }
        this.getBounds().expandToEnclose(other.getBounds());
        this.setName(this.getName() + " . " + other.getName());
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String toString() {
        String bs = "";
        if (this.hasTopBorder()) {
            bs = bs + "^";
        }
        if (this.hasLeftBorder()) {
            bs = bs + "<";
        }
        if (this.hasRightBorder()) {
            bs = bs + ">";
        }
        if (this.hasBottomBorder()) {
            bs = bs + "_";
        }
        if (this.isBackgroundSeparated()) {
            bs = bs + "*";
        }
        if (this.isHorizontalSeparator()) {
            bs = bs + "H";
        }
        if (this.isVerticalSeparator()) {
            bs = bs + "I";
        }
        bs = bs + " " + this.getId() + ": ";
        if (this.getName() != null) {
            return bs + " " + this.getName() + " " + this.getBounds().toString();
        }
        return bs + " <area> " + this.getBounds().toString();
    }

    public void chooseBox(Box node) {
        if (this.getBounds().encloses(node.getVisualBounds())) {
            this.addBox(node);
        }
    }

    public boolean hasSameBackground(AreaImpl other) {
        return this.getBackgroundColor() == null && other.getBackgroundColor() == null || this.getBackgroundColor() != null && other.getBackgroundColor() != null && this.getBackgroundColor().equals(other.getBackgroundColor());
    }

    public boolean encloses(AreaImpl other) {
        return this.getBounds().encloses(other.getBounds());
    }

    public boolean contains(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    public boolean hasContent() {
        return !this.getBoxes().isEmpty();
    }

    public Color getEffectiveBackgroundColor() {
        if (this.getBackgroundColor() != null) {
            return this.getBackgroundColor();
        }
        if (this.getParentArea() != null) {
            return this.getParentArea().getEffectiveBackgroundColor();
        }
        return Color.WHITE;
    }

    public boolean containsText() {
        for (Box root : this.getBoxes()) {
            if (!this.recursiveContainsText(root)) continue;
            return true;
        }
        return false;
    }

    private boolean recursiveContainsText(Box root) {
        if (root.getChildCount() == 0) {
            return root.getText().trim().length() > 0;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (!this.recursiveContainsText(root.getChildBox(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isReplaced() {
        boolean empty = true;
        for (Box root : this.getBoxes()) {
            empty = false;
            if (root.getType() == Box.Type.REPLACED_CONTENT) continue;
            return false;
        }
        return !empty;
    }

    public String getBoxText() {
        StringBuilder ret = new StringBuilder();
        boolean start = true;
        Iterator it = this.getBoxes().iterator();
        while (it.hasNext()) {
            if (!start) {
                ret.append(' ');
            } else {
                start = false;
            }
            ret.append(((Box)it.next()).getText());
        }
        return ret.toString();
    }

    public int getTextLength() {
        int ret = 0;
        for (Box box : this.getBoxes()) {
            ret += box.getText().length();
        }
        return ret;
    }

    public ContentObject getReplacedContent() {
        Iterator it = this.getBoxes().iterator();
        while (it.hasNext()) {
            ContentObject obj = this.recursiveGetReplacedContent((Box)it.next());
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    private ContentObject recursiveGetReplacedContent(Box root) {
        if (root.getChildCount() == 0) {
            return root.getContentObject();
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            ContentObject obj = this.recursiveGetReplacedContent(root.getChildBox(i));
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public boolean isHorizontalSeparator() {
        return (this.getBounds().getHeight() < 10 && this.getBounds().getWidth() > 20 * this.getBounds().getHeight() || this.getBounds().getHeight() < 3 && this.getBounds().getWidth() > 6) && (this.separatedUp() || this.separatedDown()) && !this.containsText();
    }

    public boolean isVerticalSeparator() {
        return (this.getBounds().getWidth() < 10 && this.getBounds().getHeight() > 20 * this.getBounds().getWidth() || this.getBounds().getWidth() < 3 && this.getBounds().getHeight() > 6) && (this.separatedLeft() || this.separatedRight()) && !this.containsText();
    }

    public Area createSuperArea(Rectangular gp, List<Area> selected, String name) {
        AreaImpl area = new AreaImpl(this.getX1() + this.getGrid().getColOfs(gp.getX1()), this.getY1() + this.getGrid().getRowOfs(gp.getY1()), this.getX1() + this.getGrid().getColOfs(gp.getX2() + 1) - 1, this.getY1() + this.getGrid().getRowOfs(gp.getY2() + 1) - 1);
        area.setName(name);
        area.setPage(this.getPage());
        if (this.getChildCount() > 0 && selected.size() > 0) {
            int index = this.getIndex(selected.get(0));
            this.insertChild(area, index);
        } else {
            this.appendChild(area);
        }
        area.appendChildren(selected);
        area.createGrid();
        this.createGrid();
        return area;
    }

    public Area copy() {
        AreaImpl ret = new AreaImpl(this);
        if (this.getParentArea() != null) {
            int ndx = this.getParentArea().getIndex((Object)this);
            this.getParentArea().insertChild((Object)ret, ndx + 1);
        }
        return ret;
    }

    public float getDeclaredFontSize() {
        if (this.getBoxes().size() > 0) {
            return ((Box)this.getBoxes().firstElement()).getFontSize();
        }
        return 0.0f;
    }

    public float getFontSize() {
        if (this.fontSizeCnt == 0) {
            return 0.0f;
        }
        return this.fontSizeSum / (float)this.fontSizeCnt;
    }

    public float getFontWeight() {
        if (this.fontWeightCnt == 0) {
            return 0.0f;
        }
        return this.fontWeightSum / (float)this.fontWeightCnt;
    }

    public float getFontStyle() {
        if (this.fontStyleCnt == 0) {
            return 0.0f;
        }
        return this.fontStyleSum / (float)this.fontStyleCnt;
    }

    public float getUnderline() {
        if (this.underlineCnt == 0) {
            return 0.0f;
        }
        return this.underlineSum / (float)this.underlineCnt;
    }

    public float getLineThrough() {
        if (this.lineThroughCnt == 0) {
            return 0.0f;
        }
        return this.lineThroughSum / (float)this.lineThroughCnt;
    }

    public float getColorLuminosity() {
        if (this.getBoxes().isEmpty()) {
            return 0.0f;
        }
        float sum = 0.0f;
        int len = 0;
        for (Box box : this.getBoxes()) {
            int l = box.getText().length();
            sum += this.colorLuminosity(box.getColor()) * (float)l;
            len += l;
        }
        return sum / (float)len;
    }

    public void updateAverages(Area other) {
        if (other instanceof AreaImpl) {
            this.fontSizeCnt += ((AreaImpl)other).fontSizeCnt;
            this.fontSizeSum += ((AreaImpl)other).fontSizeSum;
            this.fontWeightCnt += ((AreaImpl)other).fontWeightCnt;
            this.fontWeightSum += ((AreaImpl)other).fontWeightSum;
            this.fontStyleCnt += ((AreaImpl)other).fontStyleCnt;
            this.fontStyleSum += ((AreaImpl)other).fontStyleSum;
            this.underlineCnt += ((AreaImpl)other).underlineCnt;
            this.underlineSum += ((AreaImpl)other).underlineSum;
            this.lineThroughCnt += ((AreaImpl)other).lineThroughCnt;
            this.lineThroughSum += ((AreaImpl)other).lineThroughSum;
        } else {
            log.error("FIXME: mixing AreaImpl with other area implementations is not implemented now; the averages won't be accurate!");
        }
    }

    protected void resetAverages() {
        this.fontSizeCnt = 0;
        this.fontSizeSum = 0.0f;
        this.fontWeightCnt = 0;
        this.fontWeightSum = 0.0f;
        this.fontStyleCnt = 0;
        this.fontStyleSum = 0.0f;
        this.underlineCnt = 0;
        this.underlineSum = 0.0f;
        this.lineThroughCnt = 0;
        this.lineThroughSum = 0.0f;
        for (Box box : this.getBoxes()) {
            this.updateAveragesForBox(box);
        }
    }

    public String getText() {
        String ret = "";
        if (this.isLeaf()) {
            ret = this.getBoxText();
        } else {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ret = ret + this.getChildArea(i).getText();
            }
        }
        return ret;
    }

    public List<Area> getChildNodesInside(Rectangular r) {
        ArrayList<Area> ret = new ArrayList<Area>();
        for (GenericTreeNode child : this.getChildren()) {
            Area childarea = (Area)child;
            if (!childarea.getBounds().intersects(r)) continue;
            ret.add(childarea);
        }
        return ret;
    }

    public boolean isAreaEmpty(Rectangular r) {
        for (GenericTreeNode child : this.getChildren()) {
            Area childarea = (Area)child;
            if (!childarea.getBounds().intersects(r)) continue;
            return false;
        }
        return true;
    }

    public void createSeparators() {
        this.seps = Config.createSeparators(this);
    }

    public SeparatorSet getSeparators() {
        return this.seps;
    }

    public void removeSimpleSeparators() {
        this.removeSimpleSeparators(this.seps.getHorizontal());
        this.removeSimpleSeparators(this.seps.getVertical());
        this.removeSimpleSeparators(this.seps.getBoxsep());
    }

    private void removeSimpleSeparators(Vector<Separator> v) {
        Iterator<Separator> it = v.iterator();
        while (it.hasNext()) {
            int b;
            int a;
            Separator sep = it.next();
            if (sep.getType() == 0 || sep.getType() == 2) {
                a = this.countAreasAbove(sep);
                b = this.countAreasBelow(sep);
                if (a > 1 || b > 1) continue;
                it.remove();
                continue;
            }
            a = this.countAreasLeft(sep);
            b = this.countAreasRight(sep);
            if (a > 1 || b > 1) continue;
            it.remove();
        }
    }

    private int countAreasAbove(Separator sep) {
        int gx1 = this.getGrid().findCellX(sep.getX1());
        int gx2 = this.getGrid().findCellX(sep.getX2());
        int gy = this.getGrid().findCellY(sep.getY1() - 1);
        int ret = 0;
        if (gx1 >= 0 && gx2 >= 0 && gy >= 0) {
            int i = gx1;
            while (i <= gx2) {
                AreaImpl node = (AreaImpl)this.getGrid().getAreaAt(i, gy);
                if (node != null) {
                    ++ret;
                    i += node.getGridWidth();
                    continue;
                }
                ++i;
            }
        }
        return ret;
    }

    private int countAreasBelow(Separator sep) {
        int gx1 = this.getGrid().findCellX(sep.getX1());
        int gx2 = this.getGrid().findCellX(sep.getX2());
        int gy = this.getGrid().findCellY(sep.getY2() + 1);
        int ret = 0;
        if (gx1 >= 0 && gx2 >= 0 && gy >= 0) {
            int i = gx1;
            while (i <= gx2) {
                AreaImpl node = (AreaImpl)this.getGrid().getAreaAt(i, gy);
                if (node != null) {
                    ++ret;
                    i += node.getGridWidth();
                    continue;
                }
                ++i;
            }
        }
        return ret;
    }

    private int countAreasLeft(Separator sep) {
        int gy1 = this.getGrid().findCellY(sep.getY1());
        int gy2 = this.getGrid().findCellY(sep.getY2());
        int gx = this.getGrid().findCellX(sep.getX1() - 1);
        int ret = 0;
        if (gy1 >= 0 && gy2 >= 0 && gx >= 0) {
            int i = gy1;
            while (i <= gy2) {
                AreaImpl node = (AreaImpl)this.getGrid().getAreaAt(gx, i);
                if (node != null) {
                    ++ret;
                    i += node.getGridWidth();
                    continue;
                }
                ++i;
            }
        }
        return ret;
    }

    private int countAreasRight(Separator sep) {
        int gy1 = this.getGrid().findCellY(sep.getY1());
        int gy2 = this.getGrid().findCellY(sep.getY2());
        int gx = this.getGrid().findCellX(sep.getX2() + 1);
        int ret = 0;
        if (gy1 >= 0 && gy2 >= 0 && gx >= 0) {
            int i = gy1;
            while (i <= gy2) {
                AreaImpl node = (AreaImpl)this.getGrid().getAreaAt(gx, i);
                if (node != null) {
                    ++ret;
                    i += node.getGridWidth();
                    continue;
                }
                ++i;
            }
        }
        return ret;
    }

    public AreaImpl findContentAbove(Separator sep) {
        return this.recursiveFindAreaAbove(sep.getX1(), sep.getX2(), 0, sep.getY1());
    }

    private AreaImpl recursiveFindAreaAbove(int x1, int x2, int y1, int y2) {
        AreaImpl ret = null;
        int maxx = x2;
        int miny = y1;
        Vector boxes = this.getBoxes();
        for (Box box : boxes) {
            int bx = box.getBounds().getX1();
            int by = box.getBounds().getY2();
            if (bx < x1 || bx > x2 || by >= y2 || by <= miny && (by != miny || bx >= maxx)) continue;
            ret = this;
            if (bx < maxx) {
                maxx = bx;
            }
            if (by <= miny) continue;
            miny = by;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            AreaImpl child = (AreaImpl)this.getChildArea(i);
            AreaImpl area = child.recursiveFindAreaAbove(x1, x2, miny, y2);
            if (area == null) continue;
            int bx = area.getX1();
            int by = area.getY2();
            int len = area.getText().length();
            if (len <= 0 || by <= miny && (by != miny || bx >= maxx)) continue;
            ret = area;
            if (bx < maxx) {
                maxx = bx;
            }
            if (by <= miny) continue;
            miny = by;
        }
        return ret;
    }

    public void addBox(Box box) {
        super.addBox(box);
        this.updateAveragesForBox(box);
    }

    private void updateAveragesForBox(Box box) {
        int len;
        if (box.getType() == Box.Type.TEXT_CONTENT && (len = box.getText().trim().length()) > 0) {
            this.fontSizeSum += this.getAverageBoxFontSize(box) * (float)len;
            this.fontSizeCnt += len;
            this.fontWeightSum += this.getAverageBoxFontWeight(box) * (float)len;
            this.fontWeightCnt += len;
            this.fontStyleSum += this.getAverageBoxFontStyle(box) * (float)len;
            this.fontStyleCnt += len;
        }
    }

    private float getAverageBoxFontSize(Box box) {
        if (box.getType() == Box.Type.TEXT_CONTENT) {
            return box.getFontSize();
        }
        if (box.getType() == Box.Type.REPLACED_CONTENT) {
            return 0.0f;
        }
        float sum = 0.0f;
        int cnt = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = box.getChildBox(i);
            String text = child.getText().trim();
            cnt += text.length();
            sum += this.getAverageBoxFontSize(child);
        }
        if (cnt > 0) {
            return sum / (float)cnt;
        }
        return 0.0f;
    }

    private float getAverageBoxFontWeight(Box box) {
        if (box.getType() == Box.Type.TEXT_CONTENT) {
            return box.getFontWeight();
        }
        if (box.getType() == Box.Type.REPLACED_CONTENT) {
            return 0.0f;
        }
        float sum = 0.0f;
        int cnt = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = box.getChildBox(i);
            String text = child.getText().trim();
            cnt += text.length();
            sum += this.getAverageBoxFontWeight(child);
        }
        if (cnt > 0) {
            return sum / (float)cnt;
        }
        return 0.0f;
    }

    private float getAverageBoxFontStyle(Box box) {
        if (box.getType() == Box.Type.TEXT_CONTENT) {
            return box.getFontStyle();
        }
        if (box.getType() == Box.Type.REPLACED_CONTENT) {
            return 0.0f;
        }
        float sum = 0.0f;
        int cnt = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = box.getChildBox(i);
            String text = child.getText().trim();
            cnt += text.length();
            sum += this.getAverageBoxFontStyle(child);
        }
        if (cnt > 0) {
            return sum / (float)cnt;
        }
        return 0.0f;
    }

    private float colorLuminosity(Color c) {
        float lr;
        float lg;
        float lb;
        if (c == null) {
            lb = 255.0f;
            lg = 255.0f;
            lr = 255.0f;
        } else {
            lr = (float)Math.pow((float)c.getRed() / 255.0f, 2.2f);
            lg = (float)Math.pow((float)c.getGreen() / 255.0f, 2.2f);
            lb = (float)Math.pow((float)c.getBlue() / 255.0f, 2.2f);
        }
        return lr * 0.2126f + lg * 0.7152f + lb * 0.0722f;
    }

    public boolean separatedDown() {
        return this.hasBottomBorder() || this.isBackgroundSeparated();
    }

    public boolean separatedUp() {
        return this.hasTopBorder() || this.isBackgroundSeparated();
    }

    public boolean separatedLeft() {
        return this.hasLeftBorder() || this.isBackgroundSeparated();
    }

    public boolean separatedRight() {
        return this.hasRightBorder() || this.isBackgroundSeparated();
    }

    public boolean isExplicitlySeparated() {
        return this.separated;
    }

    public void setSeparated(boolean separated) {
        this.separated = separated;
    }

    public AreaStyle getStyle() {
        return new AreaStyle(this);
    }

    public boolean hasSameStyle(AreaImpl other) {
        return this.getStyle().isSameStyle(other.getStyle());
    }
}

