/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping;

import java.util.Vector;
import org.fit.layout.model.Area;
import org.fit.layout.model.Box;
import org.fit.layout.model.Rectangular;
import org.fit.segm.grouping.AreaImpl;

public class AreaUtils {
    public static boolean isNeighbor(Area a1, Area a2) {
        if (AreaUtils.isOnSameLine(a1, a2)) {
            return true;
        }
        int dy = a2.getBounds().getY1() - a1.getBounds().getY2();
        if (dy < 0) {
            dy = a1.getBounds().getY1() - a2.getBounds().getY2();
        }
        return dy < a1.getBounds().getHeight() / 2;
    }

    public static boolean isOnSameLine(Area a1, Area a2) {
        return AreaUtils.isOnSameLine(a1, a2, 1);
    }

    public static boolean isOnSameLine(Area a1, Area a2, int threshold) {
        Rectangular gp1 = a1.getBounds();
        Rectangular gp2 = a2.getBounds();
        return Math.abs(gp1.getY1() - gp2.getY1()) <= threshold && Math.abs(gp1.getY2() - gp2.getY2()) <= threshold;
    }

    public static boolean isOnSameLineRoughly(Area a1, Area a2) {
        Rectangular gp1 = a1.getBounds();
        Rectangular gp2 = a2.getBounds();
        return gp2.getY1() >= gp1.getY1() && gp2.getY1() < gp1.getY2() || gp2.getY2() > gp1.getY1() && gp2.getY2() <= gp1.getY2();
    }

    public static boolean isInSameColumn(Area a1, Area a2) {
        Rectangular gp1 = a1.getTopology().getPosition();
        Rectangular gp2 = a2.getTopology().getPosition();
        return gp1.getX1() == gp2.getX1();
    }

    public static boolean isAligned(Area a1, Area a2) {
        Rectangular gp1 = a1.getTopology().getPosition();
        Rectangular gp2 = a2.getTopology().getPosition();
        return gp1.getX1() == gp2.getX1() || gp1.getY1() == gp2.getY1();
    }

    public static boolean isLink(Area a) {
        for (Box box : a.getBoxes()) {
            if (box.getAttribute("href") == null) continue;
            return true;
        }
        return false;
    }

    public static Area createSuperAreaFromVerticalRegion(Area root, Rectangular region) {
        int first = -1;
        int last = -1;
        Rectangular bounds = null;
        Vector<Object> selected = new Vector<Object>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            Rectangular pos = ((Area)root.getChildArea(i)).getBounds();
            if (region.enclosesY(pos)) {
                if (first == -1) {
                    first = i;
                }
                last = i;
                selected.add(root.getChildArea(i));
                if (bounds == null) {
                    bounds = new Rectangular(pos);
                    continue;
                }
                bounds.expandToEnclose(pos);
                continue;
            }
            if (first != -1) break;
        }
        if (last > first) {
            AreaImpl ret = new AreaImpl(bounds);
            root.insertChild((Object)ret, first);
            for (Area area : selected) {
                ret.appendChild(area);
            }
            ((AreaImpl)root).createGrid();
            ret.createGrid();
            return ret;
        }
        return null;
    }
}

