/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fit.layout.impl.DefaultAreaTree;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Box;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;
import org.fit.layout.model.Tag;
import org.fit.segm.grouping.AreaImpl;

public class SegmentationAreaTree
extends DefaultAreaTree {
    private boolean preserveAuxAreas;

    public SegmentationAreaTree(Page srcpage, boolean preserveAuxAreas) {
        super(srcpage);
        this.preserveAuxAreas = preserveAuxAreas;
        AreaImpl rootarea = new AreaImpl(0, 0, 0, 0);
        rootarea.setAreaTree((AreaTree)this);
        rootarea.setPage(srcpage);
        this.setRoot(rootarea);
    }

    public Area findBasicAreas() {
        AreaImpl rootarea = new AreaImpl(0, 0, 0, 0);
        this.setRoot(rootarea);
        rootarea.setAreaTree((AreaTree)this);
        rootarea.setPage(this.page);
        for (int i = 0; i < this.page.getRoot().getChildCount(); ++i) {
            Box cbox = this.page.getRoot().getChildBox(i);
            AreaImpl sub = new AreaImpl(cbox);
            if (sub.getWidth() <= 1 && sub.getHeight() <= 1) continue;
            this.findStandaloneAreas(this.page.getRoot().getChildBox(i), sub);
            rootarea.appendChild(sub);
        }
        this.createGrids(rootarea);
        return rootarea;
    }

    public Area createArea(Rectangular r) {
        return new AreaImpl(r);
    }

    public Area createArea(Box box) {
        return new AreaImpl(box);
    }

    public Area createArea(List<Box> boxes) {
        return new AreaImpl(boxes);
    }

    private void findStandaloneAreas(Box boxroot, Area arearoot) {
        if (boxroot.isVisible()) {
            for (int i = 0; i < boxroot.getChildCount(); ++i) {
                Box child = boxroot.getChildBox(i);
                if (!child.isVisible()) continue;
                if (this.isVisuallySeparated(child)) {
                    AreaImpl newnode = new AreaImpl(child);
                    if (newnode.getWidth() <= 1 && newnode.getHeight() <= 1) continue;
                    this.findStandaloneAreas(child, newnode);
                    arearoot.appendChild((Object)newnode);
                    continue;
                }
                this.findStandaloneAreas(child, arearoot);
            }
        }
    }

    public void updateTopologies() {
        this.createGrids((AreaImpl)this.getRoot());
    }

    protected void createGrids(AreaImpl root) {
        root.createGrid();
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.createGrids((AreaImpl)root.getChildArea(i));
        }
    }

    public boolean isVisuallySeparated(Box box) {
        if (!box.isVisible()) {
            return false;
        }
        if (box.getParentBox() == null) {
            return true;
        }
        if (box.getType() == Box.Type.TEXT_CONTENT) {
            return !box.getText().trim().isEmpty();
        }
        if (box.getType() == Box.Type.REPLACED_CONTENT) {
            return true;
        }
        if (box.getDisplayType() == Box.DisplayType.LIST_ITEM) {
            return true;
        }
        if (this.preserveAuxAreas) {
            return true;
        }
        if (box.getBorderCount() >= 1) {
            return true;
        }
        return box.isBackgroundSeparated();
    }

    public Set<Tag> getUsedTags() {
        HashSet<Tag> ret = new HashSet<Tag>();
        this.recursiveGetTags(this.getRoot(), ret);
        return ret;
    }

    private void recursiveGetTags(Area root, Set<Tag> dest) {
        dest.addAll(root.getTags().keySet());
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveGetTags((Area)root.getChildArea(i), dest);
        }
    }
}

