/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.fit.layout.gui.AreaSelectionListener;
import org.fit.layout.gui.Browser;
import org.fit.layout.gui.BrowserPlugin;
import org.fit.layout.model.Area;
import org.fit.layout.model.Rectangular;
import org.fit.segm.grouping.AreaImpl;
import org.fit.segm.grouping.Config;
import org.fit.segm.grouping.op.Separator;
import org.fit.segm.grouping.op.SeparatorSet;

public class SegmentatorPlugin
implements BrowserPlugin,
AreaSelectionListener {
    private Browser browser;
    private JPanel sepListPanel;
    private JScrollPane sepScroll;
    private JList<Separator> sepList;
    private JToolBar showToolBar;
    private JButton showSepButton;
    private JButton gridButton = null;

    public boolean init(Browser browser) {
        this.browser = browser;
        this.initGui();
        return true;
    }

    private void initGui() {
        this.browser.addStructurePanel("Separators", (JComponent)this.getSepListPanel());
        this.browser.addToolBar(this.getShowToolBar());
        this.browser.addAreaSelectionListener((AreaSelectionListener)this);
    }

    public void areaSelected(Area area) {
        if (area instanceof AreaImpl) {
            SeparatorSet sset = Config.createSeparators((AreaImpl)area);
            DefaultListModel<Separator> ml = new DefaultListModel<Separator>();
            for (Separator sep : sset.getHorizontal()) {
                ml.addElement(sep);
            }
            for (Separator sep : sset.getVertical()) {
                ml.addElement(sep);
            }
            for (Separator sep : sset.getBoxsep()) {
                ml.addElement(sep);
            }
            this.sepList.setModel(ml);
        } else {
            this.sepList.setModel(new DefaultListModel());
        }
    }

    private void drawSeparator(Separator sep) {
        Color color = sep.isHorizontal() ? Color.BLUE : Color.RED;
        this.browser.getOutputDisplay().drawRectangle((Rectangular)sep, color);
    }

    private void showSeparators() {
        ListModel<Separator> ml = this.sepList.getModel();
        for (int i = 0; i < ml.getSize(); ++i) {
            this.drawSeparator(ml.getElementAt(i));
        }
        this.browser.updateDisplay();
    }

    private JPanel getSepListPanel() {
        if (this.sepListPanel == null) {
            GridLayout gridLayout3 = new GridLayout();
            gridLayout3.setRows(1);
            gridLayout3.setColumns(1);
            this.sepListPanel = new JPanel();
            this.sepListPanel.setLayout(gridLayout3);
            this.sepListPanel.add((Component)this.getSepScroll(), null);
        }
        return this.sepListPanel;
    }

    private JScrollPane getSepScroll() {
        if (this.sepScroll == null) {
            this.sepScroll = new JScrollPane();
            this.sepScroll.setViewportView(this.getSepList());
        }
        return this.sepScroll;
    }

    private JList<Separator> getSepList() {
        if (this.sepList == null) {
            this.sepList = new JList();
            this.sepList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Separator sep = (Separator)SegmentatorPlugin.this.sepList.getSelectedValue();
                    if (sep != null) {
                        SegmentatorPlugin.this.drawSeparator(sep);
                        SegmentatorPlugin.this.browser.updateDisplay();
                    }
                }
            });
        }
        return this.sepList;
    }

    private JToolBar getShowToolBar() {
        if (this.showToolBar == null) {
            this.showToolBar = new JToolBar("Segmentation");
            this.showToolBar.add(this.getShowSepButton());
            this.showToolBar.add(this.getGridButton());
        }
        return this.showToolBar;
    }

    private JButton getShowSepButton() {
        if (this.showSepButton == null) {
            this.showSepButton = new JButton();
            this.showSepButton.setText("Separators");
            this.showSepButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SegmentatorPlugin.this.showSeparators();
                }
            });
        }
        return this.showSepButton;
    }

    private JButton getGridButton() {
        if (this.gridButton == null) {
            this.gridButton = new JButton();
            this.gridButton.setText("Show grid");
            this.gridButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Area node = SegmentatorPlugin.this.browser.getSelectedArea();
                    if (node != null) {
                        node.getTopology().drawLayout(SegmentatorPlugin.this.browser.getOutputDisplay());
                        SegmentatorPlugin.this.browser.updateDisplay();
                    }
                }
            });
        }
        return this.gridButton;
    }
}

