/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.op;

import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.segm.grouping.AreaImpl;

public class CollapseAreasOperator
extends BaseOperator {
    protected final String[] paramNames = new String[0];
    protected final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[0];

    public String getId() {
        return "FitLayout.Segm.CollapseAreas";
    }

    public String getName() {
        return "Collapse areas";
    }

    public String getDescription() {
        return "Collapses the areas having only one (leaf) child.";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public void apply(AreaTree atree) {
        this.recursiveCollapseAreas((AreaImpl)atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.recursiveCollapseAreas((AreaImpl)root);
    }

    private void recursiveCollapseAreas(AreaImpl root) {
        if (this.canCollapse(root)) {
            this.recursiveCollapseSubtree(root, root);
            root.removeAllChildren();
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.recursiveCollapseAreas((AreaImpl)root.getChildArea(i));
            }
        }
    }

    private boolean canCollapse(AreaImpl area) {
        return area.getChildCount() == 1 && area.getChildArea(0).isLeaf();
    }

    private void recursiveCollapseSubtree(AreaImpl src, AreaImpl dest) {
        for (int i = 0; i < src.getChildCount(); ++i) {
            AreaImpl child = (AreaImpl)src.getChildArea(i);
            this.recursiveCollapseSubtree(child, dest);
            dest.joinChild(child);
        }
    }
}

