/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.op;

import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Rectangular;
import org.fit.segm.grouping.AreaImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindLineOperator
extends BaseOperator {
    private static Logger log = LoggerFactory.getLogger(FindLineOperator.class);
    protected boolean useConsistentStyle;
    protected float maxLineEmSpace;
    protected final String[] paramNames = new String[]{"useConsistentStyle", "maxLineEmSpace"};
    protected final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.BOOLEAN, ParametrizedOperation.ValueType.FLOAT};

    public FindLineOperator() {
        this.useConsistentStyle = false;
        this.maxLineEmSpace = 1.5f;
    }

    public FindLineOperator(boolean useConsistentStyle, float maxLineEmSpace) {
        this.useConsistentStyle = useConsistentStyle;
        this.maxLineEmSpace = maxLineEmSpace;
    }

    public String getId() {
        return "FitLayout.Segm.FindLines";
    }

    public String getName() {
        return "Find lines";
    }

    public String getDescription() {
        return "...";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public boolean getUseConsistentStyle() {
        return this.useConsistentStyle;
    }

    public void setUseConsistentStyle(boolean useConsistentStyle) {
        this.useConsistentStyle = useConsistentStyle;
    }

    public float getMaxLineEmSpace() {
        return this.maxLineEmSpace;
    }

    public void setMaxLineEmSpace(float maxLineEmSpace) {
        this.maxLineEmSpace = maxLineEmSpace;
    }

    public void apply(AreaTree atree) {
        this.recursiveJoinAreas((AreaImpl)atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.recursiveJoinAreas((AreaImpl)root);
    }

    protected void recursiveJoinAreas(AreaImpl root) {
        this.joinAreas(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveJoinAreas((AreaImpl)root.getChildArea(i));
        }
    }

    protected void joinAreas(AreaImpl a) {
        if (a.getGrid() == null) {
            a.createGrid();
        }
        boolean change = true;
        block0: while (change) {
            change = false;
            for (int i = 0; i < a.getChildCount(); ++i) {
                AreaImpl node = (AreaImpl)a.getChildArea(i);
                int ny1 = node.getGridPosition().getY1();
                int nx2 = node.getGridPosition().getX2();
                int ny2 = node.getGridPosition().getY2();
                AreaImpl neigh = null;
                int dist = 1;
                while (neigh == null && nx2 + dist < a.getGrid().getWidth()) {
                    for (int y = ny1; neigh == null && y <= ny2; ++y) {
                        neigh = (AreaImpl)a.getGrid().getAreaAt(nx2 + dist, y);
                        if (neigh == null) continue;
                        if (!this.useConsistentStyle || node.hasSameStyle(neigh)) {
                            if (!this.horizontalJoin(a, node, neigh, true)) continue;
                            node.createGrid();
                            change = true;
                            continue;
                        }
                        if (!this.horizontalJoin(a, node, neigh, false)) continue;
                        node.setNextOnLine(neigh);
                        neigh.setPreviousOnLine(node);
                    }
                    ++dist;
                }
                if (change) continue block0;
            }
        }
    }

    private boolean horizontalJoin(AreaImpl parent, AreaImpl n1, AreaImpl n2, boolean affect) {
        int dist = Math.min(Math.abs(n2.getX1() - n1.getX2()), Math.abs(n1.getX1() - n2.getX2()));
        if ((float)dist > n1.getFontSize() * this.maxLineEmSpace) {
            return false;
        }
        if (n1.hasRightBorder() || n2.hasLeftBorder() || !n1.hasSameBackground(n2)) {
            return false;
        }
        int sy1 = n1.getGridPosition().getY1();
        int sy2 = n2.getGridPosition().getY1();
        while (sy1 != sy2) {
            if (sy1 < sy2) {
                if (sy2 > 0 && this.canExpandY(parent, n2, sy2 - 1, n1)) {
                    --sy2;
                    continue;
                }
                return false;
            }
            if (sy1 <= sy2) continue;
            if (sy1 > 0 && this.canExpandY(parent, n1, sy1 - 1, n2)) {
                --sy1;
                continue;
            }
            return false;
        }
        int ey1 = n1.getGridPosition().getY2();
        int ey2 = n2.getGridPosition().getY2();
        while (ey1 != ey2) {
            if (ey1 < ey2) {
                if (ey1 < parent.getGrid().getWidth() - 1 && this.canExpandY(parent, n1, ey1 + 1, n2)) {
                    ++ey1;
                    continue;
                }
                return false;
            }
            if (ey1 <= ey2) continue;
            if (ey2 < parent.getGrid().getWidth() - 1 && this.canExpandY(parent, n2, ey2 + 1, n1)) {
                ++ey2;
                continue;
            }
            return false;
        }
        if (affect) {
            log.debug("Join: {} + {}", (Object)n1, (Object)n2);
            Rectangular newpos = new Rectangular(n1.getGridPosition().getX1(), sy1, n2.getGridPosition().getX2(), ey1);
            n1.joinArea(n2, newpos, true);
            parent.removeChild(n2);
        }
        return true;
    }

    private boolean canExpandY(AreaImpl parent, AreaImpl node, int y, AreaImpl except) {
        for (int x = node.getGridX(); x < node.getGridX() + node.getGridWidth(); ++x) {
            AreaImpl cand = (AreaImpl)parent.getGrid().getAreaAt(x, y);
            if (cand == null || cand == except) continue;
            return false;
        }
        return true;
    }
}

