/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.op;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;

public class FlattenTreeOperator
extends BaseOperator {
    protected final String[] paramNames = new String[0];
    protected final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[0];

    public String getId() {
        return "FitLayout.Segm.FlattenTree";
    }

    public String getName() {
        return "Flatten tree";
    }

    public String getDescription() {
        return "...";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        LinkedList<Area> addList = new LinkedList<Area>();
        LinkedList<Area> removeList = new LinkedList<Area>();
        this.scanAreas(root, addList, removeList);
        for (Area area : addList) {
            root.appendChild((Object)area);
        }
        this.removeAreas(root, removeList);
    }

    private void scanAreas(Area root, List<Area> addList, List<Area> removeList) {
        if (root.getParentArea() != null) {
            if (root.isLeaf()) {
                addList.add(root);
            } else {
                removeList.add(root);
            }
        }
        for (Area child : root.getChildAreas()) {
            this.scanAreas(child, addList, removeList);
        }
    }

    private void removeAreas(Area root, List<Area> toRemove) {
        ArrayList curChildren = new ArrayList(root.getChildAreas());
        for (Area child : curChildren) {
            this.removeAreas(child, toRemove);
        }
        for (Area child : curChildren) {
            if (!toRemove.contains(child)) continue;
            root.removeChild((Object)child);
        }
        root.updateTopologies();
    }
}

