/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.op;

import java.util.LinkedList;
import java.util.Vector;
import org.fit.layout.model.Rectangular;
import org.fit.segm.grouping.AreaImpl;
import org.fit.segm.grouping.op.GroupAnalyzer;
import org.fit.segm.grouping.op.SeparatorSet;

public class GroupAnalyzerByFlooding
extends GroupAnalyzer {
    private SeparatorSet seps = null;

    public GroupAnalyzerByFlooding(AreaImpl parent) {
        super(parent);
    }

    @Override
    public AreaImpl findSuperArea(AreaImpl sub, Vector<AreaImpl> selected) {
        this.parent.createSeparators();
        this.seps = this.parent.getSeparators();
        System.out.println("************* Start: " + (Object)((Object)sub));
        Rectangular gp = sub.isExplicitlySeparated() ? sub.getGridPosition() : this.flood(sub.getGridPosition().getX1(), sub.getGridPosition().getY1());
        System.out.println("R: " + gp);
        gp.expandToEnclose(sub.getGridPosition());
        Rectangular mingp = null;
        selected.removeAllElements();
        for (int i = 0; i < this.parent.getChildCount(); ++i) {
            AreaImpl chld = (AreaImpl)this.parent.getChildArea(i);
            if (!gp.encloses(chld.getGridPosition())) continue;
            selected.add(chld);
            if (mingp == null) {
                mingp = new Rectangular(chld.getGridPosition());
                continue;
            }
            mingp.expandToEnclose(chld.getGridPosition());
        }
        System.out.println("Area: " + (Object)((Object)this.parent) + " Grid: " + this.getGrid() + " Mingp: " + mingp);
        AreaImpl area = new AreaImpl(this.parent.getX1() + this.getGrid().getColOfs(mingp.getX1()), this.parent.getY1() + this.getGrid().getRowOfs(mingp.getY1()), this.parent.getX1() + this.getGrid().getColOfs(mingp.getX2() + 1) - 1, this.parent.getY1() + this.getGrid().getRowOfs(mingp.getY2() + 1) - 1);
        area.setPage(sub.getPage());
        System.out.println("Found area: " + (Object)((Object)area));
        AreaImpl ret = new AreaImpl(area);
        ret.setSeparated(true);
        ret.setGridPosition(mingp);
        return ret;
    }

    private Rectangular flood(int x, int y) {
        boolean[][] visited = new boolean[this.getGrid().getWidth()][this.getGrid().getHeight()];
        boolean[][] filled = new boolean[this.getGrid().getWidth()][this.getGrid().getHeight()];
        for (int i = 0; i < this.getGrid().getWidth(); ++i) {
            for (int j = 0; j < this.getGrid().getHeight(); ++j) {
                visited[i][j] = false;
                filled[i][j] = false;
            }
        }
        visited[x][y] = true;
        visited[x + 1][y] = true;
        filled[x][y] = true;
        filled[x + 1][y] = true;
        LinkedList<Rectangular> queue = new LinkedList<Rectangular>();
        Rectangular ret = new Rectangular(x, y, x + 1, y);
        queue.offer(ret);
        while (!queue.isEmpty()) {
            Rectangular epos;
            Rectangular cur = (Rectangular)queue.poll();
            int sx = cur.getX1();
            int sy = cur.getY1();
            ret.expandToEnclose(cur);
            filled[sx][sy] = true;
            Rectangular spos = this.getGrid().getCellBoundsAbsolute(sx, sy);
            if (sy > 0 && this.canFlood(visited, filled, sx, sy, -1, true)) {
                visited[sx][sy - 1] = true;
                epos = this.getGrid().getCellBoundsAbsolute(sx, sy - 1);
                if (!this.seps.isSeparatorAt(spos.midX(), spos.getY1()) && !this.seps.isSeparatorAt(epos.midX(), epos.getY2())) {
                    queue.offer(new Rectangular(sx, sy - 1, sx, sy - 1));
                }
            }
            if (sy < this.getGrid().getHeight() - 1 && this.canFlood(visited, filled, sx, sy, 1, true)) {
                visited[sx][sy + 1] = true;
                epos = this.getGrid().getCellBoundsAbsolute(sx, sy + 1);
                if (!this.seps.isSeparatorAt(spos.midX(), spos.getY2()) && !this.seps.isSeparatorAt(epos.midX(), epos.getY1())) {
                    queue.offer(new Rectangular(sx, sy + 1, sx, sy + 1));
                }
            }
            if (sx > 0 && this.canFlood(visited, filled, sx, sy, -1, false)) {
                visited[sx - 1][sy] = true;
                epos = this.getGrid().getCellBoundsAbsolute(sx - 1, sy);
                if (!this.seps.isSeparatorAt(spos.getX1(), spos.midY()) && !this.seps.isSeparatorAt(epos.getX2(), epos.midY())) {
                    queue.offer(new Rectangular(sx - 1, sy, sx - 1, sy));
                }
            }
            if (sx >= this.getGrid().getWidth() - 1 || !this.canFlood(visited, filled, sx, sy, 1, false)) continue;
            visited[sx + 1][sy] = true;
            epos = this.getGrid().getCellBoundsAbsolute(sx + 1, sy);
            if (this.seps.isSeparatorAt(spos.getX2(), spos.midY()) || this.seps.isSeparatorAt(epos.getX1(), epos.midY())) continue;
            queue.offer(new Rectangular(sx + 1, sy, sx + 1, sy));
        }
        return ret;
    }

    private boolean canFlood(boolean[][] visited, boolean[][] filled, int x, int y, int dist, boolean vertical) {
        if (vertical) {
            if (visited[x][y + dist]) {
                return false;
            }
            if (!(x != 0 && filled[x - 1][y] || x != filled.length - 1 && filled[x + 1][y])) {
                return false;
            }
        } else {
            if (visited[x + dist][y]) {
                return false;
            }
            if (!(y != 0 && filled[x][y - 1] || y != filled[x].length - 1 && filled[x][y + 1])) {
                return false;
            }
        }
        return true;
    }
}

