/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.op;

import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Rectangular;
import org.fit.segm.grouping.AreaImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLineOperator
extends BaseOperator {
    private static Logger log = LoggerFactory.getLogger(MultiLineOperator.class);
    protected boolean useConsistentStyle;
    protected float maxLineEmSpace;
    protected final String[] paramNames = new String[]{"useConsistentStyle", "maxLineEmSpace"};
    protected final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.BOOLEAN, ParametrizedOperation.ValueType.FLOAT};

    public MultiLineOperator() {
        this.useConsistentStyle = false;
        this.maxLineEmSpace = 1.5f;
    }

    public MultiLineOperator(boolean useConsistentStyle, float maxLineEmSpace) {
        this.useConsistentStyle = useConsistentStyle;
        this.maxLineEmSpace = maxLineEmSpace;
    }

    public String getId() {
        return "FitLayout.Segm.MultiLine";
    }

    public String getName() {
        return "Group aligned lines";
    }

    public String getDescription() {
        return "...";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public boolean getUseConsistentStyle() {
        return this.useConsistentStyle;
    }

    public void setUseConsistentStyle(boolean useConsistentStyle) {
        this.useConsistentStyle = useConsistentStyle;
    }

    public float getMaxLineEmSpace() {
        return this.maxLineEmSpace;
    }

    public void setMaxLineEmSpace(float maxLineEmSpace) {
        this.maxLineEmSpace = maxLineEmSpace;
    }

    public void apply(AreaTree atree) {
        this.recursiveJoinAreas((AreaImpl)atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.recursiveJoinAreas((AreaImpl)root);
    }

    protected void recursiveJoinAreas(AreaImpl root) {
        this.joinAreas(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveJoinAreas((AreaImpl)root.getChildArea(i));
        }
    }

    protected void joinAreas(AreaImpl a) {
        if (a.getGrid() == null) {
            a.createGrid();
        }
        boolean change = true;
        block0: while (change) {
            change = false;
            for (int i = 0; i < a.getChildCount(); ++i) {
                AreaImpl node = (AreaImpl)a.getChildArea(i);
                int nx1 = node.getGridPosition().getX1();
                int nx2 = node.getGridPosition().getX2();
                int ny2 = node.getGridPosition().getY2();
                AreaImpl neigh = null;
                int dist = 1;
                while (neigh == null && ny2 + dist < a.getGrid().getHeight()) {
                    for (int x = nx1; neigh == null && x <= nx2; ++x) {
                        neigh = (AreaImpl)a.getGrid().getAreaAt(x, ny2 + dist);
                        if (neigh == null || this.useConsistentStyle && !node.hasSameStyle(neigh) || neigh.getGridPosition().getX1() != nx1 || !this.verticalJoin(a, node, neigh, true)) continue;
                        node.createGrid();
                        change = true;
                    }
                    ++dist;
                }
                if (change) continue block0;
            }
        }
    }

    private boolean verticalJoin(AreaImpl parent, AreaImpl n1, AreaImpl n2, boolean affect) {
        int dist = Math.min(Math.abs(n2.getY1() - n1.getY2()), Math.abs(n1.getY1() - n2.getY2()));
        if ((float)dist > n1.getFontSize() * this.maxLineEmSpace) {
            return false;
        }
        if (n1.hasBottomBorder() || n2.hasTopBorder() || !n1.hasSameBackground(n2)) {
            return false;
        }
        int sx1 = n1.getGridPosition().getX1();
        int sx2 = n2.getGridPosition().getX1();
        while (sx1 != sx2) {
            if (sx1 < sx2) {
                if (sx2 > 0 && this.canExpandX(parent, n2, sx2 - 1, n1)) {
                    --sx2;
                    continue;
                }
                return false;
            }
            if (sx1 <= sx2) continue;
            if (sx1 > 0 && this.canExpandX(parent, n1, sx1 - 1, n2)) {
                --sx1;
                continue;
            }
            return false;
        }
        int ex1 = n1.getGridPosition().getX2();
        int ex2 = n2.getGridPosition().getX2();
        while (ex1 != ex2) {
            if (ex1 < ex2) {
                if (ex1 < parent.getGrid().getHeight() - 1 && this.canExpandX(parent, n1, ex1 + 1, n2)) {
                    ++ex1;
                    continue;
                }
                return false;
            }
            if (ex1 <= ex2) continue;
            if (ex2 < parent.getGrid().getHeight() - 1 && this.canExpandX(parent, n2, ex2 + 1, n1)) {
                ++ex2;
                continue;
            }
            return false;
        }
        if (affect) {
            log.debug("VJoin: {} + {}", (Object)n1, (Object)n2);
            Rectangular newpos = new Rectangular(sx1, n1.getGridPosition().getY1(), ex1, n2.getGridPosition().getY2());
            n1.joinArea(n2, newpos, true);
            parent.removeChild(n2);
        }
        return true;
    }

    private boolean canExpandX(AreaImpl parent, AreaImpl node, int x, AreaImpl except) {
        for (int y = node.getGridY(); y < node.getGridY() + node.getGridHeight(); ++y) {
            AreaImpl cand = (AreaImpl)parent.getGrid().getAreaAt(x, y);
            if (cand == null || cand == except) continue;
            return false;
        }
        return true;
    }
}

