/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.op;

import org.fit.layout.model.Rectangular;
import org.fit.segm.grouping.AreaImpl;

public class Separator
extends Rectangular
implements Comparable<Separator> {
    public static final short HORIZONTAL = 0;
    public static final short VERTICAL = 1;
    public static final short BOXH = 2;
    public static final short BOXV = 3;
    protected short type;
    protected AreaImpl area1;
    protected AreaImpl area2;

    public Separator(short type, int x1, int y1, int x2, int y2) {
        super(x1, y1, x2, y2);
        this.type = type;
        this.area1 = null;
        this.area2 = null;
    }

    public Separator(Separator orig) {
        super((Rectangular)orig);
        this.type = orig.type;
        this.area1 = orig.area1;
        this.area2 = orig.area2;
    }

    public Separator(short type, Rectangular rect) {
        super(rect);
        this.type = type;
        this.area1 = null;
        this.area2 = null;
    }

    public short getType() {
        return this.type;
    }

    public void setType(short type) {
        this.type = type;
    }

    public boolean isBoxSep() {
        return this.type == 2 || this.type == 3;
    }

    public AreaImpl getArea1() {
        return this.area1;
    }

    public void setArea1(AreaImpl area1) {
        this.area1 = area1;
    }

    public AreaImpl getArea2() {
        return this.area2;
    }

    public void setArea2(AreaImpl area2) {
        this.area2 = area2;
    }

    public String toString() {
        String t = "?";
        switch (this.type) {
            case 0: {
                t = "HSep";
                break;
            }
            case 1: {
                t = "VSep";
                break;
            }
            case 2: {
                t = "BoxH";
                break;
            }
            case 3: {
                t = "BoxV";
            }
        }
        return t + " (" + this.x1 + ", " + this.y1 + ", " + this.x2 + ", " + this.y2 + ") w=" + this.getWeight() + " a1=" + (Object)((Object)this.area1) + " a2=" + (Object)((Object)this.area2);
    }

    @Override
    public int compareTo(Separator other) {
        return other.getWeight() - this.getWeight();
    }

    public boolean isHorizontal() {
        return this.getWidth() >= this.getHeight();
    }

    public boolean isVertical() {
        return this.getWidth() < this.getHeight();
    }

    public int getWeight() {
        int ww = Math.min(this.getWidth(), this.getHeight()) / 10;
        ww = this.isVertical() ? ww * 2 : ww;
        return ww;
    }

    public Separator hsplit(Separator other) {
        Rectangular r = super.hsplit((Rectangular)other);
        if (r == null) {
            return null;
        }
        return new Separator(this.type, r);
    }

    public Separator vsplit(Separator other) {
        Rectangular r = super.vsplit((Rectangular)other);
        if (r == null) {
            return null;
        }
        return new Separator(this.type, r);
    }
}

