/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.op;

import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.fit.layout.model.Area;
import org.fit.segm.grouping.AreaImpl;
import org.fit.segm.grouping.op.Separator;

public abstract class SeparatorSet {
    protected static final double HSEP_MIN_HEIGHT = 0.1;
    protected static final double VSEP_MIN_WIDTH = 0.1;
    protected static final double SEP_MIN_RATIO = 1.0;
    protected static final int ART_SEP_WIDTH = 1;
    protected AreaImpl root;
    protected Vector<Separator> hsep;
    protected Vector<Separator> vsep;
    protected Vector<Separator> bsep;

    public SeparatorSet(AreaImpl root) {
        this.root = root;
        this.init(null);
    }

    public SeparatorSet(AreaImpl root, Area filter) {
        this.root = root;
        this.init(filter);
    }

    private void init(Area filter) {
        this.findAreaSeparators(this.root);
        this.findSeparators(this.root, filter);
    }

    public Vector<Separator> getHorizontal() {
        return this.hsep;
    }

    public Vector<Separator> getVertical() {
        return this.vsep;
    }

    public Vector<Separator> getBoxsep() {
        return this.bsep;
    }

    public Separator getMostImportantSeparator() {
        Separator sep = null;
        if (!this.hsep.isEmpty()) {
            sep = this.hsep.firstElement();
        }
        if (!(this.vsep.isEmpty() || sep != null && this.vsep.firstElement().getWeight() < sep.getWeight())) {
            sep = this.vsep.firstElement();
        }
        if (!(this.bsep.isEmpty() || sep != null && this.bsep.firstElement().getWeight() < sep.getWeight())) {
            sep = this.bsep.firstElement();
        }
        return sep;
    }

    public int getMinHSepHeight() {
        return (int)((double)this.root.getFontSize() * 0.1);
    }

    public int getMinVSepWidth() {
        return (int)((double)this.root.getFontSize() * 0.1);
    }

    public boolean isSeparatorAt(int x, int y) {
        return this.containsSeparatorAt(x, y, this.bsep) || this.containsSeparatorAt(x, y, this.hsep) || this.containsSeparatorAt(x, y, this.vsep);
    }

    private boolean containsSeparatorAt(int x, int y, Vector<Separator> col) {
        for (Separator sep : col) {
            if (!sep.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    protected abstract void findSeparators(AreaImpl var1, Area var2);

    protected void applyRegularFilters() {
        this.filterSeparators();
        this.processIntersections();
    }

    public void applyFinalFilters() {
        this.filterMarginalSeparators();
        this.filterSeparators();
        this.processIntersections();
        this.sortSeparators();
    }

    protected void filterMarginalSeparators() {
        Separator sep;
        Iterator<Separator> it = this.hsep.iterator();
        while (it.hasNext()) {
            sep = it.next();
            if (sep.getY1() != this.root.getY1() && sep.getY2() != this.root.getY2()) continue;
            it.remove();
        }
        it = this.vsep.iterator();
        while (it.hasNext()) {
            sep = it.next();
            if (sep.getX1() != this.root.getX1() && sep.getX2() != this.root.getX2()) continue;
            it.remove();
        }
    }

    protected void filterSeparators() {
        Separator sep;
        int hthreshold = this.getMinHSepHeight();
        int vthreshold = this.getMinVSepWidth();
        Iterator<Separator> it = this.hsep.iterator();
        while (it.hasNext()) {
            sep = it.next();
            AreaImpl above = this.root.findContentAbove(sep);
            hthreshold = above != null ? (int)((double)above.getFontSize() * 0.1) : (int)((double)this.root.getFontSize() * 0.1);
            if (sep.getWeight() < hthreshold) {
                it.remove();
                continue;
            }
            if (!((double)sep.getWidth() / (double)sep.getHeight() < 1.0)) continue;
            it.remove();
        }
        it = this.vsep.iterator();
        while (it.hasNext()) {
            sep = it.next();
            if (sep.getWeight() < vthreshold) {
                it.remove();
                continue;
            }
            if (!((double)sep.getHeight() / (double)sep.getWidth() < 1.0)) continue;
            it.remove();
        }
    }

    protected void processIntersections() {
    }

    protected void processIntersectionsSplitHorizontal() {
        boolean change;
        do {
            Vector<Separator> newsep = new Vector<Separator>(this.hsep.size());
            change = false;
            for (Separator hs : this.hsep) {
                boolean split = false;
                for (Separator vs : this.vsep) {
                    if (!hs.intersects(vs)) continue;
                    Separator nhs = hs.hsplit(vs);
                    newsep.add(hs);
                    if (nhs != null) {
                        newsep.add(nhs);
                    }
                    split = true;
                    change = true;
                    break;
                }
                if (split) continue;
                newsep.add(hs);
            }
            this.hsep = newsep;
        } while (change);
    }

    protected void processIntersectionsRemoveHorizontal() {
        Iterator<Separator> hit = this.hsep.iterator();
        block0: while (hit.hasNext()) {
            Separator hs = hit.next();
            for (Separator vs : this.vsep) {
                if (!hs.intersects(vs)) continue;
                hit.remove();
                continue block0;
            }
        }
    }

    private void sortSeparators() {
        Collections.sort(this.hsep);
        Collections.sort(this.vsep);
        Collections.sort(this.bsep);
    }

    private void findAreaSeparators(AreaImpl root) {
        this.bsep = new Vector();
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.analyzeAreaSeparators((AreaImpl)root.getChildArea(i));
        }
    }

    private void analyzeAreaSeparators(AreaImpl area) {
        boolean isep;
        boolean bl = isep = area.isExplicitlySeparated() || area.isBackgroundSeparated();
        if (isep || area.separatedUp()) {
            this.bsep.add(new Separator(2, area.getX1(), area.getY1(), area.getX2(), area.getY1() + 1 - 1));
        }
        if (isep || area.separatedDown()) {
            this.bsep.add(new Separator(2, area.getX1(), area.getY2() - 1 + 1, area.getX2(), area.getY2()));
        }
        if (isep || area.separatedLeft()) {
            this.bsep.add(new Separator(3, area.getX1(), area.getY1(), area.getX1() + 1 - 1, area.getY2()));
        }
        if (isep || area.separatedRight()) {
            this.bsep.add(new Separator(3, area.getX2() - 1 + 1, area.getY1(), area.getX2(), area.getY2()));
        }
    }
}

