/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.op;

import java.util.Iterator;
import java.util.Vector;
import org.fit.layout.model.Area;
import org.fit.segm.grouping.AreaImpl;
import org.fit.segm.grouping.op.Separator;
import org.fit.segm.grouping.op.SeparatorSet;

public class SeparatorSetHVS
extends SeparatorSet {
    public SeparatorSetHVS(AreaImpl root) {
        super(root);
    }

    public SeparatorSetHVS(AreaImpl root, Area filter) {
        super(root, filter);
    }

    @Override
    protected void findSeparators(AreaImpl area, Area filter) {
        this.hsep = new Vector();
        this.vsep = new Vector();
        AreaImpl base = filter == null ? area : filter;
        Separator hinit = new Separator(0, base.getX1(), base.getY1(), base.getX2(), base.getY2());
        this.hsep.add(hinit);
        Separator vinit = new Separator(1, base.getX1(), base.getY1(), base.getX2(), base.getY2());
        this.vsep.add(vinit);
        if (this.considerSubareas(this.root, filter) > 1) {
            Vector<Area> areas = this.createAreas(filter);
            if (areas.size() > 1) {
                for (Area a : areas) {
                    SeparatorSetHVS aset = new SeparatorSetHVS(area, a);
                    this.hsep.addAll(aset.getHorizontal());
                    this.vsep.addAll(aset.getVertical());
                }
            }
        } else {
            this.hsep.removeAllElements();
            this.vsep.removeAllElements();
        }
        this.applyRegularFilters();
    }

    private void considerArea(AreaImpl area) {
        Separator newsep;
        Separator sep;
        int ax1 = area.getX1();
        int ay1 = area.getY1();
        int ax2 = area.getX2();
        int ay2 = area.getY2();
        Vector<Separator> newseps = new Vector<Separator>();
        Iterator it = this.hsep.iterator();
        while (it.hasNext()) {
            sep = (Separator)it.next();
            int sy1 = sep.getY1();
            int sy2 = sep.getY2();
            if (ay1 <= sy1 && ay2 >= sy2) {
                it.remove();
                continue;
            }
            if (ay1 > sy1 && ay2 < sy2) {
                newsep = new Separator(0, sep.getX1(), ay2 + 1, sep.getX2(), sep.getY2());
                newseps.add(newsep);
                sep.setY2(ay1 - 1);
                newsep.setArea1(area);
                sep.setArea2(area);
                continue;
            }
            if (ay1 > sy1 && ay1 <= sy2 && ay2 >= sy2) {
                sep.setY2(ay1 - 1);
                sep.setArea2(area);
                continue;
            }
            if (ay1 > sy1 || ay2 < sy1 || ay2 >= sy2) continue;
            sep.setY1(ay2 + 1);
            sep.setArea1(area);
        }
        this.hsep.addAll(newseps);
        newseps = new Vector();
        it = this.vsep.iterator();
        while (it.hasNext()) {
            sep = (Separator)it.next();
            int sx1 = sep.getX1();
            int sx2 = sep.getX2();
            if (ax1 <= sx1 && ax2 >= sx2) {
                it.remove();
                continue;
            }
            if (ax1 > sx1 && ax2 < sx2) {
                newsep = new Separator(1, ax2 + 1, sep.getY1(), sep.getX2(), sep.getY2());
                newseps.add(newsep);
                sep.setX2(ax1 - 1);
                newsep.setArea1(area);
                sep.setArea2(area);
                continue;
            }
            if (ax1 > sx1 && ax1 <= sx2 && ax2 >= sx2) {
                sep.setX2(ax1 - 1);
                sep.setArea2(area);
                continue;
            }
            if (ax1 > sx1 || ax2 < sx1 || ax2 >= sx2) continue;
            sep.setX1(ax2 + 1);
            sep.setArea1(area);
        }
        this.vsep.addAll(newseps);
    }

    private int considerSubareas(AreaImpl area, Area filter) {
        int ret = 0;
        for (int i = 0; i < area.getChildCount(); ++i) {
            AreaImpl sub = (AreaImpl)area.getChildArea(i);
            if (filter != null && !filter.getBounds().encloses(sub.getBounds()) || sub.isHorizontalSeparator() || sub.isVerticalSeparator()) continue;
            this.considerArea(sub);
            ++ret;
        }
        this.applyRegularFilters();
        return ret;
    }

    private void considerSeparator(Vector<Area> areas, Separator sep, boolean horizontal) {
        Vector<AreaImpl> newareas = new Vector<AreaImpl>();
        if (horizontal) {
            int sy1 = sep.getY1();
            int sy2 = sep.getY2();
            Iterator<Area> it = areas.iterator();
            while (it.hasNext()) {
                Area area = it.next();
                int ay1 = area.getY1();
                int ay2 = area.getY2();
                if (sy1 <= ay1 && sy2 >= ay2) {
                    it.remove();
                    continue;
                }
                if (sy1 > ay1 && sy2 < ay2) {
                    AreaImpl newarea = new AreaImpl(area.getX1(), sy2 + 1, area.getX2(), area.getY2());
                    newarea.setPage(area.getPage());
                    newareas.add(newarea);
                    area.getBounds().setY2(sy1 - 1);
                    continue;
                }
                if (sy1 > ay1 && sy1 <= ay2 && sy2 >= ay2) {
                    area.getBounds().setY2(sy1 - 1);
                    continue;
                }
                if (sy1 > ay1 || sy2 < ay1 || sy2 >= ay2) continue;
                area.getBounds().setY1(sy2 + 1);
            }
        } else {
            int sx1 = sep.getX1();
            int sx2 = sep.getX2();
            Iterator<Area> it = areas.iterator();
            while (it.hasNext()) {
                Area area = it.next();
                int ax1 = area.getX1();
                int ax2 = area.getX2();
                if (sx1 <= ax1 && sx2 >= ax2) {
                    it.remove();
                    continue;
                }
                if (sx1 > ax1 && sx2 < ax2) {
                    AreaImpl newarea = new AreaImpl(sx2 + 1, area.getY1(), area.getX2(), area.getY2());
                    newareas.add(newarea);
                    area.getBounds().setX2(sx1 - 1);
                    continue;
                }
                if (sx1 > ax1 && sx1 <= ax2 && sx2 >= ax2) {
                    area.getBounds().setX2(sx1 - 1);
                    continue;
                }
                if (sx1 > ax1 || sx2 < ax1 || sx2 >= ax2) continue;
                area.getBounds().setX1(sx2 + 1);
            }
        }
        areas.addAll(newareas);
    }

    private void considerThinSeparator(Vector<Area> areas, Separator sep, boolean horizontal) {
        Vector<AreaImpl> newareas = new Vector<AreaImpl>();
        if (horizontal) {
            int sy1 = sep.getY1();
            int sy2 = sep.getY2();
            Iterator<Area> it = areas.iterator();
            while (it.hasNext()) {
                Area area = it.next();
                if (sep.getX1() > area.getX1() || sep.getX2() < area.getX2()) continue;
                int ay1 = area.getY1();
                int ay2 = area.getY2();
                if (sy1 <= ay1 && sy2 >= ay2) {
                    it.remove();
                    continue;
                }
                if (sy1 > ay1 && sy2 < ay2) {
                    AreaImpl newarea = new AreaImpl(area.getX1(), sy1, area.getX2(), area.getY2());
                    newarea.setPage(area.getPage());
                    newareas.add(newarea);
                    area.getBounds().setY2(sy1 - 1);
                    continue;
                }
                if (sy1 > ay1 && sy1 < ay2 && sy2 >= ay2) {
                    area.getBounds().setY2(sy1 - 1);
                    continue;
                }
                if (sy1 > ay1 || sy2 <= ay1 || sy2 >= ay2) continue;
                area.getBounds().setY1(sy1);
            }
        } else {
            int sx1 = sep.getX1();
            int sx2 = sep.getX2();
            Iterator<Area> it = areas.iterator();
            while (it.hasNext()) {
                Area area = it.next();
                if (sep.getY1() > area.getY1() || sep.getY2() < area.getY2()) continue;
                int ax1 = area.getX1();
                int ax2 = area.getX2();
                if (sx1 <= ax1 && sx2 >= ax2) {
                    it.remove();
                    continue;
                }
                if (sx1 > ax1 && sx2 < ax2) {
                    AreaImpl newarea = new AreaImpl(sx1, area.getY1(), area.getX2(), area.getY2());
                    newareas.add(newarea);
                    area.getBounds().setX2(sx1 - 1);
                    continue;
                }
                if (sx1 > ax1 && sx1 < ax2 && sx2 >= ax2) {
                    area.getBounds().setX2(sx1 - 1);
                    continue;
                }
                if (sx1 > ax1 || sx2 <= ax1 || sx2 >= ax2) continue;
                area.getBounds().setX1(sx1);
            }
        }
        areas.addAll(newareas);
    }

    private Vector<Area> createAreas(Area filter) {
        Area base = filter == null ? this.root : filter;
        Vector<Area> areas = new Vector<Area>();
        AreaImpl init = new AreaImpl(base.getX1(), base.getY1(), base.getX2(), base.getY2());
        init.setPage(base.getPage());
        areas.add(init);
        for (Separator sep : this.hsep) {
            this.considerSeparator(areas, sep, true);
        }
        for (Separator sep : this.vsep) {
            this.considerSeparator(areas, sep, false);
        }
        Iterator iterator = this.bsep.iterator();
        while (iterator.hasNext()) {
            Separator sep;
            this.considerThinSeparator(areas, sep, (sep = (Separator)iterator.next()).getType() == 2);
        }
        return areas;
    }
}

