/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.op;

import java.util.List;
import java.util.Vector;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.segm.grouping.AreaImpl;
import org.fit.segm.grouping.AreaUtils;
import org.fit.segm.grouping.op.SortByPositionOperator;

public class SortByLinesOperator
extends SortByPositionOperator {
    protected final String[] paramNames = new String[0];
    protected final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[0];

    public SortByLinesOperator() {
        super(false);
    }

    @Override
    public String getId() {
        return "FitLayout.Segm.SortByLines";
    }

    @Override
    public String getName() {
        return "Sort by lines";
    }

    @Override
    public String getDescription() {
        return "Sorts the visual areas roughly according to the text lines detected in the file";
    }

    @Override
    public String[] getParamNames() {
        return this.paramNames;
    }

    @Override
    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    @Override
    public void apply(AreaTree atree, Area root) {
        this.recursivelySortChildAreas(root, false);
        this.recursiveSortLines((AreaImpl)root);
    }

    protected void recursiveSortLines(AreaImpl root) {
        this.sortChildLines(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveSortLines((AreaImpl)root.getChildArea(i));
        }
    }

    protected void sortChildLines(AreaImpl root) {
        if (root.getGrid() == null) {
            root.createGrid();
        }
        if (root.getChildCount() > 1) {
            Vector<Area> src = new Vector<Area>(root.getChildAreas());
            Vector<Area> dest = new Vector<Area>(src.size());
            while (!src.isEmpty()) {
                AreaImpl seed = (AreaImpl)((Object)src.get(0));
                List<Area> line = this.findAreasOnLine(root, seed, src);
                dest.addAll(line);
                src.removeAll(line);
            }
            root.removeAllChildren();
            root.appendChildren(dest);
        }
    }

    private List<Area> findAreasOnLine(AreaImpl parent, AreaImpl area, List<Area> candidates) {
        int threshold;
        AreaImpl neigh;
        int y;
        Vector<Area> ret = new Vector<Area>();
        ret.add(area);
        int nx1 = area.getGridPosition().getX1();
        int ny1 = area.getGridPosition().getY1();
        int nx2 = area.getGridPosition().getX2();
        int ny2 = area.getGridPosition().getY2();
        int dist = 1;
        while (nx2 + dist < parent.getGrid().getWidth()) {
            for (y = ny1; y <= ny2; ++y) {
                neigh = (AreaImpl)parent.getGrid().getAreaAt(nx2 + dist, y);
                if (neigh == null || !candidates.contains((Object)neigh)) continue;
                threshold = Math.min(area.getHeight(), neigh.getHeight()) / 2;
                if (threshold < 0) {
                    threshold = 0;
                }
                if (!AreaUtils.isOnSameLine(area, neigh, threshold)) continue;
                ret.add(neigh);
                break;
            }
            ++dist;
        }
        dist = 1;
        while (nx1 - dist >= 0) {
            for (y = ny1; y <= ny2; ++y) {
                neigh = (AreaImpl)parent.getGrid().getAreaAt(nx1 - dist, y);
                if (neigh == null || !candidates.contains((Object)neigh)) continue;
                threshold = Math.min(area.getHeight(), neigh.getHeight()) / 2;
                if (threshold < 0) {
                    threshold = 0;
                }
                if (!AreaUtils.isOnSameLine(area, neigh, threshold)) continue;
                ret.insertElementAt(neigh, 0);
                break;
            }
            ++dist;
        }
        return ret;
    }
}

