/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.op;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;

public class SortByPositionOperator
extends BaseOperator {
    protected boolean columnFirst;
    protected final String[] paramNames = new String[]{"columnFirst"};
    protected final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.BOOLEAN};

    public SortByPositionOperator() {
        this.columnFirst = false;
    }

    public SortByPositionOperator(boolean columnFirst) {
        this.columnFirst = columnFirst;
    }

    public String getId() {
        return "FitLayout.Segm.SortByPosition";
    }

    public String getName() {
        return "Sort by position";
    }

    public String getDescription() {
        return "Sorts the visual areas by their position (x,y coordinates)";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public boolean getColumnFirst() {
        return this.columnFirst;
    }

    public void setColumnFirst(boolean columnFirst) {
        this.columnFirst = columnFirst;
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.recursivelySortChildAreas(root, this.columnFirst);
    }

    protected void recursivelySortChildAreas(Area root, final boolean columnFirst) {
        if (root.getChildCount() > 1) {
            Vector list = new Vector(root.getChildAreas());
            Collections.sort(list, new Comparator<Area>(){

                @Override
                public int compare(Area a1, Area a2) {
                    if (!columnFirst) {
                        return a1.getY1() == a2.getY1() ? a1.getX1() - a2.getX1() : a1.getY1() - a2.getY1();
                    }
                    return a1.getX1() == a2.getX1() ? a1.getY1() - a2.getY1() : a1.getX1() - a2.getX1();
                }
            });
            root.removeAllChildren();
            root.appendChildren(list);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursivelySortChildAreas((Area)root.getChildArea(i), columnFirst);
        }
    }
}

