/*
 * Decompiled with CFR 0.152.
 */
package org.fit.segm.grouping.op;

import java.util.Vector;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.impl.BaseOperator;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.segm.grouping.AreaImpl;
import org.fit.segm.grouping.Config;
import org.fit.segm.grouping.op.GroupAnalyzer;

public class SuperAreaOperator
extends BaseOperator {
    protected int depthLimit;
    protected final String[] paramNames = new String[]{"depthLimit"};
    protected final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.INTEGER};

    public SuperAreaOperator() {
        this.depthLimit = 2;
    }

    public SuperAreaOperator(int depthLimit) {
        this.depthLimit = depthLimit;
    }

    public String getId() {
        return "FitLayout.Segm.SuperAreas";
    }

    public String getName() {
        return "Super areas";
    }

    public String getDescription() {
        return "...";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    public void setDepthLimit(int depthLimit) {
        this.depthLimit = depthLimit;
    }

    public void apply(AreaTree atree) {
        this.recursiveFindSuperAreas((AreaImpl)atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.recursiveFindSuperAreas((AreaImpl)root);
    }

    protected GroupAnalyzer createGroupAnalyzer(AreaImpl root) {
        return Config.createGroupAnalyzer(root);
    }

    private void recursiveFindSuperAreas(AreaImpl root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveFindSuperAreas((AreaImpl)root.getChildArea(i));
        }
        this.findSuperAreas(root, this.depthLimit);
    }

    public void findSuperAreas(AreaImpl root, int passlimit) {
        if (root.getChildCount() > 0) {
            boolean changed = true;
            root.createSeparators();
            for (int pass = 0; changed && pass < passlimit; ++pass) {
                changed = false;
                GroupAnalyzer groups = this.createGroupAnalyzer(root);
                Vector chld = new Vector();
                chld.addAll(root.getChildAreas());
                while (chld.size() > 1) {
                    Vector<AreaImpl> selected = new Vector<AreaImpl>();
                    int index = root.getIndex((Area)chld.firstElement());
                    AreaImpl grp = null;
                    if (((Area)chld.firstElement()).isLeaf()) {
                        grp = groups.findSuperArea((AreaImpl)((Object)chld.firstElement()), selected);
                    }
                    if (selected.size() == root.getChildCount()) break;
                    if (selected.size() > 1) {
                        root.insertChild(grp, index);
                        for (AreaImpl a : selected) {
                            grp.appendChild(a);
                        }
                        chld.removeAll(selected);
                        grp.createGrid();
                        this.findSuperAreas(grp, passlimit - 1);
                        changed = true;
                        continue;
                    }
                    chld.removeElementAt(0);
                }
                root.createGrid();
                root.removeSimpleSeparators();
            }
        }
    }
}

