/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fit.layout.impl.DefaultArea;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Box;
import org.fit.layout.model.LogicalArea;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Rectangular;
import org.fit.layout.model.Tag;
import org.fit.layout.storage.model.RDFArea;
import org.fit.layout.storage.ontology.BOX;
import org.fit.layout.storage.ontology.RESOURCE;
import org.fit.layout.storage.ontology.SEGM;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class AreaModelBuilder {
    private Graph graph = new LinkedHashModel();
    private ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
    private URI pageNode;
    private URI areaTreeNode;
    private int logAreaCnt;
    private Set<Tag> usedTags;
    private int next_order;

    public AreaModelBuilder(AreaTree areaTree, LogicalAreaTree logicalTree, URI pageNode, URI uri) {
        this.pageNode = pageNode;
        this.areaTreeNode = uri;
        this.usedTags = new HashSet<Tag>();
        this.createAreaTreeModel(pageNode, areaTree, logicalTree);
        this.addUsedTags();
    }

    public Graph getGraph() {
        return this.graph;
    }

    private void createAreaTreeModel(URI pageNode, AreaTree areaTree, LogicalAreaTree logicalTree) {
        this.graph.add((Resource)this.areaTreeNode, RDF.TYPE, (Value)SEGM.AreaTree, new Resource[0]);
        this.graph.add((Resource)this.areaTreeNode, SEGM.sourcePage, (Value)pageNode, new Resource[0]);
        this.next_order = 0;
        this.addArea(areaTree.getRoot());
        this.insertAllAreas(areaTree.getRoot().getChildAreas());
        if (logicalTree != null) {
            URI lroot = this.addLogicalArea(logicalTree.getRoot(), null);
            this.insertAllLogicalAreas(logicalTree.getRoot().getChildAreas(), lroot);
        }
    }

    private void insertAllAreas(List<Area> areas) {
        for (Area area : areas) {
            this.addArea(area);
            this.insertAllAreas(area.getChildAreas());
        }
    }

    private void insertAllLogicalAreas(List<LogicalArea> areas, URI parent) {
        for (LogicalArea area : areas) {
            URI p = this.addLogicalArea(area, parent);
            this.insertAllLogicalAreas(area.getChildAreas(), p);
        }
    }

    private void addArea(Area area) {
        URI individual = RESOURCE.createAreaURI(this.areaTreeNode, area);
        this.graph.add((Resource)individual, RDF.TYPE, (Value)SEGM.Area, new Resource[0]);
        if (area instanceof DefaultArea && ((DefaultArea)area).getName() != null) {
            this.graph.add((Resource)individual, RDFS.LABEL, (Value)this.vf.createLiteral(((DefaultArea)area).getName()), new Resource[0]);
        }
        this.graph.add((Resource)individual, BOX.documentOrder, (Value)this.vf.createLiteral(this.next_order++), new Resource[0]);
        this.graph.add((Resource)individual, SEGM.belongsTo, (Value)this.areaTreeNode, new Resource[0]);
        if (area.getParentArea() != null) {
            this.graph.add((Resource)individual, SEGM.isChildOf, (Value)RESOURCE.createAreaURI(this.areaTreeNode, (Area)area.getParentArea()), new Resource[0]);
        }
        Rectangular rec = area.getBounds();
        this.graph.add((Resource)individual, BOX.height, (Value)this.vf.createLiteral(rec.getHeight()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.width, (Value)this.vf.createLiteral(rec.getWidth()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.positionX, (Value)this.vf.createLiteral(rec.getX1()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.positionY, (Value)this.vf.createLiteral(rec.getY1()), new Resource[0]);
        if (area.getTags().size() > 0) {
            Map tags = area.getTags();
            for (Tag t : tags.keySet()) {
                Float support = (Float)tags.get(t);
                if (support == null || !(support.floatValue() > 0.0f)) continue;
                this.usedTags.add(t);
                URI tagUri = RESOURCE.createTagURI(t);
                this.graph.add((Resource)individual, SEGM.hasTag, (Value)tagUri, new Resource[0]);
                URI supUri = RESOURCE.createTagSupportURI(individual, t);
                this.graph.add((Resource)individual, SEGM.tagSupport, (Value)supUri, new Resource[0]);
                this.graph.add((Resource)supUri, SEGM.support, (Value)this.vf.createLiteral(support.floatValue()), new Resource[0]);
                this.graph.add((Resource)supUri, SEGM.hasTag, (Value)tagUri, new Resource[0]);
            }
        }
        if (area.getBackgroundColor() != null) {
            this.graph.add((Resource)individual, BOX.backgroundColor, (Value)this.vf.createLiteral(this.colorString(area.getBackgroundColor())), new Resource[0]);
        }
        this.graph.add((Resource)individual, BOX.fontSize, (Value)this.vf.createLiteral(area.getFontSize()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.fontWeight, (Value)this.vf.createLiteral(area.getFontWeight()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.fontStyle, (Value)this.vf.createLiteral(area.getFontStyle()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.underline, (Value)this.vf.createLiteral(area.getUnderline()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.lineThrough, (Value)this.vf.createLiteral(area.getLineThrough()), new Resource[0]);
        for (Box box : area.getBoxes()) {
            URI boxUri = RESOURCE.createBoxURI(this.pageNode, box);
            this.graph.add((Resource)individual, SEGM.containsBox, (Value)boxUri, new Resource[0]);
        }
    }

    private URI addLogicalArea(LogicalArea area, URI parent) {
        URI individual = RESOURCE.createLogicalAreaURI(this.areaTreeNode, this.logAreaCnt++);
        this.graph.add((Resource)individual, RDF.TYPE, (Value)SEGM.LogicalArea, new Resource[0]);
        this.graph.add((Resource)individual, BOX.documentOrder, (Value)this.vf.createLiteral(this.next_order++), new Resource[0]);
        this.graph.add((Resource)individual, SEGM.belongsTo, (Value)this.areaTreeNode, new Resource[0]);
        this.graph.add((Resource)individual, SEGM.hasText, (Value)this.vf.createLiteral(area.getText()), new Resource[0]);
        if (parent != null) {
            this.graph.add((Resource)individual, SEGM.isSubordinateTo, (Value)parent, new Resource[0]);
        }
        if (area.getMainTag() != null) {
            this.graph.add((Resource)individual, SEGM.hasTag, (Value)RESOURCE.createTagURI(area.getMainTag()), new Resource[0]);
        }
        for (Area a : area.getAreas()) {
            URI areaUri = a instanceof RDFArea ? ((RDFArea)a).getUri() : RESOURCE.createAreaURI(this.areaTreeNode, a);
            this.graph.add((Resource)individual, SEGM.containsArea, (Value)areaUri, new Resource[0]);
        }
        return individual;
    }

    private void addUsedTags() {
        for (Tag t : this.usedTags) {
            URI tagUri = RESOURCE.createTagURI(t);
            this.graph.add((Resource)tagUri, SEGM.hasType, (Value)this.vf.createLiteral(t.getType()), new Resource[0]);
            this.graph.add((Resource)tagUri, SEGM.hasName, (Value)this.vf.createLiteral(t.getValue()), new Resource[0]);
        }
    }

    private String colorString(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

