/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.fit.layout.impl.DefaultLogicalAreaTree;
import org.fit.layout.impl.DefaultTag;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Border;
import org.fit.layout.model.Box;
import org.fit.layout.model.LogicalArea;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;
import org.fit.layout.model.Tag;
import org.fit.layout.storage.ModelLoader;
import org.fit.layout.storage.RDFStorage;
import org.fit.layout.storage.model.RDFArea;
import org.fit.layout.storage.model.RDFAreaTree;
import org.fit.layout.storage.model.RDFBox;
import org.fit.layout.storage.model.RDFLogicalArea;
import org.fit.layout.storage.model.RDFPage;
import org.fit.layout.storage.ontology.BOX;
import org.fit.layout.storage.ontology.SEGM;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaModelLoader
extends ModelLoader {
    private static Logger log = LoggerFactory.getLogger(AreaModelLoader.class);
    private RDFStorage storage;
    private URI areaTreeUri;
    private RDFPage page;
    private Model borderModel;
    private Model tagInfoModel;
    private Model tagSupportModel;
    private RDFAreaTree areaTree;
    private LogicalAreaTree logicalAreaTree;

    public AreaModelLoader(RDFStorage storage, URI areaTreeUri, RDFPage srcPage) {
        this.storage = storage;
        this.areaTreeUri = areaTreeUri;
        this.page = srcPage;
    }

    public RDFAreaTree getAreaTree() throws RepositoryException {
        if (this.areaTree == null) {
            this.areaTree = this.constructAreaTree();
        }
        return this.areaTree;
    }

    public LogicalAreaTree getLogicalAreaTree() throws RepositoryException {
        if (this.areaTree != null) {
            if (this.logicalAreaTree == null) {
                this.logicalAreaTree = this.constructLogicalAreaTree();
            }
            return this.logicalAreaTree;
        }
        return null;
    }

    private RDFAreaTree constructAreaTree() throws RepositoryException {
        Model model = this.storage.getAreaModelForAreaTree(this.areaTreeUri);
        if (model.size() > 0) {
            RDFAreaTree atree = new RDFAreaTree((Page)this.page, this.areaTreeUri);
            LinkedHashMap<URI, RDFArea> areaUris = new LinkedHashMap<URI, RDFArea>();
            RDFArea root = this.constructVisualAreaTree(model, areaUris);
            this.recursiveUpdateTopologies((Area)root);
            atree.setRoot((Area)root);
            atree.setAreaUris(areaUris);
            return atree;
        }
        return null;
    }

    private RDFArea constructVisualAreaTree(Model model, Map<URI, RDFArea> areas) throws RepositoryException {
        for (Resource res : model.subjects()) {
            if (!(res instanceof URI)) continue;
            RDFArea area = this.createAreaFromModel(model, (URI)res);
            areas.put((URI)res, area);
        }
        ArrayList<RDFArea> rootAreas = new ArrayList<RDFArea>(areas.values());
        for (Statement st : model.filter(null, SEGM.isChildOf, null, new Resource[0])) {
            if (!(st.getSubject() instanceof URI) || !(st.getObject() instanceof URI)) continue;
            RDFArea parent = areas.get(st.getObject());
            RDFArea child = areas.get(st.getSubject());
            if (parent == null || child == null) continue;
            parent.add((GenericTreeNode)child);
            rootAreas.remove(child);
        }
        if (rootAreas.size() == 1) {
            return (RDFArea)rootAreas.get(0);
        }
        log.error("Strange number of root areas: {}", (Object)((Object)rootAreas).toString());
        return null;
    }

    private RDFArea createAreaFromModel(Model model, URI uri) throws RepositoryException {
        RDFArea area = new RDFArea(new Rectangular(), uri);
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        HashMap tagSupport = new HashMap();
        for (Statement st : model.filter((Resource)uri, null, null, new Resource[0])) {
            Tag tag;
            Border border;
            URI pred = st.getPredicate();
            Value value = st.getObject();
            if (RDFS.LABEL.equals((Object)pred)) {
                String name = value.stringValue();
                area.setName(name);
                continue;
            }
            if (BOX.documentOrder.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                area.setDocumentOrder(((Literal)value).intValue());
                continue;
            }
            if (BOX.backgroundColor.equals((Object)pred)) {
                String bgColor = value.stringValue();
                area.setBackgroundColor(this.hex2Rgb(bgColor));
                continue;
            }
            if (BOX.underline.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                area.setUnderline(((Literal)value).floatValue());
                continue;
            }
            if (BOX.lineThrough.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                area.setLineThrough(((Literal)value).floatValue());
                continue;
            }
            if (BOX.fontSize.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                area.setFontSize(((Literal)value).floatValue());
                continue;
            }
            if (BOX.fontStyle.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                area.setFontStyle(((Literal)value).floatValue());
                continue;
            }
            if (BOX.fontWeight.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                area.setFontWeight(((Literal)value).floatValue());
                continue;
            }
            if (BOX.hasBottomBorder.equals((Object)pred)) {
                if (!(value instanceof URI)) continue;
                border = this.createBorder(this.getBorderModel(), (URI)value);
                area.setBorderStyle(Border.Side.BOTTOM, border);
                continue;
            }
            if (BOX.hasLeftBorder.equals((Object)pred)) {
                if (!(value instanceof URI)) continue;
                border = this.createBorder(this.getBorderModel(), (URI)value);
                area.setBorderStyle(Border.Side.LEFT, border);
                continue;
            }
            if (BOX.hasRightBorder.equals((Object)pred)) {
                if (!(value instanceof URI)) continue;
                border = this.createBorder(this.getBorderModel(), (URI)value);
                area.setBorderStyle(Border.Side.RIGHT, border);
                continue;
            }
            if (BOX.hasTopBorder.equals((Object)pred)) {
                if (!(value instanceof URI)) continue;
                border = this.createBorder(this.getBorderModel(), (URI)value);
                area.setBorderStyle(Border.Side.TOP, border);
                continue;
            }
            if (BOX.height.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                height = ((Literal)value).intValue();
                continue;
            }
            if (BOX.width.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                width = ((Literal)value).intValue();
                continue;
            }
            if (BOX.positionX.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                x = ((Literal)value).intValue();
                continue;
            }
            if (BOX.positionY.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                y = ((Literal)value).intValue();
                continue;
            }
            if (SEGM.containsBox.equals((Object)pred)) {
                RDFBox box;
                if (!(value instanceof URI) || (box = this.page.findBoxByUri((URI)value)) == null) continue;
                area.addBox((Box)box);
                continue;
            }
            if (SEGM.hasTag.equals((Object)pred)) {
                Tag tag2;
                if (!(value instanceof URI) || tagSupport.containsKey(value) || (tag2 = this.createTag((URI)value)) == null) continue;
                area.addTag(tag2, 1.0f);
                continue;
            }
            if (!SEGM.tagSupport.equals((Object)pred) || !(value instanceof URI)) continue;
            URI tsUri = (URI)value;
            URI tagUri = null;
            Float support = null;
            for (Statement sst : this.getTagSupportModel().filter((Resource)tsUri, null, null, new Resource[0])) {
                if (SEGM.hasTag.equals((Object)sst.getPredicate()) && sst.getObject() instanceof URI) {
                    tagUri = (URI)sst.getObject();
                    continue;
                }
                if (!SEGM.support.equals((Object)sst.getPredicate()) || !(sst.getObject() instanceof Literal)) continue;
                support = Float.valueOf(((Literal)sst.getObject()).floatValue());
            }
            if (tagUri == null || support == null || (tag = this.createTag((URI)value)) == null) continue;
            area.addTag(tag, support.floatValue());
        }
        area.setBounds(new Rectangular(x, y, x + width - 1, y + height - 1));
        area.sortBoxes();
        return area;
    }

    private void recursiveUpdateTopologies(Area root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveUpdateTopologies((Area)root.getChildArea(i));
        }
        root.updateTopologies();
    }

    private LogicalAreaTree constructLogicalAreaTree() throws RepositoryException {
        Model model = this.storage.getLogicalAreaModelForAreaTree(this.areaTreeUri);
        if (model.size() > 0) {
            DefaultLogicalAreaTree atree = new DefaultLogicalAreaTree((AreaTree)this.areaTree);
            LinkedHashMap<URI, RDFLogicalArea> areaUris = new LinkedHashMap<URI, RDFLogicalArea>();
            RDFLogicalArea root = this.constructLogicalAreaTree(model, areaUris);
            atree.setRoot((LogicalArea)root);
            return atree;
        }
        return null;
    }

    private RDFLogicalArea constructLogicalAreaTree(Model model, Map<URI, RDFLogicalArea> areas) throws RepositoryException {
        for (Resource res : model.subjects()) {
            if (!(res instanceof URI)) continue;
            RDFLogicalArea area = this.createLogicalAreaFromModel(model, (URI)res);
            areas.put((URI)res, area);
        }
        ArrayList<RDFLogicalArea> rootAreas = new ArrayList<RDFLogicalArea>(areas.values());
        for (Statement st : model.filter(null, SEGM.isSubordinateTo, null, new Resource[0])) {
            if (!(st.getSubject() instanceof URI) || !(st.getObject() instanceof URI)) continue;
            RDFLogicalArea parent = areas.get(st.getObject());
            RDFLogicalArea child = areas.get(st.getSubject());
            if (parent == null || child == null) continue;
            parent.add((GenericTreeNode)child);
            rootAreas.remove(child);
        }
        if (rootAreas.size() == 1) {
            return (RDFLogicalArea)rootAreas.get(0);
        }
        log.error("Strange number of root logical areas: {}", (Object)((Object)rootAreas).toString());
        return null;
    }

    private RDFLogicalArea createLogicalAreaFromModel(Model model, URI uri) throws RepositoryException {
        RDFLogicalArea area = new RDFLogicalArea(uri);
        for (Statement st : model.filter((Resource)uri, null, null, new Resource[0])) {
            RDFArea a;
            URI pred = st.getPredicate();
            Value value = st.getObject();
            if (SEGM.hasText.equals((Object)pred)) {
                area.setText(value.stringValue());
                continue;
            }
            if (SEGM.hasTag.equals((Object)pred)) {
                Tag tag;
                if (!(value instanceof URI) || (tag = this.createTag((URI)value)) == null) continue;
                area.setMainTag(tag);
                continue;
            }
            if (!SEGM.containsArea.equals((Object)pred) || !(value instanceof URI) || (a = this.areaTree.findAreaByUri((URI)value)) == null) continue;
            area.addArea((Area)a);
        }
        return area;
    }

    private Tag createTag(URI tagUri) throws RepositoryException {
        String name = null;
        String type = null;
        for (Statement st : this.getTagInfoModel().filter((Resource)tagUri, null, null, new Resource[0])) {
            URI pred = st.getPredicate();
            if (SEGM.hasName.equals((Object)pred)) {
                name = st.getObject().stringValue();
                continue;
            }
            if (!SEGM.hasType.equals((Object)pred)) continue;
            type = st.getObject().stringValue();
        }
        if (name != null && type != null) {
            return new DefaultTag(type, name);
        }
        return null;
    }

    private Model getBorderModel() throws RepositoryException {
        if (this.borderModel == null) {
            this.borderModel = this.storage.getBorderModelForAreaTree(this.areaTreeUri);
        }
        return this.borderModel;
    }

    private Model getTagInfoModel() throws RepositoryException {
        if (this.tagInfoModel == null) {
            this.tagInfoModel = this.storage.getTagModelForAreaTree(this.areaTreeUri);
        }
        return this.tagInfoModel;
    }

    private Model getTagSupportModel() throws RepositoryException {
        if (this.tagSupportModel == null) {
            this.tagSupportModel = this.storage.getTagSupportModelForAreaTree(this.areaTreeUri);
        }
        return this.tagSupportModel;
    }
}

