/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.awt.Color;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.fit.layout.model.Border;
import org.fit.layout.model.Box;
import org.fit.layout.model.ContentImage;
import org.fit.layout.model.ContentObject;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;
import org.fit.layout.storage.ontology.BOX;
import org.fit.layout.storage.ontology.RESOURCE;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.rdfterm.UUID;

public class BoxModelBuilder {
    private Graph graph;
    private Page page;
    private String baseUrl;
    private ValueFactoryImpl vf;
    private URI pageNode;
    private int next_order;

    public BoxModelBuilder(Page page, URI uri) {
        this.page = page;
        this.baseUrl = page.getSourceURL().toString();
        this.pageNode = uri;
        this.initializeGraph();
        Box root = page.getRoot();
        this.insertBox(root);
        this.insertChildBoxes(root);
    }

    private URI initializeGraph() {
        this.graph = new LinkedHashModel();
        this.vf = ValueFactoryImpl.getInstance();
        this.next_order = 0;
        this.graph.add((Resource)this.pageNode, RDF.TYPE, (Value)BOX.Page, new Resource[0]);
        this.graph.add((Resource)this.pageNode, BOX.launchDatetime, (Value)this.vf.createLiteral(new Date()), new Resource[0]);
        this.graph.add((Resource)this.pageNode, BOX.sourceUrl, (Value)this.vf.createLiteral(this.baseUrl), new Resource[0]);
        if (this.page.getTitle() != null) {
            this.graph.add((Resource)this.pageNode, BOX.hasTitle, (Value)this.vf.createLiteral(this.page.getTitle()), new Resource[0]);
        }
        return this.pageNode;
    }

    private void insertChildBoxes(Box root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            Box child = root.getChildBox(i);
            this.insertBox(child);
            this.insertChildBoxes(child);
        }
    }

    private void insertBox(Box box) {
        URI individual = RESOURCE.createBoxURI(this.pageNode, box);
        this.graph.add((Resource)individual, RDF.TYPE, (Value)BOX.Box, new Resource[0]);
        this.graph.add((Resource)individual, BOX.documentOrder, (Value)this.vf.createLiteral(this.next_order++), new Resource[0]);
        this.graph.add((Resource)individual, BOX.belongsTo, (Value)this.pageNode, new Resource[0]);
        if (box.getParentBox() != null) {
            this.graph.add((Resource)individual, BOX.isChildOf, (Value)RESOURCE.createBoxURI(this.pageNode, box.getParentBox()), new Resource[0]);
        }
        if (box.getTagName() != null) {
            this.graph.add((Resource)individual, BOX.htmlTagName, (Value)this.vf.createLiteral(box.getTagName()), new Resource[0]);
        }
        Map attrs = box.getAttributes();
        for (Map.Entry attr : attrs.entrySet()) {
            URI attrUri = this.insertAttribute(individual, (String)attr.getKey(), (String)attr.getValue());
            this.graph.add((Resource)individual, BOX.hasAttribute, (Value)attrUri, new Resource[0]);
        }
        Rectangular content = box.getContentBounds();
        this.graph.add((Resource)individual, BOX.height, (Value)this.vf.createLiteral(content.getHeight()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.width, (Value)this.vf.createLiteral(content.getWidth()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.positionX, (Value)this.vf.createLiteral(content.getX1()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.positionY, (Value)this.vf.createLiteral(content.getY1()), new Resource[0]);
        Rectangular visual = box.getVisualBounds();
        this.graph.add((Resource)individual, BOX.visualHeight, (Value)this.vf.createLiteral(visual.getHeight()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.visualWidth, (Value)this.vf.createLiteral(visual.getWidth()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.visualX, (Value)this.vf.createLiteral(visual.getX1()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.visualY, (Value)this.vf.createLiteral(visual.getY1()), new Resource[0]);
        if (box.getBackgroundColor() != null) {
            this.graph.add((Resource)individual, BOX.backgroundColor, (Value)this.vf.createLiteral(this.colorString(box.getBackgroundColor())), new Resource[0]);
        }
        if (box.getType() == Box.Type.TEXT_CONTENT) {
            this.graph.add((Resource)individual, BOX.hasText, (Value)this.vf.createLiteral(box.getText()), new Resource[0]);
        } else if (box.getType() == Box.Type.REPLACED_CONTENT) {
            ContentObject obj = box.getContentObject();
            try {
                URI objuri = new UUID().evaluate((ValueFactory)this.vf, new Value[0]);
                if (obj instanceof ContentImage) {
                    this.graph.add((Resource)objuri, RDF.TYPE, (Value)BOX.Image, new Resource[0]);
                    URL url = ((ContentImage)obj).getUrl();
                    if (url != null) {
                        this.graph.add((Resource)objuri, BOX.imageUrl, (Value)this.vf.createLiteral(url.toString()), new Resource[0]);
                    }
                    this.graph.add((Resource)individual, BOX.containsImage, (Value)objuri, new Resource[0]);
                } else {
                    this.graph.add((Resource)objuri, RDF.TYPE, (Value)BOX.ContentObject, new Resource[0]);
                    this.graph.add((Resource)individual, BOX.containsObject, (Value)objuri, new Resource[0]);
                }
            }
            catch (ValueExprEvaluationException e) {
                e.printStackTrace();
            }
        }
        this.graph.add((Resource)individual, BOX.fontFamily, (Value)this.vf.createLiteral(box.getFontFamily()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.fontSize, (Value)this.vf.createLiteral(box.getFontSize()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.fontWeight, (Value)this.vf.createLiteral(box.getFontWeight()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.fontStyle, (Value)this.vf.createLiteral(box.getFontStyle()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.underline, (Value)this.vf.createLiteral(box.getUnderline()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.lineThrough, (Value)this.vf.createLiteral(box.getLineThrough()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.color, (Value)this.vf.createLiteral(this.colorString(box.getColor())), new Resource[0]);
        if (box.getBorderStyle(Border.Side.TOP) != null && box.hasTopBorder()) {
            URI btop = this.insertBorder(box.getBorderStyle(Border.Side.TOP), individual, "top");
            this.graph.add((Resource)individual, BOX.hasTopBorder, (Value)btop, new Resource[0]);
        }
        if (box.getBorderStyle(Border.Side.RIGHT) != null && box.hasRightBorder()) {
            URI bright = this.insertBorder(box.getBorderStyle(Border.Side.RIGHT), individual, "right");
            this.graph.add((Resource)individual, BOX.hasRightBorder, (Value)bright, new Resource[0]);
        }
        if (box.getBorderStyle(Border.Side.BOTTOM) != null && box.hasBottomBorder()) {
            URI bbottom = this.insertBorder(box.getBorderStyle(Border.Side.BOTTOM), individual, "bottom");
            this.graph.add((Resource)individual, BOX.hasBottomBorder, (Value)bbottom, new Resource[0]);
        }
        if (box.getBorderStyle(Border.Side.LEFT) != null && box.hasLeftBorder()) {
            URI bleft = this.insertBorder(box.getBorderStyle(Border.Side.LEFT), individual, "left");
            this.graph.add((Resource)individual, BOX.hasLeftBorder, (Value)bleft, new Resource[0]);
        }
    }

    private URI insertBorder(Border border, URI boxUri, String side) {
        URI uri = RESOURCE.createBorderURI(boxUri, side);
        this.graph.add((Resource)uri, RDF.TYPE, (Value)BOX.Border, new Resource[0]);
        this.graph.add((Resource)uri, BOX.borderWidth, (Value)this.vf.createLiteral(border.getWidth()), new Resource[0]);
        this.graph.add((Resource)uri, BOX.borderStyle, (Value)this.vf.createLiteral(border.getStyle().toString()), new Resource[0]);
        this.graph.add((Resource)uri, BOX.borderColor, (Value)this.vf.createLiteral(this.colorString(border.getColor())), new Resource[0]);
        return uri;
    }

    private URI insertAttribute(URI boxUri, String name, String value) {
        URI uri = RESOURCE.createAttributeURI(boxUri, name);
        this.graph.add((Resource)uri, RDFS.LABEL, (Value)this.vf.createLiteral(name), new Resource[0]);
        this.graph.add((Resource)uri, RDF.VALUE, (Value)this.vf.createLiteral(value), new Resource[0]);
        return uri;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public URI getLaunchNode() {
        return this.pageNode;
    }

    private String colorString(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

