/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.util.Date;
import org.fit.layout.storage.ontology.BOX;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class PageInfo {
    private Date date;
    private URI id;
    private String url;
    private String title;

    public PageInfo(Model model) {
        for (Statement st : model) {
            if (!(st.getSubject() instanceof URI)) continue;
            this.id = (URI)st.getSubject();
            if (st.getPredicate().equals((Object)BOX.sourceUrl)) {
                this.url = st.getObject().stringValue();
                continue;
            }
            if (st.getPredicate().equals((Object)BOX.launchDatetime)) {
                Value val = st.getObject();
                if (!(val instanceof Literal)) continue;
                this.date = ((Literal)val).calendarValue().toGregorianCalendar().getTime();
                continue;
            }
            if (!st.getPredicate().equals((Object)BOX.hasTitle)) continue;
            this.title = st.getObject().stringValue();
        }
    }

    public URI getId() {
        return this.id;
    }

    public Date getDate() {
        return this.date;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }
}

