/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.net.MalformedURLException;
import java.net.URL;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.impl.BaseBoxTreeProvider;
import org.fit.layout.model.Page;
import org.fit.layout.storage.RDFStorage;
import org.fit.layout.storage.ontology.RESOURCE;
import org.openrdf.model.URI;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.RepositoryException;

public class RDFBoxTreeProvider
extends BaseBoxTreeProvider {
    private URL urlDb;
    private URI pageId;
    private final String[] paramNames = new String[]{"urlDb", "pageId"};
    private final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.STRING, ParametrizedOperation.ValueType.STRING};

    public RDFBoxTreeProvider() throws MalformedURLException {
        this.urlDb = new URL("http://localhost:8080/openrdf-sesame/repositories/user");
        this.pageId = RESOURCE.createPageURI(1L);
    }

    public RDFBoxTreeProvider(URL urlDb, URI pageId) {
        this.urlDb = urlDb;
        this.pageId = pageId;
    }

    public String getId() {
        return "FitLayout.RDFSource";
    }

    public String getName() {
        return "RDF page source";
    }

    public String getDescription() {
        return "Uses the a RDF repository for obtaining the box tree.";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public URL getUrlDb() {
        return this.urlDb;
    }

    public void setUrlDb(URL urlDb) {
        this.urlDb = urlDb;
    }

    public void setUrlDb(String urlDb) {
        try {
            this.urlDb = new URL(urlDb);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + urlDb);
        }
    }

    public URI getPageId() {
        return this.pageId;
    }

    public void setPageId(URI pageId) {
        this.pageId = pageId;
    }

    public void setPageId(String pageId) {
        ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
        this.pageId = vf.createURI(pageId);
    }

    public Page getPage() {
        try {
            RDFStorage storage = new RDFStorage(this.urlDb.toString());
            return storage.loadPage(this.pageId);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }
}

