/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sparql.SPARQLRepository;

public class RDFConnector {
    protected String endpointUrl;
    protected RepositoryConnection connection;
    protected Repository repo;

    public RDFConnector(String endpoint) throws RepositoryException {
        this.endpointUrl = endpoint;
        this.connection = null;
        this.initRepository();
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        if (this.connection == null) {
            this.connection = this.repo.getConnection();
        }
        return this.connection;
    }

    public void closeConnection() throws RepositoryException {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    protected void initRepository() throws RepositoryException {
        this.repo = new SPARQLRepository(this.endpointUrl);
        this.repo.initialize();
    }

    public void add(Resource s, URI p, Value o) {
        try {
            StatementImpl stmt = new StatementImpl(s, p, o);
            this.connection.add((Statement)stmt, new Resource[0]);
            this.connection.commit();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public TupleQueryResult executeQuery(String queryString) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try {
            TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
            TupleQueryResult tqr = query.evaluate();
            return tqr;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void addNamespace(String newNamespace) {
    }

    public void removeNamespace(String namespace) throws RepositoryException {
        this.repo.getConnection().removeNamespace(namespace);
    }

    public RepositoryResult<Namespace> getAllNamespaces() throws RepositoryException {
        return this.repo.getConnection().getNamespaces();
    }
}

