/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.fit.layout.api.PageSet;
import org.fit.layout.api.PageStorage;
import org.fit.layout.api.ScriptObject;
import org.fit.layout.api.ServiceManager;
import org.fit.layout.gui.Browser;
import org.fit.layout.gui.BrowserPlugin;
import org.fit.layout.gui.GUIUpdateListener;
import org.fit.layout.gui.GUIUpdateSource;
import org.fit.layout.gui.TreeListener;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.storage.AreaModelLoader;
import org.fit.layout.storage.RDFStorage;
import org.fit.layout.storage.gui.ConnectDialog;
import org.fit.layout.storage.gui.ScriptApi;
import org.fit.layout.storage.model.RDFAreaTree;
import org.fit.layout.storage.model.RDFPage;
import org.fit.layout.storage.service.RDFStorageService;
import org.openrdf.model.URI;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;

public class StoragePlugin
implements BrowserPlugin,
GUIUpdateSource,
TreeListener {
    private Browser browser;
    private List<GUIUpdateListener> updateListeners;
    private RDFStorage bdi = null;
    private boolean connected = false;
    private int loadedPageIndex = -1;
    private Vector<String> listColumns;
    private Vector<Vector<String>> listData;
    private Vector<URI> listPageURIs;
    private Vector<URI> listTreeURIs;
    private JPanel pnl_main;
    private JPanel tbr_connection;
    private JLabel lblStatus;
    private JPanel tbr_storageSelection;
    private JPanel tbr_control;
    private JButton btn_saveAsNew;
    private JButton btn_removeModel;
    private JButton btn_load;
    private JButton btn_updateModel;
    private JPanel tbr_pageset;
    private JLabel lblPageSets;
    private JList<PageSet> pageSetList;
    private JButton btnNew;
    private JScrollPane pageSourceScroll;
    private JButton btnDelete;
    private JButton btnConnect;
    private JTable pageTable;
    private JScrollPane tableScroll;

    public boolean init(Browser browser) {
        this.browser = browser;
        this.browser.addToolPanel("RDF Storage", (JComponent)this.getPnl_main());
        this.browser.addTreeListener((TreeListener)this);
        this.updateListeners = new ArrayList<GUIUpdateListener>();
        this.initStorageServices();
        this.listColumns = new Vector();
        this.listColumns.add("PageID");
        this.listColumns.add("Date");
        this.listColumns.add("Title");
        this.listColumns.add("URL");
        this.listColumns.add("TreeID");
        this.listData = new Vector();
        this.listPageURIs = new Vector();
        this.listTreeURIs = new Vector();
        this.updatePageTable();
        this.updatePageSets();
        this.updateGUIState();
        return true;
    }

    private void initStorageServices() {
        Map services = ServiceManager.findPageStorages();
        for (PageStorage storage : services.values()) {
            if (!(storage instanceof RDFStorageService)) continue;
            ((RDFStorageService)storage).setPlugin(this);
        }
        Map scripts = ServiceManager.findScriptObjects();
        for (ScriptObject script : scripts.values()) {
            if (!(script instanceof ScriptApi)) continue;
            ((ScriptApi)script).setPlugin(this);
        }
    }

    public void pageRendered(Page page) {
        this.updateGUIState();
    }

    public void areaTreeUpdated(AreaTree tree) {
        this.updateGUIState();
    }

    public void logicalAreaTreeUpdated(LogicalAreaTree tree) {
        this.updateGUIState();
    }

    public void registerGUIUpdateListener(GUIUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void setStorage(RDFStorage storage) {
        try {
            this.bdi = storage;
            this.bdi.getLastSequenceValue("box");
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            e.printStackTrace();
        }
        this.updateStorageState();
    }

    public void updateStorageState() {
        this.fillPageTable();
        this.updatePageSets();
        this.updateGUIState();
    }

    public void closeStorage() {
        this.clearPageTable();
        this.updatePageSets();
        this.updateGUIState();
    }

    private void connect(String DBConnectionUrl) {
        try {
            this.bdi = new RDFStorage(DBConnectionUrl);
            this.bdi.getLastSequenceValue("box");
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.getPnl_main(), "Couldn't connect the repository: " + e.getMessage(), "Connection Error", 0);
        }
        this.updateGUIState();
    }

    public void disconnect() {
        if (this.connected) {
            try {
                this.bdi.closeConnection();
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        this.connected = false;
        this.updateGUIState();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Vector<Vector<String>> getPageListData() {
        return this.listData;
    }

    public void updateGUIState() {
        if (this.connected) {
            this.getBtnConnect().setText("Disconnect");
            this.getLblStatus().setText("Connected");
            boolean psetAvail = this.getPageSetList().getSelectedIndex() != -1;
            boolean loaded = this.browser.getPage() != null && this.browser.getPage() instanceof RDFPage && this.browser.getAreaTree() != null && this.browser.getAreaTree() instanceof RDFAreaTree;
            boolean pageSelected = this.getSelectedPageURI() != null;
            this.getBtn_load().setEnabled(pageSelected);
            this.getBtn_saveAsNew().setEnabled(psetAvail);
            this.getBtn_removeModel().setEnabled(pageSelected);
            this.getBtn_updateModel().setEnabled(psetAvail && loaded);
            this.getBtnNew().setEnabled(true);
            this.getBtnDelete().setEnabled(psetAvail);
        } else {
            this.getBtnConnect().setText("Connect...");
            this.getLblStatus().setText("Not connected");
            this.getBtn_load().setEnabled(false);
            this.getBtn_saveAsNew().setEnabled(false);
            this.getBtn_removeModel().setEnabled(false);
            this.getBtn_updateModel().setEnabled(false);
            this.getBtnNew().setEnabled(false);
            this.getBtnDelete().setEnabled(false);
        }
        for (GUIUpdateListener listener : this.updateListeners) {
            listener.updateGUI();
        }
    }

    private void updatePageTable() {
        DefaultTableModel model = new DefaultTableModel(this.listData, this.listColumns){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.pageTable.setModel(model);
        if (this.listData.size() > 0) {
            this.pageTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void clearPageTable() {
        this.listData.removeAllElements();
        this.listPageURIs.removeAllElements();
        this.listTreeURIs.removeAllElements();
        this.updatePageTable();
    }

    private void fillPageTable() {
        this.listData.removeAllElements();
        this.listPageURIs.removeAllElements();
        this.listTreeURIs.removeAllElements();
        PageSet pset = this.getSelectedPageSet();
        if (pset != null) {
            try {
                String prevPageUri = "";
                TupleQueryResult data = this.bdi.getAvailableTrees(pset.getName());
                while (data.hasNext()) {
                    BindingSet tuple = (BindingSet)data.next();
                    if (!(tuple.getBinding("tree").getValue() instanceof URI) || !(tuple.getBinding("page").getValue() instanceof URI)) continue;
                    this.listPageURIs.add((URI)tuple.getBinding("page").getValue());
                    this.listTreeURIs.add((URI)tuple.getBinding("tree").getValue());
                    Vector<String> row = new Vector<String>(this.listColumns.size());
                    String pageUri = tuple.getBinding("page").getValue().stringValue();
                    if (pageUri.equals(prevPageUri)) {
                        row.add("");
                        row.add("");
                        row.add("");
                        row.add("");
                    } else {
                        row.add(this.formatURI(pageUri));
                        row.add(tuple.getBinding("date").getValue().stringValue());
                        row.add(tuple.getBinding("title").getValue().stringValue());
                        row.add(tuple.getBinding("url").getValue().stringValue());
                    }
                    row.add(this.formatURI(tuple.getBinding("tree").getValue().stringValue()));
                    this.listData.add(row);
                    prevPageUri = pageUri;
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
            catch (QueryEvaluationException e) {
                e.printStackTrace();
            }
        }
        this.updatePageTable();
    }

    private String formatURI(String src) {
        if (src.startsWith("http://fitlayout.github.io/resource/")) {
            return src.substring("http://fitlayout.github.io/resource/".length());
        }
        return src;
    }

    public int getLoadedPageIndex() {
        return this.loadedPageIndex;
    }

    public void setSelectedPageIndex(int index) {
        this.getPageTable().setRowSelectionInterval(index, index);
    }

    private URI getSelectedPageURI() {
        int sel = this.getPageTable().getSelectedRow();
        if (sel != -1) {
            return this.listPageURIs.elementAt(sel);
        }
        return null;
    }

    public void loadSelectedPage() {
        RDFPage page = null;
        RDFAreaTree atree = null;
        LogicalAreaTree ltree = null;
        try {
            URI pageId = this.getSelectedPageURI();
            if (pageId != null && (page = this.bdi.loadPage(pageId)) != null) {
                URI atreeUri = this.getSelectedTreeURI();
                AreaModelLoader loader = this.bdi.loadAreaTrees(atreeUri, page);
                atree = loader.getAreaTree();
                ltree = loader.getLogicalAreaTree();
                this.loadedPageIndex = this.getPageTable().getSelectedRow();
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.isEmpty()) {
                msg = "Exception occured: " + e.toString();
            }
            JOptionPane.showMessageDialog(this.getPnl_main(), msg, "Loading Error", 0);
        }
        if (page != null) {
            this.browser.setPage((Page)page);
        }
        if (atree != null) {
            this.browser.setAreaTree(atree);
        }
        if (ltree != null) {
            this.browser.setLogicalTree(ltree);
        }
        this.browser.refreshView();
        this.updateGUIState();
    }

    public boolean isSaveAvailable() {
        Page page = this.browser.getPage();
        AreaTree atree = this.browser.getAreaTree();
        return this.connected && page != null && atree != null;
    }

    public void saveCurrentPage() {
        Page page = this.browser.getPage();
        AreaTree atree = this.browser.getAreaTree();
        LogicalAreaTree ltree = this.browser.getLogicalTree();
        if (page != null && atree != null) {
            RDFPage rdfpage = null;
            if (page instanceof RDFPage) {
                rdfpage = (RDFPage)page;
            } else {
                try {
                    rdfpage = this.bdi.insertPageBoxModel(page);
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
            }
            if (rdfpage != null) {
                try {
                    PageSet currentPset = this.getSelectedPageSet();
                    if (currentPset != null) {
                        this.bdi.addPageToPageSet(rdfpage.getUri(), currentPset.getName());
                    }
                    this.bdi.insertAreaTree(atree, ltree, rdfpage.getUri());
                }
                catch (RepositoryException e1) {
                    e1.printStackTrace();
                }
            }
            this.fillPageTable();
        } else {
            JOptionPane.showMessageDialog(this.getPnl_main(), "No area tree found. The page segmentation should be performed first.", "Error", 0);
        }
    }

    public boolean isUpdateAvailable() {
        Page page = this.browser.getPage();
        AreaTree atree = this.browser.getAreaTree();
        return this.connected && page != null && page instanceof RDFPage && atree != null && atree instanceof RDFAreaTree;
    }

    public void updateCurrentPage() {
        Page page = this.browser.getPage();
        AreaTree atree = this.browser.getAreaTree();
        LogicalAreaTree ltree = this.browser.getLogicalTree();
        if (page != null && atree != null) {
            if (page instanceof RDFPage && atree instanceof RDFAreaTree) {
                RDFPage rdfpage = (RDFPage)page;
                try {
                    URI atreeUri = ((RDFAreaTree)atree).getUri();
                    this.bdi.removeAreaTree(atreeUri);
                    this.bdi.insertAreaTree(atreeUri, atree, ltree, rdfpage.getUri());
                }
                catch (RepositoryException e1) {
                    e1.printStackTrace();
                }
                this.fillPageTable();
            } else {
                JOptionPane.showMessageDialog(this.getPnl_main(), "The page or area tree have not been stored. Cannot update.", "Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this.getPnl_main(), "No area tree found. The page segmentation should be performed first.", "Error", 0);
        }
        this.fillPageTable();
    }

    private URI getSelectedTreeURI() {
        int sel = this.getPageTable().getSelectedRow();
        if (sel != -1) {
            return this.listTreeURIs.elementAt(sel);
        }
        return null;
    }

    public PageSet getSelectedPageSet() {
        return this.getPageSetList().getSelectedValue();
    }

    private void updatePageSets() {
        PageSet current = this.getSelectedPageSet();
        DefaultListModel model = (DefaultListModel)this.getPageSetList().getModel();
        model.removeAllElements();
        if (this.connected) {
            try {
                List<PageSet> sets = this.bdi.getPageSets();
                for (PageSet pset : sets) {
                    model.addElement(pset);
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        if (current == null) {
            this.getPageSetList().setSelectedIndex(0);
        } else {
            this.getPageSetList().setSelectedValue(current, true);
        }
    }

    private JPanel getPnl_main() {
        if (this.pnl_main == null) {
            this.pnl_main = new JPanel();
            GridBagLayout gbl_main = new GridBagLayout();
            gbl_main.columnWeights = new double[]{0.0, 0.0, 0.0};
            gbl_main.rowWeights = new double[]{0.0, 0.0};
            this.pnl_main.setLayout(gbl_main);
            GridBagConstraints gbc_connection = new GridBagConstraints();
            gbc_connection.fill = 1;
            gbc_connection.anchor = 13;
            gbc_connection.insets = new Insets(0, 0, 5, 5);
            gbc_connection.gridx = 0;
            gbc_connection.gridy = 0;
            this.pnl_main.add((Component)this.getPnl_connection(), gbc_connection);
            GridBagConstraints gbc_storageSelection = new GridBagConstraints();
            gbc_storageSelection.gridheight = 2;
            gbc_storageSelection.weightx = 1.0;
            gbc_storageSelection.fill = 1;
            gbc_storageSelection.insets = new Insets(0, 0, 5, 0);
            gbc_storageSelection.gridx = 1;
            gbc_storageSelection.gridy = 0;
            this.pnl_main.add((Component)this.getPnl_storageSelection(), gbc_storageSelection);
            GridBagConstraints gbc_control = new GridBagConstraints();
            gbc_control.gridheight = 2;
            gbc_control.anchor = 13;
            gbc_control.fill = 1;
            gbc_control.insets = new Insets(0, 0, 5, 0);
            gbc_control.gridx = 2;
            gbc_control.gridy = 0;
            this.pnl_main.add((Component)this.getPnl_control(), gbc_control);
            GridBagConstraints gbc_tbr_pageset = new GridBagConstraints();
            gbc_tbr_pageset.weighty = 1.0;
            gbc_tbr_pageset.insets = new Insets(0, 0, 0, 5);
            gbc_tbr_pageset.fill = 1;
            gbc_tbr_pageset.gridx = 0;
            gbc_tbr_pageset.gridy = 1;
            this.pnl_main.add((Component)this.getTbr_pageset(), gbc_tbr_pageset);
        }
        return this.pnl_main;
    }

    private JPanel getPnl_connection() {
        if (this.tbr_connection == null) {
            this.tbr_connection = new JPanel();
            FlowLayout flowLayout = (FlowLayout)this.tbr_connection.getLayout();
            flowLayout.setAlignment(0);
            this.tbr_connection.add(this.getBtnConnect());
            this.tbr_connection.add(this.getLblStatus());
        }
        return this.tbr_connection;
    }

    private JLabel getLblStatus() {
        if (this.lblStatus == null) {
            this.lblStatus = new JLabel("Not connected");
        }
        return this.lblStatus;
    }

    private JPanel getPnl_storageSelection() {
        if (this.tbr_storageSelection == null) {
            this.tbr_storageSelection = new JPanel();
            GridBagLayout gbl_tbr_storageSelection = new GridBagLayout();
            gbl_tbr_storageSelection.columnWeights = new double[]{0.0};
            gbl_tbr_storageSelection.rowWeights = new double[]{0.0};
            this.tbr_storageSelection.setLayout(gbl_tbr_storageSelection);
            GridBagConstraints gbc_tableScroll = new GridBagConstraints();
            gbc_tableScroll.weighty = 1.0;
            gbc_tableScroll.weightx = 1.0;
            gbc_tableScroll.fill = 1;
            gbc_tableScroll.anchor = 18;
            gbc_tableScroll.gridx = 0;
            gbc_tableScroll.gridy = 0;
            this.tbr_storageSelection.add((Component)this.getTableScroll(), gbc_tableScroll);
        }
        return this.tbr_storageSelection;
    }

    private JPanel getPnl_control() {
        if (this.tbr_control == null) {
            this.tbr_control = new JPanel();
            GridBagLayout gbl_tbr_control = new GridBagLayout();
            gbl_tbr_control.columnWeights = new double[]{1.0};
            gbl_tbr_control.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            this.tbr_control.setLayout(gbl_tbr_control);
            GridBagConstraints gbc_btn_saveBoxTreeModel = new GridBagConstraints();
            gbc_btn_saveBoxTreeModel.insets = new Insets(5, 0, 5, 0);
            gbc_btn_saveBoxTreeModel.gridx = 0;
            gbc_btn_saveBoxTreeModel.gridy = 4;
            this.tbr_control.add((Component)this.getBtn_saveAsNew(), gbc_btn_saveBoxTreeModel);
            GridBagConstraints gbc_btn_saveAreaTreeModel = new GridBagConstraints();
            gbc_btn_saveAreaTreeModel.insets = new Insets(0, 0, 5, 0);
            gbc_btn_saveAreaTreeModel.gridx = 0;
            gbc_btn_saveAreaTreeModel.gridy = 1;
            this.tbr_control.add((Component)this.getBtn_updateModel(), gbc_btn_saveAreaTreeModel);
            GridBagConstraints gbc_btn_removePage = new GridBagConstraints();
            gbc_btn_removePage.insets = new Insets(0, 0, 5, 0);
            gbc_btn_removePage.gridx = 0;
            gbc_btn_removePage.gridy = 2;
            this.tbr_control.add((Component)this.getBtn_removeModel(), gbc_btn_removePage);
            GridBagConstraints gbc_btn_clearDB = new GridBagConstraints();
            gbc_btn_clearDB.insets = new Insets(0, 0, 5, 0);
            gbc_btn_clearDB.gridx = 0;
            gbc_btn_clearDB.gridy = 0;
            this.tbr_control.add((Component)this.getBtn_load(), gbc_btn_clearDB);
        }
        return this.tbr_control;
    }

    private JButton getBtn_saveAsNew() {
        if (this.btn_saveAsNew == null) {
            this.btn_saveAsNew = new JButton("Insert new");
            this.btn_saveAsNew.setEnabled(false);
            this.btn_saveAsNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    StoragePlugin.this.saveCurrentPage();
                }
            });
        }
        return this.btn_saveAsNew;
    }

    private JButton getBtn_removeModel() {
        if (this.btn_removeModel == null) {
            this.btn_removeModel = new JButton("Delete");
            this.btn_removeModel.setEnabled(false);
            this.btn_removeModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int response = JOptionPane.showConfirmDialog(StoragePlugin.this.getPnl_main(), "Do you want to remove the selected tree?", "Confirm", 0, 3);
                    if (response == 0) {
                        try {
                            URI pageId = StoragePlugin.this.getSelectedPageURI();
                            URI areaTreeId = StoragePlugin.this.getSelectedTreeURI();
                            StoragePlugin.this.bdi.removeAreaTree(areaTreeId);
                            Set<URI> remainingTrees = StoragePlugin.this.bdi.getAreaTreeIdsForPageId(pageId);
                            if (remainingTrees.isEmpty()) {
                                StoragePlugin.this.bdi.removePage(pageId);
                            }
                            StoragePlugin.this.fillPageTable();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        return this.btn_removeModel;
    }

    private JButton getBtn_load() {
        if (this.btn_load == null) {
            this.btn_load = new JButton("Load");
            this.btn_load.setEnabled(false);
            this.btn_load.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    StoragePlugin.this.loadSelectedPage();
                }
            });
        }
        return this.btn_load;
    }

    private JButton getBtn_updateModel() {
        if (this.btn_updateModel == null) {
            this.btn_updateModel = new JButton("Update");
            this.btn_updateModel.setEnabled(false);
            this.btn_updateModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StoragePlugin.this.updateCurrentPage();
                }
            });
        }
        return this.btn_updateModel;
    }

    private JPanel getTbr_pageset() {
        if (this.tbr_pageset == null) {
            this.tbr_pageset = new JPanel();
            GridBagLayout gbl_tbr_pageset = new GridBagLayout();
            gbl_tbr_pageset.columnWidths = new int[]{0, 0, 0, 0};
            gbl_tbr_pageset.rowHeights = new int[]{0, 0, 0};
            gbl_tbr_pageset.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0};
            gbl_tbr_pageset.rowWeights = new double[]{0.0, 1.0, 0.0};
            this.tbr_pageset.setLayout(gbl_tbr_pageset);
            GridBagConstraints gbc_lblPageSets = new GridBagConstraints();
            gbc_lblPageSets.gridwidth = 4;
            gbc_lblPageSets.insets = new Insets(0, 0, 5, 0);
            gbc_lblPageSets.fill = 2;
            gbc_lblPageSets.gridx = 0;
            gbc_lblPageSets.gridy = 0;
            this.tbr_pageset.add((Component)this.getLblPageSets(), gbc_lblPageSets);
            GridBagConstraints gbc_pageSourceScroll = new GridBagConstraints();
            gbc_pageSourceScroll.gridwidth = 4;
            gbc_pageSourceScroll.fill = 1;
            gbc_pageSourceScroll.insets = new Insets(0, 0, 5, 0);
            gbc_pageSourceScroll.gridx = 0;
            gbc_pageSourceScroll.gridy = 1;
            this.tbr_pageset.add((Component)this.getPageSourceScroll(), gbc_pageSourceScroll);
            GridBagConstraints gbc_btnNew = new GridBagConstraints();
            gbc_btnNew.insets = new Insets(0, 0, 5, 5);
            gbc_btnNew.gridx = 1;
            gbc_btnNew.gridy = 2;
            this.tbr_pageset.add((Component)this.getBtnNew(), gbc_btnNew);
            GridBagConstraints gbc_btnDelete = new GridBagConstraints();
            gbc_btnDelete.insets = new Insets(0, 0, 5, 5);
            gbc_btnDelete.gridx = 3;
            gbc_btnDelete.gridy = 2;
            this.tbr_pageset.add((Component)this.getBtnDelete(), gbc_btnDelete);
        }
        return this.tbr_pageset;
    }

    private JLabel getLblPageSets() {
        if (this.lblPageSets == null) {
            this.lblPageSets = new JLabel("Page Sets");
        }
        return this.lblPageSets;
    }

    private JList<PageSet> getPageSetList() {
        if (this.pageSetList == null) {
            this.pageSetList = new JList();
            this.pageSetList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent arg0) {
                    StoragePlugin.this.updateGUIState();
                    StoragePlugin.this.fillPageTable();
                }
            });
            this.pageSetList.setModel(new DefaultListModel());
        }
        return this.pageSetList;
    }

    private JButton getBtnNew() {
        if (this.btnNew == null) {
            this.btnNew = new JButton("New...");
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = JOptionPane.showInputDialog(StoragePlugin.this.btnNew, "New page set name", "New page set", 3);
                    if (name != null && !name.trim().isEmpty()) {
                        try {
                            StoragePlugin.this.bdi.createPageSet(name);
                        }
                        catch (RepositoryException e1) {
                            e1.printStackTrace();
                        }
                        StoragePlugin.this.updatePageSets();
                    }
                }
            });
        }
        return this.btnNew;
    }

    private JScrollPane getPageSourceScroll() {
        if (this.pageSourceScroll == null) {
            this.pageSourceScroll = new JScrollPane();
            this.pageSourceScroll.setViewportView(this.getPageSetList());
        }
        return this.pageSourceScroll;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton("Delete");
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PageSet pset = StoragePlugin.this.getSelectedPageSet();
                    if (pset != null) {
                        String message = "Do you want to remove the selected page set?";
                        JCheckBox cbox = new JCheckBox("Also delete orphaned pages", true);
                        if (StoragePlugin.this.listPageURIs.size() == 0) {
                            cbox.setEnabled(false);
                            cbox.setSelected(false);
                        }
                        Object[] params = new Object[]{message, cbox};
                        int response = JOptionPane.showConfirmDialog(StoragePlugin.this.btnDelete, params, "Confirm", 0, 2);
                        if (response == 0) {
                            try {
                                StoragePlugin.this.bdi.deletePageSet(pset.getName());
                                if (cbox.isSelected()) {
                                    StoragePlugin.this.bdi.removeOrphanedPages();
                                }
                            }
                            catch (RepositoryException e) {
                                e.printStackTrace();
                            }
                            StoragePlugin.this.updatePageSets();
                        }
                    }
                }
            });
        }
        return this.btnDelete;
    }

    private JButton getBtnConnect() {
        if (this.btnConnect == null) {
            this.btnConnect = new JButton("Connect...");
            this.btnConnect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!StoragePlugin.this.connected) {
                        String urlstring = ConnectDialog.show("sesame:http://localhost:8080/openrdf-sesame/repositories/user");
                        if (urlstring != null) {
                            StoragePlugin.this.connect(urlstring);
                            StoragePlugin.this.fillPageTable();
                            StoragePlugin.this.updatePageSets();
                            StoragePlugin.this.updateGUIState();
                        }
                    } else {
                        StoragePlugin.this.disconnect();
                        StoragePlugin.this.clearPageTable();
                        StoragePlugin.this.updatePageSets();
                        StoragePlugin.this.updateGUIState();
                    }
                }
            });
        }
        return this.btnConnect;
    }

    private JTable getPageTable() {
        if (this.pageTable == null) {
            this.pageTable = new JTable();
            this.pageTable.setSelectionMode(0);
            this.pageTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    JTable table = (JTable)me.getSource();
                    Point p = me.getPoint();
                    int row = table.rowAtPoint(p);
                    if (me.getClickCount() == 2 && row != -1) {
                        StoragePlugin.this.loadSelectedPage();
                    }
                }
            });
        }
        return this.pageTable;
    }

    private JScrollPane getTableScroll() {
        if (this.tableScroll == null) {
            this.tableScroll = new JScrollPane();
            this.tableScroll.setViewportView(this.getPageTable());
        }
        return this.tableScroll;
    }
}

