/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.model;

import java.util.Collections;
import java.util.Comparator;
import org.fit.layout.impl.DefaultArea;
import org.fit.layout.model.Box;
import org.fit.layout.model.Rectangular;
import org.fit.layout.storage.model.RDFBox;
import org.fit.layout.storage.model.RDFResource;
import org.openrdf.model.URI;

public class RDFArea
extends DefaultArea
implements RDFResource {
    protected URI uri;
    protected int documentOrder;

    public RDFArea(Rectangular r, URI uri) {
        super(r);
        this.setUri(uri);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
        this.setId(Integer.parseInt(uri.getLocalName().substring(1)));
    }

    public int getDocumentOrder() {
        return this.documentOrder;
    }

    public void setDocumentOrder(int documentOrder) {
        this.documentOrder = documentOrder;
    }

    public void sortBoxes() {
        Collections.sort(this.getBoxes(), new Comparator<Box>(){

            @Override
            public int compare(Box box1, Box box2) {
                if (box1 instanceof RDFBox && box2 instanceof RDFBox) {
                    return ((RDFBox)box1).getDocumentOrder() - ((RDFBox)box2).getDocumentOrder();
                }
                return 0;
            }
        });
    }
}

