/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.model;

import java.util.Map;
import org.fit.layout.impl.DefaultAreaTree;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.storage.model.RDFArea;
import org.fit.layout.storage.model.RDFLogicalArea;
import org.fit.layout.storage.model.RDFPage;
import org.fit.layout.storage.model.RDFResource;
import org.openrdf.model.URI;

public class RDFAreaTree
extends DefaultAreaTree
implements RDFResource {
    protected URI uri;
    protected Map<URI, RDFArea> areaUris;
    protected Map<URI, RDFLogicalArea> logicalAreaUris;

    public RDFAreaTree(Page page, URI uri) {
        super(page);
        this.uri = uri;
    }

    public RDFAreaTree(AreaTree src, URI uri) {
        super(src);
        this.uri = uri;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getPageUri() {
        if (this.getPage() != null && this.getPage() instanceof RDFPage) {
            return ((RDFPage)this.getPage()).getUri();
        }
        return null;
    }

    public Map<URI, RDFArea> getAreaUris() {
        return this.areaUris;
    }

    public void setAreaUris(Map<URI, RDFArea> areaUris) {
        this.areaUris = areaUris;
    }

    public RDFArea findAreaByUri(URI uri) {
        if (this.areaUris != null) {
            return this.areaUris.get(uri);
        }
        return null;
    }

    public Map<URI, RDFLogicalArea> getLogicalAreaUris() {
        return this.logicalAreaUris;
    }

    public void setLogicalAreaUris(Map<URI, RDFLogicalArea> logicalAreaUris) {
        this.logicalAreaUris = logicalAreaUris;
    }

    public RDFLogicalArea findLogicalAreaByUri(URI uri) {
        if (this.logicalAreaUris != null) {
            return this.logicalAreaUris.get(uri);
        }
        return null;
    }
}

