/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.model;

import org.fit.layout.impl.DefaultBox;
import org.fit.layout.model.Box;
import org.fit.layout.storage.model.RDFResource;
import org.openrdf.model.URI;

public class RDFBox
extends DefaultBox
implements RDFResource {
    protected URI uri;
    protected int documentOrder;

    public RDFBox(URI uri) {
        this.setUri(uri);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
        this.setId(Integer.parseInt(uri.getLocalName()));
    }

    public int getDocumentOrder() {
        return this.documentOrder;
    }

    public void setDocumentOrder(int documentOrder) {
        this.documentOrder = documentOrder;
    }

    public String toString() {
        String ret = this.getId() + " ";
        if (this.getType() == Box.Type.TEXT_CONTENT) {
            ret = ret + this.getText();
        } else if (this.getType() == Box.Type.REPLACED_CONTENT) {
            ret = this.getContentObject() != null ? ret + this.getContentObject().toString() : ret + "(null object)";
        } else {
            ret = ret + "<" + this.getTagName();
            if (this.getAttribute("id") != null) {
                ret = ret + " id=" + this.getAttribute("id");
            }
            if (this.getAttribute("class") != null) {
                ret = ret + " class=" + this.getAttribute("class");
            }
            ret = ret + ">";
        }
        return ret;
    }
}

