/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.service;

import java.util.ArrayList;
import java.util.List;
import org.fit.layout.api.PageSet;
import org.fit.layout.api.PageSetStorage;
import org.fit.layout.api.PageStorage;
import org.fit.layout.gui.GUIUpdateListener;
import org.fit.layout.storage.gui.StoragePlugin;

public class RDFStorageService
implements PageStorage,
PageSetStorage {
    private StoragePlugin plugin;
    private List<GUIUpdateListener> updateListeners = new ArrayList<GUIUpdateListener>();

    public void setPlugin(StoragePlugin plugin) {
        this.plugin = plugin;
        for (GUIUpdateListener listener : this.updateListeners) {
            plugin.registerGUIUpdateListener(listener);
        }
    }

    public String getId() {
        return "FitLayout.RDF.Storage";
    }

    public String getName() {
        return "RDF Page Storage";
    }

    public String getDescription() {
        return "Stores the page data in a RDF repository";
    }

    public void registerGUIUpdateListener(GUIUpdateListener listener) {
        this.updateListeners.add(listener);
        if (this.plugin != null) {
            this.plugin.registerGUIUpdateListener(listener);
        }
    }

    public PageSet getCurrentPageSet() {
        if (this.plugin != null && this.plugin.isConnected()) {
            return this.plugin.getSelectedPageSet();
        }
        return null;
    }

    public boolean nextPageAvailable() {
        if (this.plugin != null && this.plugin.isConnected()) {
            int cur = this.getCurrentIndex();
            return cur < this.getTotalCount() - 1;
        }
        return false;
    }

    public void loadNext() {
        if (this.nextPageAvailable()) {
            this.loadPageAt(this.getCurrentIndex() + 1);
        }
    }

    public boolean previousPageAvailable() {
        if (this.plugin != null && this.plugin.isConnected()) {
            return this.getCurrentIndex() > 0;
        }
        return false;
    }

    public void loadPrevious() {
        if (this.previousPageAvailable()) {
            this.loadPageAt(this.getCurrentIndex() - 1);
        }
    }

    public int getTotalCount() {
        if (this.plugin != null && this.plugin.isConnected()) {
            return this.plugin.getPageListData().size();
        }
        return 0;
    }

    public int getCurrentIndex() {
        if (this.plugin != null && this.plugin.isConnected()) {
            return this.plugin.getLoadedPageIndex();
        }
        return -1;
    }

    public void loadPageAt(int index) {
        if (this.plugin != null && this.plugin.isConnected()) {
            this.plugin.setSelectedPageIndex(index);
            this.plugin.loadSelectedPage();
        }
    }

    public boolean saveAvailable() {
        return this.plugin != null && this.plugin.isSaveAvailable();
    }

    public void saveCurrentPage() {
        if (this.plugin != null && this.plugin.isSaveAvailable()) {
            this.plugin.saveCurrentPage();
        }
    }

    public boolean updateAvailable() {
        return this.plugin != null && this.plugin.isUpdateAvailable();
    }

    public void updateCurrentPage() {
        if (this.plugin != null && this.plugin.isUpdateAvailable()) {
            this.plugin.updateCurrentPage();
        }
    }
}

