/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.tagViewer.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.fit.layout.gui.Browser;
import org.fit.layout.gui.BrowserPlugin;
import org.fit.layout.impl.DefaultTag;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Tag;

public class TagViewerPlugin
implements BrowserPlugin {
    private Browser browser;
    private JPanel pnl_mainPanel;
    private JPanel pnl_control;
    private JButton btn_loadAllTags;
    private JScrollPane scrl_tagTable;
    private JTable tagTable;
    private DefaultTableModel tagModelTable;
    private JLabel lbl_found;

    public boolean init(Browser browser) {
        this.browser = browser;
        browser.addStructurePanel("Tag viewer", (JComponent)this.getPnl_mainPanel());
        return true;
    }

    private JPanel getPnl_mainPanel() {
        if (this.pnl_mainPanel == null) {
            this.pnl_mainPanel = new JPanel();
            GridBagLayout gbl_pathsPanel = new GridBagLayout();
            gbl_pathsPanel.columnWidths = new int[]{0, 0};
            gbl_pathsPanel.rowHeights = new int[]{0, 0, 0};
            gbl_pathsPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_pathsPanel.rowWeights = new double[]{0.1, 1.0, Double.MIN_VALUE};
            this.pnl_mainPanel.setLayout(gbl_pathsPanel);
            GridBagConstraints gbc_control = new GridBagConstraints();
            gbc_control.fill = 2;
            gbc_control.gridx = 0;
            gbc_control.gridy = 0;
            this.pnl_mainPanel.add((Component)this.getPnl_control(), gbc_control);
            GridBagConstraints gbc_extractionScroll = new GridBagConstraints();
            gbc_extractionScroll.fill = 1;
            gbc_extractionScroll.gridx = 0;
            gbc_extractionScroll.gridy = 1;
            this.pnl_mainPanel.add((Component)this.getScrl_tagTable(), gbc_extractionScroll);
        }
        return this.pnl_mainPanel;
    }

    private JPanel getPnl_control() {
        if (this.pnl_control == null) {
            this.pnl_control = new JPanel();
            GridBagLayout gbl_pathsPanel = new GridBagLayout();
            gbl_pathsPanel.columnWidths = new int[]{0, 0};
            gbl_pathsPanel.rowHeights = new int[]{0, 0, 0};
            gbl_pathsPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_pathsPanel.rowWeights = new double[]{0.1, 1.0, Double.MIN_VALUE};
            this.pnl_control.setLayout(gbl_pathsPanel);
            GridBagConstraints gbc_control = new GridBagConstraints();
            gbc_control.fill = 2;
            gbc_control.gridx = 0;
            gbc_control.gridy = 0;
            this.pnl_control.add((Component)this.getBtn_loadAllTags(), gbc_control);
            GridBagConstraints gbc_extractionScroll = new GridBagConstraints();
            gbc_extractionScroll.fill = 1;
            gbc_extractionScroll.gridx = 0;
            gbc_extractionScroll.gridy = 1;
            this.pnl_control.add((Component)this.getLbl_found(), gbc_extractionScroll);
        }
        return this.pnl_control;
    }

    private JButton getBtn_loadAllTags() {
        if (this.btn_loadAllTags == null) {
            this.btn_loadAllTags = new JButton("Load all tags");
            this.btn_loadAllTags.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TagViewerPlugin.this.clearTagList();
                    TagViewerPlugin.this.fillTagListFromAreaTree(TagViewerPlugin.this.browser.getAreaTree());
                    TagViewerPlugin.this.getLbl_found().setText("Found:" + TagViewerPlugin.this.tagModelTable.getRowCount());
                }
            });
        }
        return this.btn_loadAllTags;
    }

    private JScrollPane getScrl_tagTable() {
        if (this.scrl_tagTable == null) {
            this.scrl_tagTable = new JScrollPane();
            this.scrl_tagTable.setViewportView(this.getTbl_classificationTags());
        }
        return this.scrl_tagTable;
    }

    private JTable getTbl_classificationTags() {
        if (this.tagTable == null) {
            this.tagModelTable = new DefaultTableModel();
            this.tagModelTable.addColumn("TagType");
            this.tagModelTable.addColumn("Tag");
            this.tagModelTable.addColumn("Content");
            this.tagTable = new JTable(this.tagModelTable);
        }
        return this.tagTable;
    }

    private void fillTagListFromAreaTree(AreaTree areaTree) {
        Area root = areaTree.getRoot();
        this.addAreaTagsToList(root.getTags(), root.getText());
        this.fillTagListFromParentArea(root);
    }

    private void fillTagListFromParentArea(Area parentArea) {
        for (Area area : parentArea.getChildAreas()) {
            this.addAreaTagsToList(area.getTags(), area.getText());
            this.fillTagListFromParentArea(area);
        }
    }

    private void addAreaTagsToList(Map<Tag, Float> tags, String text) {
        Set<Map.Entry<Tag, Float>> entrySet = tags.entrySet();
        for (Map.Entry<Tag, Float> et : entrySet) {
            this.addTagToList((DefaultTag)et.getKey(), text);
        }
    }

    private void addTagToList(DefaultTag tag, String text) {
        this.tagModelTable.addRow(new Object[]{tag.getType(), tag.getValue(), text});
    }

    private void clearTagList() {
        for (int i = this.tagModelTable.getRowCount(); i > 0; --i) {
            this.tagModelTable.removeRow(i - 1);
        }
    }

    private JLabel getLbl_found() {
        if (this.lbl_found == null) {
            this.lbl_found = new JLabel("");
            this.lbl_found.setHorizontalAlignment(0);
        }
        return this.lbl_found;
    }
}

