/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.Border;
import org.fit.layout.model.Box;
import org.fit.layout.model.Rectangular;
import org.fit.layout.storage.ModelLoader;
import org.fit.layout.storage.PageInfo;
import org.fit.layout.storage.RDFStorage;
import org.fit.layout.storage.model.RDFBox;
import org.fit.layout.storage.model.RDFContentImage;
import org.fit.layout.storage.model.RDFContentObject;
import org.fit.layout.storage.model.RDFPage;
import org.fit.layout.storage.ontology.BOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxModelLoader
extends ModelLoader {
    private static Logger log = LoggerFactory.getLogger(BoxModelLoader.class);
    private RDFStorage storage;
    private IRI pageIri;
    private Model borderModel;
    private Model attributeModel;
    private RDFPage page;

    public BoxModelLoader(RDFStorage storage, IRI pageIri) {
        this.storage = storage;
        this.pageIri = pageIri;
    }

    public RDFPage getPage() throws RepositoryException {
        if (this.page == null) {
            this.page = this.constructPage();
        }
        return this.page;
    }

    private RDFPage constructPage() throws RepositoryException {
        Model pageModel = this.storage.getPageInfo(this.pageIri);
        if (pageModel.size() > 0) {
            URL srcURL;
            PageInfo info = new PageInfo(pageModel);
            try {
                srcURL = new URL(info.getUrl());
            }
            catch (MalformedURLException e) {
                try {
                    srcURL = new URL("http://no/url");
                }
                catch (MalformedURLException e1) {
                    srcURL = null;
                }
            }
            RDFPage page = new RDFPage(srcURL, info.getId(), info.getDate());
            if (info.getTitle() != null) {
                page.setTitle(info.getTitle());
            }
            Model boxTreeModel = this.storage.getBoxModelForPage(this.pageIri);
            LinkedHashMap<IRI, RDFBox> boxes = new LinkedHashMap<IRI, RDFBox>();
            RDFBox root = this.constructBoxTree(boxTreeModel, boxes);
            page.setRoot((Box)root);
            page.setBoxIris(boxes);
            page.setWidth(root.getWidth());
            page.setHeight(root.getHeight());
            return page;
        }
        return null;
    }

    private RDFBox constructBoxTree(Model model, Map<IRI, RDFBox> boxes) throws RepositoryException {
        for (Resource res : model.subjects()) {
            if (!(res instanceof IRI)) continue;
            RDFBox box = this.createBoxFromModel(model, (IRI)res);
            boxes.put((IRI)res, box);
        }
        ArrayList<RDFBox> rootBoxes = new ArrayList<RDFBox>(boxes.values());
        for (Statement st : model.filter(null, BOX.isChildOf, null, new Resource[0])) {
            if (!(st.getSubject() instanceof IRI) || !(st.getObject() instanceof IRI)) continue;
            RDFBox parent = boxes.get(st.getObject());
            RDFBox child = boxes.get(st.getSubject());
            if (parent == null || child == null) continue;
            parent.add((GenericTreeNode)child);
            rootBoxes.remove(child);
        }
        if (rootBoxes.size() == 1) {
            return (RDFBox)rootBoxes.get(0);
        }
        log.error("Strange number of root boxes: {}", (Object)((Object)rootBoxes).toString());
        return null;
    }

    private RDFBox createBoxFromModel(Model model, IRI iri) throws RepositoryException {
        RDFBox box = new RDFBox(iri);
        box.setTagName("");
        box.setType(Box.Type.ELEMENT);
        box.setDisplayType(Box.DisplayType.BLOCK);
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        int vx = 0;
        int vy = 0;
        int vwidth = 0;
        int vheight = 0;
        for (Statement st : model.filter((Resource)iri, null, null, new Resource[0])) {
            Map.Entry<String, String> attr;
            RDFContentObject obj;
            Border border;
            IRI pred = st.getPredicate();
            Value value = st.getObject();
            if (BOX.documentOrder.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                box.setDocumentOrder(((Literal)value).intValue());
                continue;
            }
            if (BOX.backgroundColor.equals((Object)pred)) {
                String bgColor = value.stringValue();
                box.setBackgroundColor(this.hex2Rgb(bgColor));
                continue;
            }
            if (BOX.backgroundImagePosition.equals((Object)pred) || BOX.backgroundImageUrl.equals((Object)pred)) continue;
            if (BOX.color.equals((Object)pred)) {
                box.setColor(this.hex2Rgb(value.stringValue()));
                continue;
            }
            if (BOX.underline.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                box.setUnderline(((Literal)value).floatValue());
                continue;
            }
            if (BOX.lineThrough.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                box.setLineThrough(((Literal)value).floatValue());
                continue;
            }
            if (BOX.fontFamily.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                box.setFontFamily(value.stringValue());
                continue;
            }
            if (BOX.fontSize.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                box.setFontSize(((Literal)value).floatValue());
                continue;
            }
            if (BOX.fontStyle.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                box.setFontStyle(((Literal)value).floatValue());
                continue;
            }
            if (BOX.fontWeight.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                box.setFontWeight(((Literal)value).floatValue());
                continue;
            }
            if (BOX.hasBottomBorder.equals((Object)pred)) {
                if (!(value instanceof IRI)) continue;
                border = this.createBorder(this.getBorderModel(), (IRI)value);
                box.setBorderStyle(Border.Side.BOTTOM, border);
                continue;
            }
            if (BOX.hasLeftBorder.equals((Object)pred)) {
                if (!(value instanceof IRI)) continue;
                border = this.createBorder(this.getBorderModel(), (IRI)value);
                box.setBorderStyle(Border.Side.LEFT, border);
                continue;
            }
            if (BOX.hasRightBorder.equals((Object)pred)) {
                if (!(value instanceof IRI)) continue;
                border = this.createBorder(this.getBorderModel(), (IRI)value);
                box.setBorderStyle(Border.Side.RIGHT, border);
                continue;
            }
            if (BOX.hasTopBorder.equals((Object)pred)) {
                if (!(value instanceof IRI)) continue;
                border = this.createBorder(this.getBorderModel(), (IRI)value);
                box.setBorderStyle(Border.Side.TOP, border);
                continue;
            }
            if (BOX.hasText.equals((Object)pred)) {
                if (box.getType() != Box.Type.REPLACED_CONTENT) {
                    box.setType(Box.Type.TEXT_CONTENT);
                }
                box.setText(value.stringValue());
                continue;
            }
            if (BOX.containsImage.equals((Object)pred)) {
                box.setType(Box.Type.REPLACED_CONTENT);
                if (!(value instanceof IRI)) continue;
                obj = new RDFContentImage((IRI)value);
                Value val = this.storage.getPropertyValue((Resource)((IRI)value), BOX.imageUrl);
                if (val != null && val instanceof Literal) {
                    try {
                        ((RDFContentImage)obj).setUrl(((Literal)val).stringValue());
                    }
                    catch (MalformedURLException e) {
                        log.error(e.getMessage());
                    }
                }
                box.setContentObject(obj);
                continue;
            }
            if (BOX.containsObject.equals((Object)pred)) {
                box.setType(Box.Type.REPLACED_CONTENT);
                if (!(value instanceof IRI)) continue;
                obj = new RDFContentObject((IRI)value);
                box.setContentObject(obj);
                continue;
            }
            if (BOX.height.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                height = ((Literal)value).intValue();
                continue;
            }
            if (BOX.width.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                width = ((Literal)value).intValue();
                continue;
            }
            if (BOX.positionX.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                x = ((Literal)value).intValue();
                continue;
            }
            if (BOX.positionY.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                y = ((Literal)value).intValue();
                continue;
            }
            if (BOX.visualHeight.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                vheight = ((Literal)value).intValue();
                continue;
            }
            if (BOX.visualWidth.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                vwidth = ((Literal)value).intValue();
                continue;
            }
            if (BOX.visualX.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                vx = ((Literal)value).intValue();
                continue;
            }
            if (BOX.visualY.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                vy = ((Literal)value).intValue();
                continue;
            }
            if (BOX.htmlTagName.equals((Object)pred)) {
                box.setTagName(value.stringValue());
                continue;
            }
            if (!BOX.hasAttribute.equals((Object)pred) || !(value instanceof IRI) || (attr = this.createAttribute(this.getAttributeModel(), (IRI)value)) == null) continue;
            box.setAttribute(attr.getKey(), attr.getValue());
        }
        box.setBounds(new Rectangular(x, y, x + width - 1, y + height - 1));
        box.setContentBounds(new Rectangular(x, y, x + width - 1, y + height - 1));
        box.setVisualBounds(new Rectangular(vx, vy, vx + vwidth - 1, vy + vheight - 1));
        return box;
    }

    private Model getBorderModel() throws RepositoryException {
        if (this.borderModel == null) {
            this.borderModel = this.storage.getBorderModelForPage(this.pageIri);
        }
        return this.borderModel;
    }

    private Model getAttributeModel() throws RepositoryException {
        if (this.attributeModel == null) {
            this.attributeModel = this.storage.getAttributeModelForPage(this.pageIri);
        }
        return this.attributeModel;
    }
}

