/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.awt.Color;
import java.util.AbstractMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.fit.layout.model.Border;
import org.fit.layout.storage.ontology.BOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelLoader {
    private static Logger log = LoggerFactory.getLogger(ModelLoader.class);

    protected Border createBorder(Model model, IRI uri) {
        Border ret = new Border();
        for (Statement st : model.filter((Resource)uri, null, null, new Resource[0])) {
            IRI pred = st.getPredicate();
            Value value = st.getObject();
            if (BOX.borderColor.equals((Object)pred)) {
                ret.setColor(this.hex2Rgb(value.stringValue()));
                continue;
            }
            if (BOX.borderWidth.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                ret.setWidth(((Literal)value).intValue());
                continue;
            }
            if (!BOX.borderStyle.equals((Object)pred)) continue;
            String style = value.stringValue();
            try {
                ret.setStyle(Border.Style.valueOf((String)style));
            }
            catch (IllegalArgumentException r) {
                log.error("Invalid style value: {}", (Object)style);
            }
        }
        return ret;
    }

    protected Map.Entry<String, String> createAttribute(Model model, IRI uri) {
        String name = null;
        String avalue = null;
        for (Statement st : model.filter((Resource)uri, null, null, new Resource[0])) {
            IRI pred = st.getPredicate();
            Value value = st.getObject();
            if (RDFS.LABEL.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                name = ((Literal)value).stringValue();
                continue;
            }
            if (!RDF.VALUE.equals((Object)pred) || !(value instanceof Literal)) continue;
            avalue = ((Literal)value).stringValue();
        }
        if (name != null && avalue != null) {
            return new AbstractMap.SimpleEntry<Object, Object>(name, avalue);
        }
        return null;
    }

    protected Color hex2Rgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }
}

