/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.util.Date;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.fit.layout.storage.ontology.BOX;

public class PageInfo {
    private Date date;
    private IRI id;
    private String url;
    private String title;

    public PageInfo(Model model) {
        for (Statement st : model) {
            if (!(st.getSubject() instanceof IRI)) continue;
            this.id = (IRI)st.getSubject();
            if (st.getPredicate().equals((Object)BOX.sourceUrl)) {
                this.url = st.getObject().stringValue();
                continue;
            }
            if (st.getPredicate().equals((Object)BOX.launchDatetime)) {
                Value val = st.getObject();
                if (!(val instanceof Literal)) continue;
                this.date = ((Literal)val).calendarValue().toGregorianCalendar().getTime();
                continue;
            }
            if (!st.getPredicate().equals((Object)BOX.hasTitle)) continue;
            this.title = st.getObject().stringValue();
        }
    }

    public IRI getId() {
        return this.id;
    }

    public Date getDate() {
        return this.date;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }
}

