/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.fit.layout.api.Parameter;
import org.fit.layout.impl.BaseBoxTreeProvider;
import org.fit.layout.impl.ParameterString;
import org.fit.layout.model.Page;
import org.fit.layout.storage.RDFStorage;
import org.fit.layout.storage.ontology.RESOURCE;

public class RDFBoxTreeProvider
extends BaseBoxTreeProvider {
    private URL urlDb;
    private IRI pageId;

    public RDFBoxTreeProvider() throws MalformedURLException {
        this.urlDb = new URL("http://localhost:8080/rdf4j-server/repositories/user");
        this.pageId = RESOURCE.createPageURI(1L);
    }

    public RDFBoxTreeProvider(URL urlDb, IRI pageId) {
        this.urlDb = urlDb;
        this.pageId = pageId;
    }

    public String getId() {
        return "FitLayout.RDFSource";
    }

    public String getName() {
        return "RDF page source";
    }

    public String getDescription() {
        return "Uses the a RDF repository for obtaining the box tree.";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>();
        ret.add((Parameter)new ParameterString("urlDb"));
        ret.add((Parameter)new ParameterString("pageId"));
        return ret;
    }

    public URL getUrlDb() {
        return this.urlDb;
    }

    public void setUrlDb(URL urlDb) {
        this.urlDb = urlDb;
    }

    public void setUrlDb(String urlDb) {
        try {
            this.urlDb = new URL(urlDb);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + urlDb);
        }
    }

    public IRI getPageId() {
        return this.pageId;
    }

    public void setPageId(IRI pageId) {
        this.pageId = pageId;
    }

    public void setPageId(String pageId) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        this.pageId = vf.createIRI(pageId);
    }

    public Page getPage() {
        try {
            RDFStorage storage = new RDFStorage(this.urlDb.toString());
            return storage.loadPage(this.pageId);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }
}

