/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sparql.SPARQLRepository;

public class RDFConnector {
    protected String endpointUrl;
    protected RepositoryConnection connection;
    protected Repository repo;
    protected ValueFactory vf;

    public RDFConnector(String endpoint) throws RepositoryException {
        this.endpointUrl = endpoint;
        this.connection = null;
        this.vf = SimpleValueFactory.getInstance();
        this.initRepository();
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        if (this.connection == null) {
            this.connection = this.repo.getConnection();
        }
        return this.connection;
    }

    public void closeConnection() throws RepositoryException {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    protected void initRepository() throws RepositoryException {
        this.repo = new SPARQLRepository(this.endpointUrl);
        this.repo.initialize();
    }

    public void add(Resource s, IRI p, Value o) {
        try {
            Statement stmt = this.vf.createStatement(s, p, o);
            this.connection.add(stmt, new Resource[0]);
            this.connection.commit();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public TupleQueryResult executeQuery(String queryString) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try {
            TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
            TupleQueryResult tqr = query.evaluate();
            return tqr;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void addNamespace(String newNamespace) {
    }

    public void removeNamespace(String namespace) throws RepositoryException {
        this.repo.getConnection().removeNamespace(namespace);
    }

    public RepositoryResult<Namespace> getAllNamespaces() throws RepositoryException {
        return this.repo.getConnection().getNamespaces();
    }
}

