/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.fit.layout.api.PageSet;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.storage.AreaModelBuilder;
import org.fit.layout.storage.AreaModelLoader;
import org.fit.layout.storage.BoxModelBuilder;
import org.fit.layout.storage.BoxModelLoader;
import org.fit.layout.storage.RDFConnector;
import org.fit.layout.storage.RDFConnectorBlazegraph;
import org.fit.layout.storage.RDFConnectorSesame;
import org.fit.layout.storage.model.RDFAreaTree;
import org.fit.layout.storage.model.RDFPage;
import org.fit.layout.storage.model.RDFPageSet;
import org.fit.layout.storage.ontology.BOX;
import org.fit.layout.storage.ontology.LAYOUT;
import org.fit.layout.storage.ontology.RESOURCE;
import org.fit.layout.storage.ontology.SEGM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFStorage {
    private static Logger log = LoggerFactory.getLogger(RDFStorage.class);
    private static final String PREFIXES = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>";
    private RDFConnector db;

    public RDFStorage(String url) throws RepositoryException {
        if (url.startsWith("sesame:")) {
            this.db = new RDFConnectorSesame(url.substring(7));
        } else if (url.startsWith("blazegraph:")) {
            this.db = new RDFConnectorBlazegraph(url.substring(11));
        } else {
            log.warn("RDFStorage: no provider specified, using generic SPARQL endpoint: {}", (Object)url);
            this.db = new RDFConnector(url);
        }
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        return this.db.getConnection();
    }

    public void closeConnection() throws RepositoryException {
        this.db.closeConnection();
    }

    public void createPageSet(String name) throws RepositoryException {
        LinkedHashModel graph = new LinkedHashModel();
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI uri = RESOURCE.createPageSetURI(name);
        graph.add((Resource)uri, RDF.TYPE, (Value)LAYOUT.PageSet, new Resource[0]);
        graph.add((Resource)uri, LAYOUT.hasName, (Value)vf.createLiteral(name), new Resource[0]);
        graph.add((Resource)uri, LAYOUT.createdOn, (Value)vf.createLiteral(new Date()), new Resource[0]);
        this.insertGraph((Model)graph);
    }

    public void deletePageSet(String name) throws RepositoryException {
        IRI uri = RESOURCE.createPageSetURI(name);
        this.getConnection().remove((Resource)uri, null, null, new Resource[0]);
        this.closeConnection();
    }

    public PageSet getPageSet(String name) throws RepositoryException {
        return this.getPageSet(RESOURCE.createPageSetURI(name));
    }

    public PageSet getPageSet(IRI uri) throws RepositoryException {
        RepositoryResult result = this.getConnection().getStatements((Resource)uri, null, null, false, new Resource[0]);
        RDFPageSet ret = new RDFPageSet(null, uri, this);
        while (result.hasNext()) {
            Value val;
            Statement st = (Statement)result.next();
            if (LAYOUT.hasName.equals((Object)st.getPredicate())) {
                ret.setName(st.getObject().stringValue());
                continue;
            }
            if (!LAYOUT.createdOn.equals((Object)st.getPredicate()) || !((val = st.getObject()) instanceof Literal)) continue;
            Date date = ((Literal)val).calendarValue().toGregorianCalendar().getTime();
            ret.setDateCreated(date);
        }
        result.close();
        this.closeConnection();
        if (ret.getName() == null) {
            return null;
        }
        return ret;
    }

    public List<IRI> getPagesForPageSet(IRI pageSetUri) throws RepositoryException {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>SELECT ?uri WHERE {  <" + pageSetUri.toString() + "> layout:containsPage ?uri .   ?uri rdf:type box:Page }";
        System.out.println("QUERY: " + query);
        TupleQueryResult data = this.executeSafeTupleQuery(query);
        ArrayList<IRI> ret = new ArrayList<IRI>();
        try {
            while (data.hasNext()) {
                BindingSet binding = (BindingSet)data.next();
                Binding b = binding.getBinding("uri");
                ret.add((IRI)b.getValue());
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public List<PageSet> getPageSets() throws RepositoryException {
        ArrayList<PageSet> ret = new ArrayList<PageSet>();
        RepositoryResult result = this.getConnection().getStatements(null, RDF.TYPE, (Value)LAYOUT.PageSet, false, new Resource[0]);
        while (result.hasNext()) {
            PageSet newset;
            Statement st = (Statement)result.next();
            if (!(st.getSubject() instanceof IRI) || (newset = this.getPageSet((IRI)st.getSubject())) == null) continue;
            ret.add(newset);
        }
        result.close();
        this.closeConnection();
        return ret;
    }

    public void addPageToPageSet(IRI pageUri, String psetName) throws RepositoryException {
        IRI psetUri = RESOURCE.createPageSetURI(psetName);
        this.getConnection().add((Resource)psetUri, LAYOUT.containsPage, (Value)pageUri, new Resource[0]);
        this.closeConnection();
    }

    public Set<IRI> getOrphanedPages() throws RepositoryException {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>SELECT ?pg WHERE {  ?pg rdf:type box:Page   OPTIONAL { ?set layout:containsPage ?pg }   FILTER ( !BOUND(?set) ) }";
        System.out.println("QUERY: PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>SELECT ?pg WHERE {  ?pg rdf:type box:Page   OPTIONAL { ?set layout:containsPage ?pg }   FILTER ( !BOUND(?set) ) }");
        TupleQueryResult data = this.executeSafeTupleQuery("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>SELECT ?pg WHERE {  ?pg rdf:type box:Page   OPTIONAL { ?set layout:containsPage ?pg }   FILTER ( !BOUND(?set) ) }");
        HashSet<IRI> ret = new HashSet<IRI>();
        try {
            while (data.hasNext()) {
                BindingSet binding = (BindingSet)data.next();
                Binding b = binding.getBinding("pg");
                ret.add((IRI)b.getValue());
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void removeOrphanedPages() throws RepositoryException {
        Set<IRI> pages = this.getOrphanedPages();
        for (IRI page : pages) {
            this.removePage(page);
        }
    }

    public TupleQueryResult getAvailableTrees(String psetName) throws RepositoryException {
        String contClause = "";
        if (psetName != null) {
            IRI pageSetUri = RESOURCE.createPageSetURI(psetName);
            contClause = " . <" + pageSetUri.toString() + "> layout:containsPage ?page";
        }
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#> SELECT ?page ?tree ?date ?url ?title WHERE {?tree segm:sourcePage ?page . ?page box:launchDatetime ?date . ?page box:hasTitle ?title . ?page box:sourceUrl ?url" + contClause + "} ORDER BY ?date ?page ?tree";
        System.out.println("QUERY: " + query);
        return this.executeSafeTupleQuery(query);
    }

    public Set<String> getDistinctPageUrls() throws RepositoryException {
        HashSet<String> output = new HashSet<String>();
        RepositoryResult result = this.getConnection().getStatements(null, BOX.sourceUrl, null, true, new Resource[0]);
        while (result.hasNext()) {
            Statement bindingSet = (Statement)result.next();
            String url = bindingSet.getObject().stringValue();
            output.add(url);
        }
        result.close();
        this.closeConnection();
        return output;
    }

    public Set<IRI> getAllPageIds() throws RepositoryException {
        RepositoryResult result = this.getConnection().getStatements(null, RDF.TYPE, (Value)BOX.Page, true, new Resource[0]);
        Set<IRI> ret = this.getSubjectsFromResult((RepositoryResult<Statement>)result);
        result.close();
        this.closeConnection();
        return ret;
    }

    public Set<IRI> getPageIdsForUrl(String url) throws RepositoryException {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        RepositoryResult result = this.getConnection().getStatements(null, BOX.sourceUrl, (Value)vf.createLiteral(url), true, new Resource[0]);
        Set<IRI> ret = this.getSubjectsFromResult((RepositoryResult<Statement>)result);
        result.close();
        this.closeConnection();
        return ret;
    }

    public RDFPage insertPageBoxModel(Page page) throws RepositoryException {
        long seq = this.getNextSequenceValue("page");
        IRI pageUri = RESOURCE.createPageURI(seq);
        BoxModelBuilder pgb = new BoxModelBuilder(page, pageUri);
        this.insertGraph(pgb.getGraph());
        if (page instanceof RDFPage) {
            return (RDFPage)page;
        }
        return new RDFPage(page, pageUri);
    }

    public RDFPage updatePageBoxModel(RDFPage page) throws RepositoryException {
        this.removePage(page.getIri());
        BoxModelBuilder pgb = new BoxModelBuilder((Page)page, page.getIri());
        this.insertGraph(pgb.getGraph());
        return page;
    }

    public void removePage(IRI pageUri) throws RepositoryException {
        this.removeAreaTreesForPage(pageUri);
        this.removePageModel(pageUri);
        this.removePageInfo(pageUri);
    }

    public RDFPage loadPage(IRI pageId) throws RepositoryException {
        BoxModelLoader loader = new BoxModelLoader(this, pageId);
        return loader.getPage();
    }

    public Model getBoxModelForPage(IRI pageId) throws RepositoryException {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?s rdf:type box:Box . ?s box:documentOrder ?ord . ?s box:belongsTo <" + pageId.toString() + ">} ORDER BY ?ord";
        return this.executeSafeQuery(query);
    }

    public Model getBorderModelForPage(IRI pageId) throws RepositoryException {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?b rdf:type box:Box . ?b box:belongsTo <" + pageId.toString() + "> . {?b box:hasTopBorder ?s} UNION {?b box:hasRightBorder ?s} UNION {?b box:hasBottomBorder ?s} UNION {?b box:hasLeftBorder ?s}}";
        return this.executeSafeQuery(query);
    }

    public Model getAttributeModelForPage(IRI pageId) throws RepositoryException {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?b rdf:type box:Box . ?b box:belongsTo <" + pageId.toString() + "> . ?b box:hasAttribute ?s}";
        return this.executeSafeQuery(query);
    }

    public Model getPageInfo(IRI pageUri) throws RepositoryException {
        RepositoryResult result = null;
        result = this.getConnection().getStatements((Resource)pageUri, null, null, true, new Resource[0]);
        Model ret = this.createModel((RepositoryResult<Statement>)result);
        result.close();
        this.closeConnection();
        return ret;
    }

    public AreaModelLoader loadAreaTrees(IRI areaTreeId, RDFPage srcPage) throws RepositoryException {
        return new AreaModelLoader(this, areaTreeId, srcPage);
    }

    public IRI getSourcePageForAreaTree(IRI areaTreeUri) throws RepositoryException {
        IRI ret = null;
        RepositoryResult result = this.getConnection().getStatements((Resource)areaTreeUri, SEGM.sourcePage, null, true, new Resource[0]);
        while (result.hasNext()) {
            Value val = ((Statement)result.next()).getObject();
            if (!(val instanceof IRI)) continue;
            ret = (IRI)val;
            break;
        }
        result.close();
        this.closeConnection();
        return ret;
    }

    public Model getAreaModelForAreaTree(IRI areaTreeUri) throws RepositoryException {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?s rdf:type segm:Area . ?s box:documentOrder ?ord . ?s segm:belongsTo <" + areaTreeUri.stringValue() + "> } ORDER BY ?ord";
        return this.executeSafeQuery(query);
    }

    public Model getLogicalAreaModelForAreaTree(IRI areaTreeUri) throws RepositoryException {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?s rdf:type segm:LogicalArea . ?s box:documentOrder ?ord . ?s segm:belongsTo <" + areaTreeUri.stringValue() + "> } ORDER BY ?ord";
        return this.executeSafeQuery(query);
    }

    public Model getBorderModelForAreaTree(IRI areaTreeUri) throws RepositoryException {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?b rdf:type segm:Area . ?b segm:belongsTo <" + areaTreeUri.toString() + "> . {?b box:hasTopBorder ?s} UNION {?b box:hasRightBorder ?s} UNION {?b box:hasBottomBorder ?s} UNION {?b box:hasLeftBorder ?s}}";
        return this.executeSafeQuery(query);
    }

    public Model getTagModelForAreaTree(IRI areaTreeUri) throws RepositoryException {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . {?a rdf:type segm:Area} UNION {?a rdf:type segm:LogicalArea} . ?a segm:hasTag ?s . ?a segm:belongsTo <" + areaTreeUri.stringValue() + "> }";
        return this.executeSafeQuery(query);
    }

    public Model getTagSupportModelForAreaTree(IRI areaTreeUri) throws RepositoryException {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> PREFIX layout: <http://fitlayout.github.io/ontology/fitlayout.owl#>CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?a rdf:type segm:Area . ?a segm:tagSupport ?s . ?a segm:belongsTo <" + areaTreeUri.stringValue() + "> }";
        return this.executeSafeQuery(query);
    }

    public Set<IRI> getAreaTreeIdsForPageId(IRI pageUri) throws RepositoryException {
        RepositoryResult result = this.getConnection().getStatements(null, SEGM.sourcePage, (Value)pageUri, true, new Resource[0]);
        Set<IRI> ret = this.getSubjectsFromResult((RepositoryResult<Statement>)result);
        result.close();
        this.closeConnection();
        return ret;
    }

    public RDFAreaTree insertAreaTree(AreaTree atree, LogicalAreaTree ltree, IRI pageUri) throws RepositoryException {
        long seq = this.getNextSequenceValue("areatree");
        IRI targetUri = RESOURCE.createAreaTreeURI(seq);
        return this.insertAreaTree(targetUri, atree, ltree, pageUri);
    }

    public RDFAreaTree insertAreaTree(IRI targetUri, AreaTree atree, LogicalAreaTree ltree, IRI pageUri) throws RepositoryException {
        AreaModelBuilder pgb = new AreaModelBuilder(atree, ltree, pageUri, targetUri);
        this.insertGraph(pgb.getGraph());
        if (atree instanceof RDFAreaTree) {
            return (RDFAreaTree)atree;
        }
        return new RDFAreaTree(atree, targetUri);
    }

    public void removeAreaTree(IRI areaTreeUri) throws RepositoryException {
        Model mat = this.getAreaModelForAreaTree(areaTreeUri);
        mat.addAll((Collection)this.getLogicalAreaModelForAreaTree(areaTreeUri));
        mat.addAll((Collection)this.getBorderModelForAreaTree(areaTreeUri));
        mat.addAll((Collection)this.getTagSupportModelForAreaTree(areaTreeUri));
        RepositoryResult result = this.getConnection().getStatements((Resource)areaTreeUri, null, null, false, new Resource[0]);
        while (result.hasNext()) {
            mat.add(result.next());
        }
        this.getConnection().remove((Iterable)mat, new Resource[0]);
        this.closeConnection();
    }

    public RepositoryResult<Statement> getSubjectStatements(Resource subject) throws RepositoryException {
        return this.getConnection().getStatements(subject, null, null, true, new Resource[0]);
    }

    public Value getPropertyValue(Resource subject, IRI predicate) throws RepositoryException {
        RepositoryResult result = this.getConnection().getStatements(subject, predicate, null, true, new Resource[0]);
        if (result.hasNext()) {
            return ((Statement)result.next()).getObject();
        }
        return null;
    }

    public Model getSubjectModel(Resource subject) throws RepositoryException {
        RepositoryResult<Statement> result = this.getSubjectStatements(subject);
        Model ret = this.createModel(result);
        result.close();
        this.closeConnection();
        return ret;
    }

    public TupleQueryResult executeQuery(String query) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        TupleQuery tq = this.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, query);
        return tq.evaluate();
    }

    public void clearRDFDatabase() {
        try {
            Update upd = this.getConnection().prepareUpdate(QueryLanguage.SPARQL, "DELETE WHERE { ?s ?p ?o }");
            upd.execute();
            this.closeConnection();
        }
        catch (MalformedQueryException | UpdateExecutionException | RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void execSparqlUpdate(String query) throws RepositoryException, MalformedQueryException, UpdateExecutionException {
        Update upd = this.getConnection().prepareUpdate(QueryLanguage.SPARQL, query);
        upd.execute();
        this.closeConnection();
    }

    public void importTurtle(String query) throws RDFParseException, RepositoryException, IOException {
        this.getConnection().add((Reader)new StringReader(query), null, RDFFormat.TURTLE, new Resource[0]);
        this.closeConnection();
    }

    public long getLastSequenceValue(String name) throws RepositoryException {
        IRI sequence = RESOURCE.createSequenceURI(name);
        RepositoryResult result = this.getConnection().getStatements((Resource)sequence, RDF.VALUE, null, false, new Resource[0]);
        if (result.hasNext()) {
            Value val = ((Statement)result.next()).getObject();
            result.close();
            this.closeConnection();
            if (val instanceof Literal) {
                return ((Literal)val).longValue();
            }
            return 0L;
        }
        result.close();
        this.closeConnection();
        return 0L;
    }

    public long getNextSequenceValue(String name) throws RepositoryException {
        this.getConnection().begin();
        IRI sequence = RESOURCE.createSequenceURI(name);
        RepositoryResult result = this.getConnection().getStatements((Resource)sequence, RDF.VALUE, null, false, new Resource[0]);
        long val = 0L;
        if (result.hasNext()) {
            Statement statement = (Statement)result.next();
            Value vval = statement.getObject();
            if (vval instanceof Literal) {
                val = ((Literal)vval).longValue();
            }
            this.getConnection().remove(statement, new Resource[0]);
        }
        result.close();
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        this.getConnection().add((Resource)sequence, RDF.VALUE, (Value)vf.createLiteral(++val), new Resource[0]);
        this.getConnection().commit();
        this.closeConnection();
        return val;
    }

    private void removePageModel(IRI pageUri) throws RepositoryException {
        Model mat = this.getBoxModelForPage(pageUri);
        mat.addAll((Collection)this.getBorderModelForPage(pageUri));
        this.getConnection().remove((Iterable)mat, new Resource[0]);
        this.closeConnection();
    }

    private void removeAreaTreesForPage(IRI pageUri) throws RepositoryException {
        Set<IRI> areaTreeModels = this.getAreaTreeIdsForPageId(pageUri);
        for (IRI areaTreeId : areaTreeModels) {
            this.removeAreaTree(areaTreeId);
        }
    }

    private void removePageInfo(IRI pageUri) throws RepositoryException {
        Model m = this.getPageInfo(pageUri);
        this.getConnection().remove((Iterable)m, new Resource[0]);
        this.closeConnection();
    }

    private Model executeSafeQuery(String query) throws RepositoryException {
        try {
            GraphQuery pgq = this.getConnection().prepareGraphQuery(QueryLanguage.SPARQL, query);
            GraphQueryResult gqr = pgq.evaluate();
            Model ret = this.createModel(gqr);
            gqr.close();
            this.closeConnection();
            return ret;
        }
        catch (MalformedQueryException e) {
            e.printStackTrace();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
        return new LinkedHashModel();
    }

    private TupleQueryResult executeSafeTupleQuery(String query) throws RepositoryException {
        try {
            TupleQuery pgq = this.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, query);
            TupleQueryResult gqr = pgq.evaluate();
            return gqr;
        }
        catch (MalformedQueryException e) {
            e.printStackTrace();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Model createModel(RepositoryResult<Statement> result) throws RepositoryException {
        LinkedHashModel model = new LinkedHashModel();
        while (result.hasNext()) {
            model.add(result.next());
        }
        return model;
    }

    private Model createModel(GraphQueryResult result) throws QueryEvaluationException {
        LinkedHashModel model = new LinkedHashModel();
        while (result.hasNext()) {
            model.add(result.next());
        }
        return model;
    }

    public Set<IRI> getSubjectsFromResult(RepositoryResult<Statement> result) throws RepositoryException {
        HashSet<IRI> output = new HashSet<IRI>();
        while (result.hasNext()) {
            Resource uri = ((Statement)result.next()).getSubject();
            if (!(uri instanceof IRI)) continue;
            output.add((IRI)uri);
        }
        return output;
    }

    private void insertGraph(Model graph) throws RepositoryException {
        this.getConnection().begin();
        this.getConnection().add((Iterable)graph, new Resource[0]);
        this.getConnection().commit();
        this.closeConnection();
    }
}

