/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.fit.layout.api.PageSet;
import org.fit.layout.api.ScriptObject;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.storage.AreaModelLoader;
import org.fit.layout.storage.RDFStorage;
import org.fit.layout.storage.gui.StoragePlugin;
import org.fit.layout.storage.model.RDFPage;

public class ScriptApi
implements ScriptObject {
    private BufferedReader rin;
    private PrintWriter wout;
    private PrintWriter werr;
    private RDFStorage bdi;
    private StoragePlugin plugin = null;

    public void setPlugin(StoragePlugin plugin) {
        this.plugin = plugin;
    }

    public String getVarName() {
        return "storage";
    }

    public void setIO(Reader in, Writer out, Writer err) {
        this.rin = new BufferedReader(in);
        this.wout = new PrintWriter(out);
        this.werr = new PrintWriter(err);
    }

    public void connect(String uri) {
        try {
            this.bdi = new RDFStorage(uri);
            if (this.plugin != null) {
                this.plugin.setStorage(this.bdi);
            }
        }
        catch (RepositoryException e) {
            this.werr.println("Couldn't connect: " + e.getMessage());
        }
    }

    public boolean isConnected() {
        return this.bdi != null;
    }

    public void close() {
        try {
            this.bdi.closeConnection();
            this.bdi = null;
            if (this.plugin != null) {
                this.plugin.closeStorage();
            }
        }
        catch (RepositoryException e) {
            this.werr.println("Error: " + e.getMessage());
        }
    }

    public void createPageSet(String name) {
        try {
            this.bdi.createPageSet(name);
            if (this.plugin != null) {
                this.plugin.updateStorageState();
            }
        }
        catch (RepositoryException e) {
            this.werr.println("Error: " + e.getMessage());
        }
    }

    public void removePageSet(String name) {
        try {
            this.bdi.deletePageSet(name);
            if (this.plugin != null) {
                this.plugin.updateStorageState();
            }
        }
        catch (RepositoryException e) {
            this.werr.println("Error: " + e.getMessage());
        }
    }

    public void removeOrphanedPages() {
        try {
            this.bdi.removeOrphanedPages();
            if (this.plugin != null) {
                this.plugin.updateStorageState();
            }
        }
        catch (RepositoryException e) {
            this.werr.println("Error: " + e.getMessage());
        }
    }

    public PageSet getPageSet(String name) {
        try {
            return this.bdi.getPageSet(name);
        }
        catch (RepositoryException e) {
            this.werr.println("Error: " + e.getMessage());
            return null;
        }
    }

    public void addPageToPageSet(Page page, String name) {
        try {
            if (page instanceof RDFPage) {
                this.bdi.addPageToPageSet(((RDFPage)page).getIri(), name);
                if (this.plugin != null) {
                    this.plugin.updateStorageState();
                }
            } else {
                this.werr.println("Error: The saved instance of the page is required.");
            }
        }
        catch (RepositoryException e) {
            this.werr.println("Error: " + e.getMessage());
        }
    }

    public RDFPage insertPage(Page page) {
        if (page != null) {
            try {
                RDFPage ret = this.bdi.insertPageBoxModel(page);
                if (this.plugin != null) {
                    this.plugin.updateStorageState();
                }
                return ret;
            }
            catch (RepositoryException e) {
                this.werr.println("Couldn't save the box tree: " + e.getMessage());
            }
        }
        return null;
    }

    public RDFPage updatePage(Page page) {
        if (page != null && page instanceof RDFPage) {
            try {
                return this.bdi.updatePageBoxModel((RDFPage)page);
            }
            catch (RepositoryException e) {
                this.werr.println("Couldn't save the box tree: " + e.getMessage());
            }
        }
        return null;
    }

    public void saveAreaTree(AreaTree atree, LogicalAreaTree ltree, Page sourcePage) {
        if (atree != null) {
            try {
                if (sourcePage instanceof RDFPage) {
                    this.bdi.insertAreaTree(atree, ltree, ((RDFPage)sourcePage).getIri());
                    if (this.plugin != null) {
                        this.plugin.updateStorageState();
                    }
                } else {
                    this.werr.println("Error: The saved instance of the page is required.");
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    public Page loadPage(String pageUri) {
        try {
            SimpleValueFactory vf = SimpleValueFactory.getInstance();
            IRI uri = vf.createIRI(pageUri);
            return this.bdi.loadPage(uri);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public AreaTree loadAreaTree(String treeUri, RDFPage page) {
        try {
            SimpleValueFactory vf = SimpleValueFactory.getInstance();
            IRI uri = vf.createIRI(treeUri);
            AreaModelLoader loader = this.bdi.loadAreaTrees(uri, page);
            return loader.getAreaTree();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getAreaTreeURIs(RDFPage page) {
        try {
            Set<IRI> uris = this.bdi.getAreaTreeIdsForPageId(page.getIri());
            String[] ret = new String[uris.size()];
            int i = 0;
            for (IRI uri : uris) {
                ret[i++] = uri.toString();
            }
            return ret;
        }
        catch (RepositoryException e) {
            return new String[0];
        }
    }

    public void clearDB() {
        this.bdi.clearRDFDatabase();
        if (this.plugin != null) {
            this.plugin.updateStorageState();
        }
    }

    public void execQueryFromResource(String res) {
        try {
            if (!res.startsWith("/")) {
                res = "/" + res;
            }
            Scanner scan = new Scanner(ScriptApi.class.getResourceAsStream(res));
            String query = scan.useDelimiter("\\Z").next();
            scan.close();
            this.bdi.execSparqlUpdate(query);
        }
        catch (MalformedQueryException | UpdateExecutionException | RepositoryException e) {
            this.werr.println("Couldn't execute query: " + e.getMessage());
        }
    }

    public void importTurtle(String turtle) {
        try {
            this.bdi.importTurtle(turtle);
            if (this.plugin != null) {
                this.plugin.updateStorageState();
            }
        }
        catch (IOException | RepositoryException | RDFParseException e) {
            this.werr.println("Couldn't import Turtle data: " + e.getMessage());
        }
    }

    public void importTurtleFromResource(String res) {
        if (!res.startsWith("/")) {
            res = "/" + res;
        }
        Scanner scan = new Scanner(ScriptApi.class.getResourceAsStream(res));
        String turtle = scan.useDelimiter("\\Z").next();
        scan.close();
        try {
            this.bdi.importTurtle(turtle);
            if (this.plugin != null) {
                this.plugin.updateStorageState();
            }
        }
        catch (IOException | RepositoryException | RDFParseException e) {
            this.werr.println("Couldn't import Turtle data: " + e.getMessage());
        }
    }
}

