/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.model;

import org.eclipse.rdf4j.model.IRI;
import org.fit.layout.impl.DefaultBox;
import org.fit.layout.model.Box;
import org.fit.layout.storage.model.RDFResource;

public class RDFBox
extends DefaultBox
implements RDFResource {
    protected IRI iri;
    protected int documentOrder;

    public RDFBox(IRI uri) {
        this.setIri(uri);
    }

    @Override
    public IRI getIri() {
        return this.iri;
    }

    public void setIri(IRI uri) {
        this.iri = uri;
        this.setId(Integer.parseInt(uri.getLocalName()));
    }

    public int getDocumentOrder() {
        return this.documentOrder;
    }

    public void setDocumentOrder(int documentOrder) {
        this.documentOrder = documentOrder;
    }

    public String toString() {
        String ret = this.getId() + " ";
        if (this.getType() == Box.Type.TEXT_CONTENT) {
            ret = ret + this.getText();
        } else if (this.getType() == Box.Type.REPLACED_CONTENT) {
            ret = this.getContentObject() != null ? ret + this.getContentObject().toString() : ret + "(null object)";
        } else {
            ret = ret + "<" + this.getTagName();
            if (this.getAttribute("id") != null) {
                ret = ret + " id=" + this.getAttribute("id");
            }
            if (this.getAttribute("class") != null) {
                ret = ret + " class=" + this.getAttribute("class");
            }
            ret = ret + ">";
        }
        return ret;
    }
}

