/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.fit.layout.impl.AbstractPageSet;
import org.fit.layout.model.Page;
import org.fit.layout.storage.RDFStorage;
import org.fit.layout.storage.model.RDFPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFPageSet
extends AbstractPageSet {
    private static Logger log = LoggerFactory.getLogger(RDFPageSet.class);
    private RDFStorage storage;
    private IRI iri;

    public RDFPageSet(String name, IRI iri, RDFStorage storage) {
        super(name);
        this.iri = iri;
        this.storage = storage;
    }

    public int size() {
        try {
            return this.storage.getPagesForPageSet(this.iri).size();
        }
        catch (RepositoryException e) {
            log.error("Error: " + e.getMessage());
            return 0;
        }
    }

    public Page get(int index) throws IndexOutOfBoundsException {
        try {
            List<IRI> uris = this.storage.getPagesForPageSet(this.iri);
            if (index < uris.size()) {
                return this.storage.loadPage(uris.get(index));
            }
            throw new IndexOutOfBoundsException("Page index out of bounds: " + index + " >= " + uris.size());
        }
        catch (RepositoryException e) {
            log.error("Error: " + e.getMessage());
            return null;
        }
    }

    public void addPage(Page page) {
        try {
            if (page instanceof RDFPage) {
                this.storage.addPageToPageSet(((RDFPage)page).getIri(), this.getName());
            } else {
                log.error("addPage: The saved instance of the page is required.");
            }
        }
        catch (RepositoryException e) {
            log.error("Error: " + e.getMessage());
        }
    }

    public Iterator<Page> iterator() {
        try {
            return new PageIterator(this.storage, this.storage.getPagesForPageSet(this.iri));
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }

    public IRI[] getAreaTreeIRIs() {
        try {
            ArrayList<IRI> list = new ArrayList<IRI>();
            TupleQueryResult data = this.storage.getAvailableTrees(this.getName());
            while (data.hasNext()) {
                BindingSet tuple = (BindingSet)data.next();
                if (!(tuple.getBinding("tree").getValue() instanceof IRI)) continue;
                list.add((IRI)tuple.getBinding("tree").getValue());
            }
            IRI[] ret = new IRI[list.size()];
            return list.toArray(ret);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public class PageIterator
    implements Iterator<Page> {
        private RDFStorage storage;
        private List<IRI> pageUris;
        private int currentIndex;

        public PageIterator(RDFStorage storage, List<IRI> pageIris) {
            this.storage = storage;
            this.pageUris = pageIris;
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.pageUris.size();
        }

        @Override
        public Page next() {
            if (this.currentIndex < this.pageUris.size()) {
                try {
                    return this.storage.loadPage(this.pageUris.get(this.currentIndex++));
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

