/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.anotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.fit.layout.anotator.AnotatorAreaListener;
import org.fit.layout.anotator.AnotatorTag;
import org.fit.layout.gui.AreaSelectionListener;
import org.fit.layout.gui.Browser;
import org.fit.layout.gui.BrowserPlugin;
import org.fit.layout.impl.DefaultArea;
import org.fit.layout.model.Area;
import org.fit.layout.model.Tag;

public class AnotatorPlugin
implements BrowserPlugin {
    Browser browser;
    private JPanel pnl_mainPanel;
    private JPanel pnl_selection;
    private JComboBox<String> cbx_tagSelector;
    private JPanel pnl_control;
    private JButton btn_toogleEnableAnotation;
    private JButton btn_clearAnotation;
    private AnotatorAreaListener listener;
    private JScrollPane scrl_tagTable;
    private JTable tagTable;
    private DefaultTableModel tagModelTable;
    private Boolean enableAnotation = false;
    private String[] tags = new String[]{"h1", "h2", "h3", "perex", "paragraph", "title", "date", "person"};

    public boolean init(Browser browser) {
        this.browser = browser;
        this.browser.addStructurePanel("Anotator", (JComponent)this.getPnl_mainPanel());
        this.browser.addAreaSelectionListener(this.getListener_areaSelection());
        return true;
    }

    private AreaSelectionListener getListener_areaSelection() {
        if (this.listener == null) {
            this.listener = new AnotatorAreaListener(){

                @Override
                public void areaSelected(Area area) {
                    super.areaSelected(area);
                    if (!AnotatorPlugin.this.enableAnotation.booleanValue()) {
                        return;
                    }
                    String actualTag = AnotatorPlugin.this.getCbx_tagSelection().getSelectedItem().toString();
                    AnotatorTag aTag = new AnotatorTag(actualTag);
                    if (area.hasTag((Tag)aTag)) {
                        AnotatorPlugin.this.removeTag((DefaultArea)area, aTag);
                    } else {
                        AnotatorPlugin.this.addTag(area, (Tag)aTag);
                    }
                }
            };
        }
        return this.listener;
    }

    private JPanel getPnl_mainPanel() {
        if (this.pnl_mainPanel == null) {
            this.pnl_mainPanel = new JPanel();
            GridBagLayout gbl_pathsPanel = new GridBagLayout();
            gbl_pathsPanel.columnWidths = new int[]{0, 0};
            gbl_pathsPanel.rowHeights = new int[]{0, 0, 0};
            gbl_pathsPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_pathsPanel.rowWeights = new double[]{0.05, 0.05, 1.0, Double.MIN_VALUE};
            this.pnl_mainPanel.setLayout(gbl_pathsPanel);
            GridBagConstraints gbc_selection = new GridBagConstraints();
            gbc_selection.insets = new Insets(0, 0, 5, 0);
            gbc_selection.fill = 1;
            gbc_selection.gridx = 0;
            gbc_selection.gridy = 0;
            this.pnl_mainPanel.add((Component)this.getPnl_selection(), gbc_selection);
            GridBagConstraints gbc_control = new GridBagConstraints();
            gbc_control.fill = 2;
            gbc_control.gridx = 0;
            gbc_control.gridy = 1;
            this.pnl_mainPanel.add((Component)this.getPnl_control(), gbc_control);
            GridBagConstraints gbc_extractionScroll = new GridBagConstraints();
            gbc_extractionScroll.fill = 1;
            gbc_extractionScroll.gridx = 0;
            gbc_extractionScroll.gridy = 2;
            this.pnl_mainPanel.add((Component)this.getScrl_tagTable(), gbc_extractionScroll);
        }
        return this.pnl_mainPanel;
    }

    private JPanel getPnl_selection() {
        if (this.pnl_selection == null) {
            this.pnl_selection = new JPanel();
            this.pnl_selection.setLayout(new FlowLayout(1));
            this.pnl_selection.add(this.getCbx_tagSelection());
        }
        return this.pnl_selection;
    }

    private JComboBox<String> getCbx_tagSelection() {
        if (this.cbx_tagSelector == null) {
            this.cbx_tagSelector = new JComboBox();
            for (String tag : this.tags) {
                this.cbx_tagSelector.addItem(tag);
            }
        }
        return this.cbx_tagSelector;
    }

    private JPanel getPnl_control() {
        if (this.pnl_control == null) {
            this.pnl_control = new JPanel();
            this.pnl_control.setLayout(new FlowLayout(1));
            this.pnl_control.add(this.getBtn_toogleEnableAnotation());
            this.pnl_control.add(this.getBtn_clearAnotation());
        }
        return this.pnl_control;
    }

    private JButton getBtn_toogleEnableAnotation() {
        if (this.btn_toogleEnableAnotation == null) {
            this.enableAnotation = false;
            this.btn_toogleEnableAnotation = new JButton("Enable anotation");
            this.btn_toogleEnableAnotation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!AnotatorPlugin.this.enableAnotation.booleanValue()) {
                        AnotatorPlugin.this.enableAnotation = true;
                        AnotatorPlugin.this.btn_toogleEnableAnotation.setText("Disable anotation");
                        AnotatorPlugin.this.tagTable.setBackground(Color.white);
                    } else {
                        AnotatorPlugin.this.enableAnotation = false;
                        AnotatorPlugin.this.btn_toogleEnableAnotation.setText("Enable anotation");
                        AnotatorPlugin.this.tagTable.setBackground(Color.lightGray);
                    }
                }
            });
        }
        return this.btn_toogleEnableAnotation;
    }

    private JButton getBtn_clearAnotation() {
        if (this.btn_clearAnotation == null) {
            this.btn_clearAnotation = new JButton("Clear");
            this.btn_clearAnotation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    for (int i = AnotatorPlugin.this.tagModelTable.getRowCount(); i > 0; --i) {
                        String tag = (String)AnotatorPlugin.this.tagModelTable.getValueAt(i - 1, 0);
                        DefaultArea area = (DefaultArea)AnotatorPlugin.this.tagModelTable.getValueAt(i - 1, 1);
                        AnotatorPlugin.this.removeTag(area, new AnotatorTag(tag));
                    }
                }
            });
        }
        return this.btn_clearAnotation;
    }

    private JScrollPane getScrl_tagTable() {
        if (this.scrl_tagTable == null) {
            this.scrl_tagTable = new JScrollPane();
            this.scrl_tagTable.setViewportView(this.getTbl_classificationTags());
        }
        return this.scrl_tagTable;
    }

    private JTable getTbl_classificationTags() {
        if (this.tagTable == null) {
            this.tagModelTable = new DefaultTableModel();
            this.tagModelTable.addColumn("Tag");
            this.tagModelTable.addColumn("Content");
            this.tagTable = new JTable(this.tagModelTable);
        }
        return this.tagTable;
    }

    private void addTag(Area area, Tag tag) {
        area.addTag(tag, 1.0f);
        this.tagModelTable.addRow(new Object[]{this.getCbx_tagSelection().getSelectedItem().toString(), area});
    }

    private void removeTag(DefaultArea area, AnotatorTag tag) {
        if (area.containsTag((Tag)tag)) {
            area.removeTag((Tag)tag);
        }
        for (int i = 0; i < this.tagModelTable.getRowCount(); ++i) {
            Area aa = (Area)this.tagModelTable.getValueAt(i, 1);
            String tagString = (String)this.tagModelTable.getValueAt(i, 0);
            if (!area.equals(aa) || !tag.equals((Object)new AnotatorTag(tagString))) continue;
            this.tagModelTable.removeRow(i);
        }
    }
}

