/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.LogicalArea;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Rectangular;
import org.fit.layout.model.Tag;
import org.fit.layout.storage.ontology.BOX;
import org.fit.layout.storage.ontology.SEGM;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;

public class BigdataAreaModelBuilder {
    private Graph graph = new LinkedHashModel();
    private ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
    private String url;
    private String uniqueID;
    private URI areaTreeNode;
    private int logAreaCnt;

    public BigdataAreaModelBuilder(AreaTree areaTree, LogicalAreaTree logicalTree, URI pageNode, String url) {
        this.url = url;
        this.createAreaTreeModel(pageNode, areaTree, logicalTree);
    }

    public Graph getGraph() {
        return this.graph;
    }

    private void createAreaTreeModel(URI pageNode, AreaTree areaTree, LogicalAreaTree logicalTree) {
        this.uniqueID = this.getUniqueId();
        this.areaTreeNode = this.vf.createURI(this.url + "#" + this.uniqueID);
        this.graph.add((Resource)this.areaTreeNode, RDF.TYPE, (Value)SEGM.AreaTree, new Resource[0]);
        this.graph.add((Resource)this.areaTreeNode, SEGM.sourcePage, (Value)pageNode, new Resource[0]);
        this.addArea(areaTree.getRoot());
        this.insertAllAreas(areaTree.getRoot().getChildAreas());
        if (logicalTree != null) {
            URI p = this.addLogicalArea(logicalTree.getRoot(), null);
            this.insertAllLogicalAreas(logicalTree.getRoot().getChildAreas(), p);
        }
    }

    private void insertAllAreas(List<Area> areas) {
        if (areas == null) {
            return;
        }
        for (Area area : areas) {
            this.addArea(area);
            this.insertAllAreas(area.getChildAreas());
        }
    }

    private void insertAllLogicalAreas(List<LogicalArea> areas, URI parent) {
        if (areas == null) {
            return;
        }
        for (LogicalArea area : areas) {
            URI p = this.addLogicalArea(area, parent);
            this.insertAllLogicalAreas(area.getChildAreas(), p);
        }
    }

    private void addArea(Area area) {
        URI individual = this.getAreaUri(area);
        this.graph.add((Resource)individual, RDF.TYPE, (Value)SEGM.Area, new Resource[0]);
        this.graph.add((Resource)individual, SEGM.belongsTo, (Value)this.areaTreeNode, new Resource[0]);
        if (area.getParentArea() != null) {
            this.graph.add((Resource)individual, SEGM.isChildOf, (Value)this.getAreaUri((Area)area.getParentArea()), new Resource[0]);
        }
        Rectangular rec = area.getBounds();
        this.graph.add((Resource)individual, BOX.height, (Value)this.vf.createLiteral(rec.getHeight()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.width, (Value)this.vf.createLiteral(rec.getWidth()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.positionX, (Value)this.vf.createLiteral(rec.getX1()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.positionY, (Value)this.vf.createLiteral(rec.getY1()), new Resource[0]);
        if (area.getTags().size() > 0) {
            Map tags = area.getTags();
            Set tagKeys = tags.keySet();
            for (Tag t : tagKeys) {
                Float support = (Float)tags.get(t);
                if (support == null || !(support.floatValue() > 0.0f)) continue;
                URI tagUri = this.getTagUri(t);
                this.graph.add((Resource)individual, SEGM.hasTag, (Value)tagUri, new Resource[0]);
                URI supUri = this.getTagSupportUri(area, t);
                this.graph.add((Resource)individual, SEGM.tagSupport, (Value)supUri, new Resource[0]);
                this.graph.add((Resource)supUri, SEGM.support, (Value)this.vf.createLiteral(support.floatValue()), new Resource[0]);
                this.graph.add((Resource)supUri, SEGM.hasTag, (Value)tagUri, new Resource[0]);
            }
        }
        if (area.getBackgroundColor() != null) {
            String bgcol = String.format("#%02x%02x%02x", area.getBackgroundColor().getRed(), area.getBackgroundColor().getGreen(), area.getBackgroundColor().getBlue());
            this.graph.add((Resource)individual, BOX.backgroundColor, (Value)this.vf.createLiteral(bgcol), new Resource[0]);
        }
        this.graph.add((Resource)individual, BOX.fontSize, (Value)this.vf.createLiteral(area.getFontSize()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.fontWeight, (Value)this.vf.createLiteral(area.getFontWeight()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.fontStyle, (Value)this.vf.createLiteral(area.getFontStyle()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.underline, (Value)this.vf.createLiteral(area.getUnderline()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.lineThrough, (Value)this.vf.createLiteral(area.getLineThrough()), new Resource[0]);
    }

    private URI addLogicalArea(LogicalArea area, URI parent) {
        URI individual = this.getLogicalAreaUri(this.logAreaCnt++);
        this.graph.add((Resource)individual, RDF.TYPE, (Value)SEGM.LogicalArea, new Resource[0]);
        this.graph.add((Resource)individual, SEGM.belongsTo, (Value)this.areaTreeNode, new Resource[0]);
        this.graph.add((Resource)individual, SEGM.hasText, (Value)this.vf.createLiteral(area.getText()), new Resource[0]);
        if (parent != null) {
            this.graph.add((Resource)individual, SEGM.isSubordinateTo, (Value)parent, new Resource[0]);
        }
        if (area.getMainTag() != null) {
            this.graph.add((Resource)individual, SEGM.hasTag, (Value)this.getTagUri(area.getMainTag()), new Resource[0]);
        }
        return individual;
    }

    public void addTag(Tag tag) {
        URI tagNode = this.getTagUri(tag);
        this.graph.add((Resource)tagNode, RDF.TYPE, (Value)SEGM.Tag, new Resource[0]);
        this.graph.add((Resource)tagNode, SEGM.hasType, (Value)this.vf.createLiteral(tag.getType()), new Resource[0]);
        this.graph.add((Resource)tagNode, SEGM.hasName, (Value)this.vf.createLiteral(tag.getValue()), new Resource[0]);
    }

    public URI getAreaUri(Area area) {
        return this.vf.createURI(this.url + "#" + this.uniqueID + "-" + area.getId());
    }

    public URI getLogicalAreaUri(int cnt) {
        return this.vf.createURI(this.url + "#" + this.uniqueID + "-log-" + cnt);
    }

    public URI getTagSupportUri(Area area, Tag tag) {
        return this.vf.createURI(this.url + "#" + this.uniqueID + "-" + area.getId() + "-" + this.getTagDesc(tag));
    }

    public URI getTagUri(Tag tag) {
        return this.vf.createURI("http://fitlayout.github.io/ontology/segmentation.owl#", "tag-" + this.getTagDesc(tag));
    }

    public String getTagDesc(Tag tag) {
        return tag.getType().replaceAll("\\.", "-") + "--" + tag.getValue();
    }

    private String getUniqueId() {
        String dateTime = this.getDateTime();
        dateTime = dateTime.replace(":", "");
        dateTime = dateTime.replace("-", "");
        dateTime = dateTime.replace(" ", "");
        return "at-" + dateTime;
    }

    private String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }
}

