/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.fit.layout.model.Box;
import org.fit.layout.model.Page;
import org.fit.layout.model.Rectangular;
import org.fit.layout.storage.ontology.BOX;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;

public class BigdataBoxModelBuilder {
    private Graph graph;
    private String baseUrl;
    private ValueFactoryImpl vf;
    private String launchID;
    private URI pageNode;

    public BigdataBoxModelBuilder(Page page) {
        this.baseUrl = page.getSourceURL().toString();
        this.initializeGraph();
        Box bdb = page.getRoot();
        this.insertBox(bdb);
        this.insertAllBoxes(bdb);
    }

    private URI initializeGraph() {
        this.graph = new LinkedHashModel();
        this.vf = ValueFactoryImpl.getInstance();
        String dateTime = this.getDateTime();
        this.launchID = this.getLaunchIdFromDatetime(dateTime);
        this.pageNode = this.vf.createURI(this.baseUrl + "#" + this.launchID);
        this.graph.add((Resource)this.pageNode, RDF.TYPE, (Value)BOX.Page, new Resource[0]);
        this.graph.add((Resource)this.pageNode, BOX.launchDatetime, (Value)this.vf.createLiteral(dateTime), new Resource[0]);
        this.graph.add((Resource)this.pageNode, BOX.sourceUrl, (Value)this.vf.createLiteral(this.baseUrl), new Resource[0]);
        return this.pageNode;
    }

    private String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private String getLaunchIdFromDatetime(String dateTime) {
        dateTime = dateTime.replace(":", "");
        dateTime = dateTime.replace("-", "");
        dateTime = dateTime.replace(" ", "");
        return dateTime;
    }

    private void insertAllBoxes(Box parent) {
        Box sub1;
        int i;
        for (i = 0; i < parent.getChildCount(); ++i) {
            sub1 = parent.getChildBox(i);
            this.insertBox(sub1);
        }
        for (i = 0; i < parent.getChildCount(); ++i) {
            sub1 = parent.getChildBox(i);
            this.insertAllBoxes(sub1);
        }
    }

    private void insertBox(Box box) {
        URI individual = this.getBoxUri(box);
        this.graph.add((Resource)individual, RDF.TYPE, (Value)BOX.Box, new Resource[0]);
        this.graph.add((Resource)individual, BOX.belongsTo, (Value)this.pageNode, new Resource[0]);
        if (box.getParentBox() != null) {
            this.graph.add((Resource)individual, BOX.isChildOf, (Value)this.getBoxUri(box.getParentBox()), new Resource[0]);
        }
        Rectangular rec = box.getBounds();
        this.graph.add((Resource)individual, BOX.height, (Value)this.vf.createLiteral(rec.getHeight()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.width, (Value)this.vf.createLiteral(rec.getWidth()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.positionX, (Value)this.vf.createLiteral(rec.getX1()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.positionY, (Value)this.vf.createLiteral(rec.getY1()), new Resource[0]);
        if (box.getBackgroundColor() != null) {
            String bgcol = String.format("#%02x%02x%02x", box.getBackgroundColor().getRed(), box.getBackgroundColor().getGreen(), box.getBackgroundColor().getBlue());
            this.graph.add((Resource)individual, BOX.backgroundColor, (Value)this.vf.createLiteral(bgcol), new Resource[0]);
        }
        if (box.getType() == Box.Type.TEXT_CONTENT) {
            this.graph.add((Resource)individual, BOX.hasText, (Value)this.vf.createLiteral(box.getText()), new Resource[0]);
        }
        this.graph.add((Resource)individual, BOX.fontFamily, (Value)this.vf.createLiteral(box.getFontFamily()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.fontSize, (Value)this.vf.createLiteral(box.getFontSize()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.fontWeight, (Value)this.vf.createLiteral(box.getFontWeight()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.fontStyle, (Value)this.vf.createLiteral(box.getFontStyle()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.underline, (Value)this.vf.createLiteral(box.getUnderline()), new Resource[0]);
        this.graph.add((Resource)individual, BOX.lineThrough, (Value)this.vf.createLiteral(box.getLineThrough()), new Resource[0]);
        String col = String.format("#%02x%02x%02x", box.getColor().getRed(), box.getColor().getGreen(), box.getColor().getBlue());
        this.graph.add((Resource)individual, BOX.color, (Value)this.vf.createLiteral(col), new Resource[0]);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public URI getLaunchNode() {
        return this.pageNode;
    }

    public URI getBoxUri(Box box) {
        return this.vf.createURI(this.baseUrl + "#" + this.launchID + "-" + box.getId());
    }
}

