/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import java.net.MalformedURLException;
import java.net.URL;
import org.fit.layout.api.ParametrizedOperation;
import org.fit.layout.impl.BaseBoxTreeProvider;
import org.fit.layout.model.Page;
import org.fit.layout.storage.BigdataInterface;
import org.fit.layout.storage.model.BigdataPage;
import org.openrdf.model.Model;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.RepositoryException;

public class BigdataBoxTreeProvider
extends BaseBoxTreeProvider {
    private URL urlDb;
    private URIImpl pageId;
    private final String[] paramNames = new String[]{"urlDb", "pageId"};
    private final ParametrizedOperation.ValueType[] paramTypes = new ParametrizedOperation.ValueType[]{ParametrizedOperation.ValueType.STRING, ParametrizedOperation.ValueType.STRING};

    public BigdataBoxTreeProvider() throws MalformedURLException {
        this.urlDb = new URL("http://localhost:8080/bigdata/sparql");
        this.pageId = null;
    }

    public BigdataBoxTreeProvider(URL urlDb, URIImpl pageId) {
        this.urlDb = urlDb;
        this.pageId = pageId;
    }

    public String getId() {
        return "FitLayout.Bigdata";
    }

    public String getName() {
        return "Bigdata loader";
    }

    public String getDescription() {
        return "Uses the Bigdata RDF DB for obtaining the box tree.";
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public ParametrizedOperation.ValueType[] getParamTypes() {
        return this.paramTypes;
    }

    public URL getUrlDb() {
        return this.urlDb;
    }

    public void setUrlDb(URL urlDb) {
        this.urlDb = urlDb;
    }

    public void setUrlDb(String urlDb) {
        try {
            this.urlDb = new URL(urlDb);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + urlDb);
        }
    }

    public URIImpl getPageId() {
        return this.pageId;
    }

    public void setPageId(URIImpl pageId) {
        this.pageId = pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = new URIImpl(pageId);
    }

    public Page getPage() {
        try {
            BigdataInterface bdi = new BigdataInterface(this.urlDb.toString(), false);
            Model m = bdi.getBoxModelForPageId(this.pageId.toString());
            BigdataPage bdmb = new BigdataPage(m, "http://www.idnes.cz");
            return bdmb;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

