/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepository;
import org.openrdf.model.Graph;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class BigdataConnector {
    String endpointUrl;
    Boolean lbs;
    RepositoryConnection connection;
    BigdataSailRemoteRepository repo;

    public RepositoryConnection getConnection() {
        return this.connection;
    }

    public BigdataConnector(String endpoint, Boolean lbs) throws RepositoryException {
        this.endpointUrl = endpoint;
        this.lbs = lbs;
        this.createConnection();
    }

    private void createConnection() throws RepositoryException {
        this.repo = new BigdataSailRemoteRepository(this.endpointUrl, this.lbs.booleanValue());
        this.connection = this.repo.getConnection();
    }

    public void add(Resource s, URI p, Value o) {
        try {
            StatementImpl stmt = new StatementImpl(s, p, o);
            this.connection.add((Statement)stmt, new Resource[0]);
            this.connection.commit();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public TupleQueryResult executeQuery(String queryString) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try {
            TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
            TupleQueryResult tqr = query.evaluate();
            return tqr;
        }
        catch (Exception ex) {
            System.out.println("nastala chyba");
            return null;
        }
    }

    public void addGraph(Graph graph) {
        try {
            this.connection.add((Iterable)graph, new Resource[0]);
            this.connection.commit();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void addNamespace(String newNamespace) {
    }

    public void removeNamespace(String namespace) throws RepositoryException {
        this.repo.getConnection().removeNamespace(namespace);
    }

    public RepositoryResult<Namespace> getAllNamespaces() throws RepositoryException {
        return this.repo.getConnection().getNamespaces();
    }
}

