/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage;

import com.bigdata.rdf.sail.webapp.client.IPreparedGraphQuery;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.storage.BigdataAreaModelBuilder;
import org.fit.layout.storage.BigdataBoxModelBuilder;
import org.fit.layout.storage.BigdataConnector;
import org.fit.layout.storage.ontology.BOX;
import org.fit.layout.storage.ontology.SEGM;
import org.openrdf.model.Graph;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;

public class BigdataInterface {
    private static final String PREFIXES = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> ";
    BigdataConnector bddb;
    Boolean lbs = false;
    String url = "http://localhost:8080/bigdata/sparql";

    public BigdataInterface() throws RepositoryException {
        this.bddb = new BigdataConnector(this.url, this.lbs);
    }

    public BigdataInterface(String url, Boolean lbs) throws RepositoryException {
        this.url = url;
        this.lbs = lbs;
        this.bddb = new BigdataConnector(this.url, this.lbs);
    }

    public RepositoryConnection getConnection() {
        return this.bddb.getConnection();
    }

    public List<String> getDistinctUrlPages() {
        ArrayList<String> output = new ArrayList<String>();
        try {
            GraphQueryResult result = this.bddb.repo.getRemoteRepository().getStatements(null, BOX.sourceUrl, null, true, new Resource[0]);
            while (result.hasNext()) {
                Statement bindingSet = (Statement)result.next();
                String url = bindingSet.getObject().stringValue();
                if (output.contains(url)) continue;
                output.add(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public List<String> getAllPageIds() throws Exception {
        ArrayList<String> output = new ArrayList<String>();
        URIImpl pageType = new URIImpl(BOX.Page.toString());
        try {
            GraphQueryResult result = this.bddb.repo.getRemoteRepository().getStatements(null, RDF.TYPE, (Value)pageType, true, new Resource[0]);
            while (result.hasNext()) {
                Statement bindingSet = (Statement)result.next();
                String url = bindingSet.getSubject().stringValue();
                if (output.contains(url)) continue;
                output.add(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public List<String> getPageIdsForUrl(String url) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            URIImpl sourceUrlPredicate = new URIImpl(BOX.sourceUrl.toString());
            ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
            GraphQueryResult result = this.bddb.repo.getRemoteRepository().getStatements(null, (URI)sourceUrlPredicate, (Value)vf.createLiteral(url), true, new Resource[0]);
            while (result.hasNext()) {
                Statement row = (Statement)result.next();
                String page = row.getSubject().toString();
                System.out.println("output " + page);
                if (output.contains(page)) continue;
                output.add(page);
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public void insertPageBoxModel(Page page) {
        BigdataBoxModelBuilder pgb = new BigdataBoxModelBuilder(page);
        this.insertGraph(pgb.getGraph());
    }

    public void removePage(String pageId) {
        this.removePageModel(pageId);
        this.removePageInfo(pageId);
    }

    public Model getBoxModelForTimestamp(String timestamp) throws Exception {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?s rdf:type app:Box . ?s ?b ?a . ?a box:launchDatetime \"" + timestamp + "\". " + "?a rdf:type box:Page  }";
        IPreparedGraphQuery pgq = this.bddb.repo.getRemoteRepository().prepareGraphQuery(query);
        GraphQueryResult gqr = pgq.evaluate();
        return this.convertGraphQueryResult2Model(gqr);
    }

    public Model getBoxModelForPageId(String pageId) throws Exception {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?s rdf:type app:Box . ?s box:belongsTo <" + pageId + ">}";
        IPreparedGraphQuery pgq = this.bddb.repo.getRemoteRepository().prepareGraphQuery(query);
        GraphQueryResult gqr = pgq.evaluate();
        return this.convertGraphQueryResult2Model(gqr);
    }

    public Model getPageInfo(String pageId) throws Exception {
        URIImpl page = new URIImpl(pageId);
        GraphQueryResult result = null;
        try {
            result = this.bddb.repo.getRemoteRepository().getStatements((Resource)page, null, null, true, new Resource[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.convertGraphQueryResult2Model(result);
    }

    public Model getAreaModelForAreaTreeId(String areaTreeId) throws Exception {
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX box: <http://fitlayout.github.io/ontology/render.owl#> PREFIX segm: <http://fitlayout.github.io/ontology/segmentation.owl#> CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?s rdf:type segm:Area . ?s segm:belongsTo <" + areaTreeId + "> }";
        IPreparedGraphQuery pgq = this.bddb.repo.getRemoteRepository().prepareGraphQuery(query);
        GraphQueryResult gqr = pgq.evaluate();
        return this.convertGraphQueryResult2Model(gqr);
    }

    public List<String> getAreaTreeIdsForPageId(String pageId) throws Exception {
        ArrayList<String> output = new ArrayList<String>();
        URIImpl page = new URIImpl(pageId);
        try {
            GraphQueryResult result = this.bddb.repo.getRemoteRepository().getStatements(null, SEGM.sourcePage, (Value)page, true, new Resource[0]);
            while (result.hasNext()) {
                Statement bindingSet = (Statement)result.next();
                String url = bindingSet.getObject().stringValue();
                if (output.contains(url)) continue;
                output.add(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public void insertAreaTree(AreaTree atree, LogicalAreaTree ltree, URIImpl pageId) {
        try {
            String actualUrl = pageId.toString();
            if (actualUrl.lastIndexOf("#") != -1) {
                actualUrl = actualUrl.substring(0, actualUrl.lastIndexOf("#"));
            }
            BigdataAreaModelBuilder buildingModel = new BigdataAreaModelBuilder(atree, ltree, (URI)pageId, actualUrl);
            this.insertGraph(buildingModel.getGraph());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RepositoryResult<Statement> getSubjectStatements(Resource subject) throws RepositoryException {
        RepositoryResult stm = this.bddb.connection.getStatements(subject, null, null, true, new Resource[0]);
        return stm;
    }

    public Model getSubjectModel(Resource subject) throws Exception {
        GraphQueryResult gqr = this.bddb.repo.getRemoteRepository().getStatements(subject, null, null, true, new Resource[0]);
        Model m = this.convertGraphQueryResult2Model(gqr);
        return m;
    }

    public TupleQueryResult executeQuery(String query) throws QueryEvaluationException {
        try {
            TupleQuery tq = this.bddb.repo.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, query);
            return tq.evaluate();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (MalformedQueryException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void clearRDFDatabase() {
        try {
            Update upd = this.bddb.repo.getConnection().prepareUpdate(QueryLanguage.SPARQL, "DELETE WHERE { ?s ?p ?o }");
            upd.execute();
        }
        catch (MalformedQueryException | UpdateExecutionException | RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void execSparql(String query) {
        try {
            Update upd = this.bddb.repo.getConnection().prepareUpdate(QueryLanguage.SPARQL, query);
            upd.execute();
        }
        catch (MalformedQueryException | UpdateExecutionException | RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void importTurtle(String query) {
        try {
            this.bddb.repo.getConnection().add((Reader)new StringReader(query), null, RDFFormat.TURTLE, new Resource[0]);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (RDFParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void removePageModel(String pageId) {
        try {
            Model m = this.getBoxModelForPageId(pageId);
            this.bddb.getConnection().remove((Iterable)m, new Resource[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<String> areaTreeModels = null;
        try {
            areaTreeModels = this.getAreaTreeIdsForPageId(pageId);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        for (String areaTreeId : areaTreeModels) {
            try {
                Model mat = this.getAreaModelForAreaTreeId(areaTreeId);
                this.bddb.getConnection().remove((Iterable)mat, new Resource[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void removePageInfo(String pageId) {
        try {
            Model m = this.getPageInfo(pageId);
            this.bddb.getConnection().remove((Iterable)m, new Resource[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Model convertGraphQueryResult2Model(GraphQueryResult gqr) throws QueryEvaluationException {
        LinkedHashModel model = new LinkedHashModel();
        while (gqr.hasNext()) {
            model.add(gqr.next());
        }
        return model;
    }

    private void insertGraph(Graph graph) {
        this.bddb.addGraph(graph);
    }
}

