/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.fit.layout.api.AreaTreeOperator;
import org.fit.layout.cssbox.CSSBoxTreeBuilder;
import org.fit.layout.gui.Browser;
import org.fit.layout.gui.BrowserPlugin;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.model.Tag;
import org.fit.layout.storage.BigdataInterface;
import org.fit.layout.storage.example.LinkCrawler;
import org.fit.segm.grouping.SegmentationAreaTree;
import org.fit.segm.grouping.op.FindLineOperator;
import org.xml.sax.SAXException;

public class MultiPageAnalyzerPlugin
implements BrowserPlugin {
    private Browser browser;
    BigdataInterface bdi = null;
    private JPanel pnl_main;
    private JTextField tfl_multiPageSeed;
    private JSpinner tfl_pageLimit;
    private JButton btn_multiPageAnalyzation;
    private JPanel pnl_crawledLink;
    private JScrollPane pathListScroll;
    private JScrollPane extractionScroll;
    private JTable classificationTable;
    private JList<String> pathList;
    private DefaultListModel<String> urlListModel;
    private JPanel controlPanel;
    private JButton btn_doAnalysis;
    private DefaultTableModel tagModelTable;

    public boolean init(Browser browser) {
        this.browser = browser;
        this.browser.addToolPanel("Multipage Analyzer", (JComponent)this.getTbr_control());
        this.browser.addStructurePanel("Multipage Analyzer", (JComponent)this.getPnl_crawledLinks());
        return true;
    }

    private JPanel getTbr_control() {
        if (this.pnl_main == null) {
            this.pnl_main = new JPanel();
            this.pnl_main.add(this.getTfl_multiPageSeed());
            this.pnl_main.add(this.getTfl_pageLimit());
            this.pnl_main.add(this.getBtn_multiPageAnalyzation());
        }
        return this.pnl_main;
    }

    private JTextField getTfl_multiPageSeed() {
        if (this.tfl_multiPageSeed == null) {
            this.tfl_multiPageSeed = new JTextField();
            this.tfl_multiPageSeed.setMinimumSize(new Dimension(12, 20));
            this.tfl_multiPageSeed.setHorizontalAlignment(2);
            this.tfl_multiPageSeed.setText("http://www.fit.vutbr.cz/");
            this.tfl_multiPageSeed.setColumns(30);
        }
        return this.tfl_multiPageSeed;
    }

    private JSpinner getTfl_pageLimit() {
        if (this.tfl_pageLimit == null) {
            this.tfl_pageLimit = new JSpinner();
            this.tfl_pageLimit.setValue(10);
        }
        return this.tfl_pageLimit;
    }

    private JButton getBtn_multiPageAnalyzation() {
        if (this.btn_multiPageAnalyzation == null) {
            this.btn_multiPageAnalyzation = new JButton("Run multipage crawling");
            this.btn_multiPageAnalyzation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MultiPageAnalyzerPlugin.this.clearUrlListModel();
                    String urlstring = MultiPageAnalyzerPlugin.this.tfl_multiPageSeed.getText();
                    if (!(urlstring.startsWith("http:") || urlstring.startsWith("ftp:") || urlstring.startsWith("file:"))) {
                        urlstring = "http://" + urlstring;
                    }
                    int urlLimit = (Integer)MultiPageAnalyzerPlugin.this.getTfl_pageLimit().getValue();
                    List urls = MultiPageAnalyzerPlugin.this.getCrawledUrlsFor(urlstring, urlLimit);
                    for (String key : urls) {
                        MultiPageAnalyzerPlugin.this.urlListModel.addElement(key);
                    }
                }
            });
        }
        return this.btn_multiPageAnalyzation;
    }

    private HashMap<String, AnalyzedPage> getAnalyzedAllUrls(List<String> urls) {
        HashMap<String, AnalyzedPage> analyzedPages = new HashMap<String, AnalyzedPage>();
        for (String url : urls) {
            try {
                AnalyzedPage ap = this.getAnalyzedUrl(url);
                analyzedPages.put(url, ap);
            }
            catch (IOException | SAXException e) {
                e.printStackTrace();
            }
        }
        return analyzedPages;
    }

    private AnalyzedPage getAnalyzedUrl(String urlstring) throws MalformedURLException, IOException, SAXException {
        AnalyzedPage pageAnalysis = new AnalyzedPage();
        Graphics2D g = this.browser.getOutputDisplay().getGraphics();
        Rectangle r = g.getDeviceConfiguration().getBounds();
        CSSBoxTreeBuilder build = new CSSBoxTreeBuilder(r.getSize());
        build.parse(urlstring);
        pageAnalysis.setPage(build.getPage());
        SegmentationAreaTree atree = this.getPageSegmentationTree(build.getPage());
        pageAnalysis.setAtree(atree);
        return pageAnalysis;
    }

    private List<String> getCrawledUrlsFor(String urlstring, int urlLimit) {
        LinkCrawler lc = new LinkCrawler();
        lc.setSeed(urlstring);
        lc.setLinksLimit(urlLimit);
        lc.start();
        return lc.getUrls();
    }

    public SegmentationAreaTree getPageSegmentationTree(Page page) {
        SegmentationAreaTree atree = new SegmentationAreaTree(page);
        atree.findBasicAreas();
        Vector<FindLineOperator> operations = new Vector<FindLineOperator>();
        operations.add(new FindLineOperator(false, 1.5f));
        System.out.println("OPERATORS");
        for (AreaTreeOperator areaTreeOperator : operations) {
            System.out.println(areaTreeOperator.toString());
            areaTreeOperator.apply((AreaTree)atree);
        }
        System.out.println("DONE");
        return atree;
    }

    private void clearUrlListModel() {
        this.urlListModel.clear();
    }

    private JPanel getPnl_crawledLinks() {
        if (this.pnl_crawledLink == null) {
            this.pnl_crawledLink = new JPanel();
            GridBagLayout gbl_pathsPanel = new GridBagLayout();
            gbl_pathsPanel.columnWidths = new int[]{0, 0};
            gbl_pathsPanel.rowHeights = new int[]{0, 0, 0};
            gbl_pathsPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_pathsPanel.rowWeights = new double[]{1.0, 0.1, 1.0, Double.MIN_VALUE};
            this.pnl_crawledLink.setLayout(gbl_pathsPanel);
            GridBagConstraints gbc_pathListScroll = new GridBagConstraints();
            gbc_pathListScroll.insets = new Insets(0, 0, 5, 0);
            gbc_pathListScroll.fill = 1;
            gbc_pathListScroll.gridx = 0;
            gbc_pathListScroll.gridy = 0;
            this.pnl_crawledLink.add((Component)this.getPathListScroll(), gbc_pathListScroll);
            GridBagConstraints gbc_extractionScroll2 = new GridBagConstraints();
            gbc_extractionScroll2.fill = 2;
            gbc_extractionScroll2.gridx = 0;
            gbc_extractionScroll2.gridy = 1;
            this.pnl_crawledLink.add((Component)this.getPnl_control(), gbc_extractionScroll2);
            GridBagConstraints gbc_extractionScroll = new GridBagConstraints();
            gbc_extractionScroll.fill = 1;
            gbc_extractionScroll.gridx = 0;
            gbc_extractionScroll.gridy = 2;
            this.pnl_crawledLink.add((Component)this.getExtractionScroll(), gbc_extractionScroll);
        }
        return this.pnl_crawledLink;
    }

    private JScrollPane getPathListScroll() {
        if (this.pathListScroll == null) {
            this.pathListScroll = new JScrollPane();
            this.pathListScroll.setViewportView(this.getList_crawledLinks());
        }
        return this.pathListScroll;
    }

    private JScrollPane getExtractionScroll() {
        if (this.extractionScroll == null) {
            this.extractionScroll = new JScrollPane();
            this.extractionScroll.setViewportView(this.getTbl_classificationTags());
        }
        return this.extractionScroll;
    }

    private JPanel getPnl_control() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.add(this.getBtn_doAnalysis());
        }
        return this.controlPanel;
    }

    private JButton getBtn_doAnalysis() {
        if (this.btn_doAnalysis == null) {
            this.btn_doAnalysis = new JButton("Run Analysis");
            this.btn_doAnalysis.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    List urls = MultiPageAnalyzerPlugin.this.pathList.getSelectedValuesList();
                    HashMap analyzedUrls = MultiPageAnalyzerPlugin.this.getAnalyzedAllUrls(urls);
                    Set keys = analyzedUrls.keySet();
                    MultiPageAnalyzerPlugin.this.clearTagTable();
                    for (String key : keys) {
                        Area rootArea = ((AnalyzedPage)analyzedUrls.get(key)).getAtree().getRoot();
                        MultiPageAnalyzerPlugin.this.showTagsForAreas(rootArea);
                    }
                }
            });
        }
        return this.btn_doAnalysis;
    }

    private void showTagsForAreas(Area parent) {
        List areas = parent.getChildAreas();
        for (Area a : areas) {
            Map map = a.getTags();
            Set keys = map.keySet();
            for (Tag key : keys) {
                this.tagModelTable.addRow(new Object[]{key, a.getText()});
            }
            this.showTagsForAreas(a);
        }
    }

    private void clearTagTable() {
        for (int i = this.tagModelTable.getRowCount(); i > 0; --i) {
            this.tagModelTable.removeRow(i - 1);
        }
    }

    private JTable getTbl_classificationTags() {
        if (this.classificationTable == null) {
            this.tagModelTable = new DefaultTableModel();
            this.tagModelTable.addColumn("Tag");
            this.tagModelTable.addColumn("Content");
            this.classificationTable = new JTable(this.tagModelTable);
        }
        return this.classificationTable;
    }

    private JList<String> getList_crawledLinks() {
        if (this.pathList == null) {
            this.urlListModel = new DefaultListModel();
            this.pathList = new JList<String>(this.urlListModel);
        }
        return this.pathList;
    }

    private class AnalyzedPage {
        private Page page;
        private SegmentationAreaTree atree;

        private AnalyzedPage() {
        }

        public Page getPage() {
            return this.page;
        }

        public void setPage(Page page) {
            this.page = page;
        }

        public SegmentationAreaTree getAtree() {
            return this.atree;
        }

        public void setAtree(SegmentationAreaTree atree) {
            this.atree = atree;
        }
    }
}

