/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.gui;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Scanner;
import org.fit.layout.api.ScriptObject;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.storage.BigdataInterface;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.RepositoryException;

public class ScriptApi
implements ScriptObject {
    private BufferedReader rin;
    private PrintWriter wout;
    private PrintWriter werr;
    private BigdataInterface bdi;

    public String getName() {
        return "storage";
    }

    public void setIO(Reader in, Writer out, Writer err) {
        this.rin = new BufferedReader(in);
        this.wout = new PrintWriter(out);
        this.werr = new PrintWriter(err);
    }

    public void connect(String uri) {
        try {
            this.bdi = new BigdataInterface(uri, false);
        }
        catch (RepositoryException e) {
            this.werr.println("Couldn't connect: " + e.getMessage());
        }
    }

    public void saveBoxTree(Page page) {
        if (page != null) {
            this.bdi.insertPageBoxModel(page);
        }
    }

    public void saveAreaTree(AreaTree atree, LogicalAreaTree ltree, String pageUri) {
        if (atree != null) {
            this.bdi.insertAreaTree(atree, ltree, new URIImpl(pageUri + "#something"));
        }
    }

    public void clearDB() {
        this.bdi.clearRDFDatabase();
    }

    public void execQueryFromResource(String res) {
        Scanner scan = new Scanner(ClassLoader.getSystemResourceAsStream(res));
        String query = scan.useDelimiter("\\Z").next();
        scan.close();
        this.bdi.execSparql(query);
    }

    public void importTurtle(String turtle) {
        this.bdi.importTurtle(turtle);
    }

    public void importTurtleFromResource(String res) {
        Scanner scan = new Scanner(ClassLoader.getSystemResourceAsStream(res));
        String turtle = scan.useDelimiter("\\Z").next();
        scan.close();
        this.bdi.importTurtle(turtle);
    }
}

