/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.fit.layout.gui.Browser;
import org.fit.layout.gui.BrowserPlugin;
import org.fit.layout.model.AreaTree;
import org.fit.layout.model.LogicalAreaTree;
import org.fit.layout.model.Page;
import org.fit.layout.storage.BigdataInterface;
import org.fit.layout.storage.model.BigdataAreaTree;
import org.fit.layout.storage.model.BigdataPage;
import org.openrdf.model.Model;
import org.openrdf.model.impl.URIImpl;

public class StoragePlugin
implements BrowserPlugin {
    private Browser browser;
    BigdataInterface bdi = null;
    private JPanel pnl_main;
    private JPanel tbr_connection;
    private JTextField tfl_urlRDFDB;
    private JLabel lbl_rdfDb;
    private JButton btn_loadDBData;
    private JPanel tbr_storageSelection;
    private JLabel lbl_urls;
    private JComboBox<String> cbx_pages;
    private JButton btn_loadBoxModel;
    private JPanel tbr_control;
    private JButton btn_saveBoxTreeModel;
    private JButton btn_removePage;
    private JButton btn_clearDB;
    private JButton btn_saveAreaTreeModel;
    private JComboBox<String> cbx_areaTrees;
    private JButton btn_loadAreaTreeModel;

    public boolean init(Browser browser) {
        this.browser = browser;
        this.browser.addToolPanel("Model Storage", (JComponent)this.getPnl_main());
        return true;
    }

    private JPanel getPnl_main() {
        if (this.pnl_main == null) {
            this.pnl_main = new JPanel();
            GridBagLayout gbl_main = new GridBagLayout();
            gbl_main.columnWeights = new double[]{0.0};
            gbl_main.rowWeights = new double[]{0.0, 0.0, 0.0};
            this.pnl_main.setLayout(gbl_main);
            GridBagConstraints gbc_connection = new GridBagConstraints();
            gbc_connection.weightx = 1.0;
            gbc_connection.anchor = 13;
            gbc_connection.fill = 1;
            gbc_connection.insets = new Insets(0, 0, 5, 0);
            gbc_connection.gridx = 0;
            gbc_connection.gridy = 0;
            this.pnl_main.add((Component)this.getPnl_connection(), gbc_connection);
            GridBagConstraints gbc_storageSelection = new GridBagConstraints();
            gbc_storageSelection.weightx = 1.0;
            gbc_storageSelection.fill = 1;
            gbc_storageSelection.insets = new Insets(0, 0, 5, 0);
            gbc_storageSelection.gridx = 0;
            gbc_storageSelection.gridy = 1;
            this.pnl_main.add((Component)this.getPnl_storageSelection(), gbc_storageSelection);
            GridBagConstraints gbc_control = new GridBagConstraints();
            gbc_control.weightx = 1.0;
            gbc_control.anchor = 13;
            gbc_control.fill = 1;
            gbc_control.insets = new Insets(0, 0, 5, 0);
            gbc_control.gridx = 0;
            gbc_control.gridy = 2;
            this.pnl_main.add((Component)this.getPnl_control(), gbc_control);
        }
        return this.pnl_main;
    }

    private JPanel getPnl_connection() {
        if (this.tbr_connection == null) {
            this.tbr_connection = new JPanel();
            this.tbr_connection.add(this.getLbl_RdfDb());
            this.tbr_connection.add(this.getTfl_urlRDFDB());
            this.tbr_connection.add(this.getBtn_loadDBData());
        }
        return this.tbr_connection;
    }

    private JTextField getTfl_urlRDFDB() {
        if (this.tfl_urlRDFDB == null) {
            this.tfl_urlRDFDB = new JTextField();
            this.tfl_urlRDFDB.setHorizontalAlignment(2);
            this.tfl_urlRDFDB.setText("http://localhost:8080/bigdata/sparql");
        }
        return this.tfl_urlRDFDB;
    }

    private JLabel getLbl_RdfDb() {
        if (this.lbl_rdfDb == null) {
            this.lbl_rdfDb = new JLabel("RDF DB");
        }
        return this.lbl_rdfDb;
    }

    private JButton getBtn_loadDBData() {
        if (this.btn_loadDBData == null) {
            this.btn_loadDBData = new JButton("Establish Connection");
            this.btn_loadDBData.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    StoragePlugin.this.loadAllPages();
                }
            });
        }
        return this.btn_loadDBData;
    }

    private JPanel getPnl_storageSelection() {
        if (this.tbr_storageSelection == null) {
            this.tbr_storageSelection = new JPanel();
            this.tbr_storageSelection.add(this.getLbl_pages());
            this.tbr_storageSelection.add(this.getCbx_pages());
            this.tbr_storageSelection.add(this.getBtn_loadBoxModel());
            this.tbr_storageSelection.add(this.getCbx_areaTrees());
            this.tbr_storageSelection.add(this.getBtn_loadAreaTreeModel());
        }
        return this.tbr_storageSelection;
    }

    private JLabel getLbl_pages() {
        if (this.lbl_urls == null) {
            this.lbl_urls = new JLabel("URLs");
        }
        return this.lbl_urls;
    }

    private JComboBox<String> getCbx_pages() {
        if (this.cbx_pages == null) {
            this.cbx_pages = new JComboBox();
            this.cbx_pages.setMaximumRowCount(8);
            this.cbx_pages.setPreferredSize(new Dimension(300, 25));
            this.cbx_pages.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StoragePlugin.this.cbx_areaTrees.removeAllItems();
                    if (StoragePlugin.this.cbx_pages.getItemCount() > 0) {
                        StoragePlugin.this.cbx_areaTrees.setEnabled(true);
                        try {
                            List<String> areaTrees = StoragePlugin.this.bdi.getAreaTreeIdsForPageId(StoragePlugin.this.cbx_pages.getSelectedItem().toString());
                            for (String area : areaTrees) {
                                StoragePlugin.this.cbx_areaTrees.addItem(area);
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        StoragePlugin.this.cbx_areaTrees.setEnabled(false);
                    }
                }
            });
        }
        return this.cbx_pages;
    }

    private JButton getBtn_loadBoxModel() {
        if (this.btn_loadBoxModel == null) {
            this.btn_loadBoxModel = new JButton("Load Box Model");
            this.btn_loadBoxModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String pageId = StoragePlugin.this.cbx_pages.getSelectedItem().toString();
                        Model modelStatements = StoragePlugin.this.bdi.getBoxModelForPageId(pageId);
                        BigdataPage page = new BigdataPage(modelStatements, pageId.substring(0, pageId.lastIndexOf("#")));
                        StoragePlugin.this.browser.setPage((Page)page);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog((Component)StoragePlugin.this.browser, "Cannot load defined launch!", "Loading Error", 0);
                    }
                }
            });
            this.btn_loadBoxModel.setEnabled(false);
        }
        return this.btn_loadBoxModel;
    }

    private void loadAllPages() {
        String DBConnectionUrl = this.tfl_urlRDFDB.getText();
        this.cbx_pages.removeAllItems();
        try {
            this.bdi = new BigdataInterface(DBConnectionUrl, false);
            List<String> listURL = this.bdi.getAllPageIds();
            for (String url : listURL) {
                this.cbx_pages.addItem(url);
            }
            this.getBtn_loadBoxModel().setEnabled(true);
            this.getBtn_loadAreaTreeModel().setEnabled(true);
            this.getBtn_saveBoxTreeModel().setEnabled(true);
            this.getBtn_removePage().setEnabled(true);
            this.getBtn_clearDB().setEnabled(true);
            this.getBtn_saveAreaTreeModel().setEnabled(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)this.browser, "There is a problem with DB connection: " + e.getMessage(), "Connection Error", 0);
        }
    }

    private JPanel getPnl_control() {
        if (this.tbr_control == null) {
            this.tbr_control = new JPanel();
            this.tbr_control.add(this.getBtn_saveBoxTreeModel());
            this.tbr_control.add(this.getBtn_saveAreaTreeModel());
            this.tbr_control.add(this.getBtn_removePage());
            this.tbr_control.add(this.getBtn_clearDB());
        }
        return this.tbr_control;
    }

    private JButton getBtn_saveBoxTreeModel() {
        if (this.btn_saveBoxTreeModel == null) {
            this.btn_saveBoxTreeModel = new JButton("Save Box Tree to DB");
            this.btn_saveBoxTreeModel.setEnabled(false);
            this.btn_saveBoxTreeModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Page page = StoragePlugin.this.browser.getPage();
                    if (page != null) {
                        StoragePlugin.this.bdi.insertPageBoxModel(page);
                        StoragePlugin.this.loadAllPages();
                    }
                }
            });
        }
        return this.btn_saveBoxTreeModel;
    }

    private JButton getBtn_removePage() {
        if (this.btn_removePage == null) {
            this.btn_removePage = new JButton("Remove Model");
            this.btn_removePage.setEnabled(false);
            this.btn_removePage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        String pageId = StoragePlugin.this.cbx_pages.getSelectedItem().toString();
                        StoragePlugin.this.bdi.removePage(pageId);
                        StoragePlugin.this.loadAllPages();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.btn_removePage;
    }

    private JButton getBtn_clearDB() {
        if (this.btn_clearDB == null) {
            this.btn_clearDB = new JButton("Clear DB");
            this.btn_clearDB.setEnabled(false);
            this.btn_clearDB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StoragePlugin.this.bdi.clearRDFDatabase();
                    StoragePlugin.this.loadAllPages();
                }
            });
        }
        return this.btn_clearDB;
    }

    private JButton getBtn_saveAreaTreeModel() {
        if (this.btn_saveAreaTreeModel == null) {
            this.btn_saveAreaTreeModel = new JButton("Save Area Tree to DB");
            this.btn_saveAreaTreeModel.setEnabled(false);
            this.btn_saveAreaTreeModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Page page = StoragePlugin.this.browser.getPage();
                    AreaTree atree = StoragePlugin.this.browser.getAreaTree();
                    LogicalAreaTree ltree = StoragePlugin.this.browser.getLogicalTree();
                    if (atree != null && page != null) {
                        StoragePlugin.this.bdi.insertAreaTree(atree, ltree, new URIImpl(StoragePlugin.this.cbx_pages.getSelectedItem().toString()));
                    }
                    StoragePlugin.this.loadAllPages();
                }
            });
        }
        return this.btn_saveAreaTreeModel;
    }

    private JComboBox<String> getCbx_areaTrees() {
        if (this.cbx_areaTrees == null) {
            this.cbx_areaTrees = new JComboBox();
            this.cbx_areaTrees.setPreferredSize(new Dimension(300, 25));
        }
        return this.cbx_areaTrees;
    }

    private JButton getBtn_loadAreaTreeModel() {
        if (this.btn_loadAreaTreeModel == null) {
            this.btn_loadAreaTreeModel = new JButton("Load AreaTree");
            this.btn_loadAreaTreeModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (StoragePlugin.this.cbx_areaTrees.getItemCount() > 0) {
                        try {
                            Model m = StoragePlugin.this.bdi.getAreaModelForAreaTreeId(StoragePlugin.this.cbx_areaTrees.getSelectedItem().toString());
                            BigdataAreaTree bdAreaTree = new BigdataAreaTree(m, StoragePlugin.this.browser.getPage().getSourceURL().toString());
                            StoragePlugin.this.browser.setAreaTree((AreaTree)bdAreaTree);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        return this.btn_loadAreaTreeModel;
    }
}

