/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.model;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.fit.layout.impl.DefaultArea;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.Area;
import org.fit.layout.model.AreaTree;
import org.fit.layout.storage.model.BigdataArea;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.vocabulary.RDF;

public class BigdataAreaTree
implements AreaTree {
    private DefaultArea root;
    private int height;
    private int width;

    public BigdataAreaTree(Model pageStatements, String urlString) throws MalformedURLException {
        List<DefaultArea> areas = this.getAllPageAreas(pageStatements);
        this.createDocumentTree(areas);
    }

    private List<DefaultArea> getAllPageAreas(Model pageStatements) {
        ArrayList<DefaultArea> allElements = new ArrayList<DefaultArea>();
        try {
            for (Statement s : pageStatements.filter(null, RDF.TYPE, null, new Resource[0])) {
                Model attributes = pageStatements.filter(s.getSubject(), null, null, new Resource[0]);
                allElements.add(new BigdataArea(attributes));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allElements;
    }

    private void createDocumentTree(List<DefaultArea> elements) {
        List<DefaultArea> list = BigdataAreaTree.sortBySize(elements);
        DefaultArea root = list.get(0);
        this.setHeight(root.getHeight());
        this.setWidth(root.getWidth());
        this.setRoot(root);
        list.remove(list.get(0));
        this.appendTo(root, this.getInnerIndividuals(root, list));
    }

    public static List<DefaultArea> sortBySize(List<DefaultArea> elements) {
        Collections.sort(elements, new Comparator<DefaultArea>(){

            @Override
            public int compare(DefaultArea one, DefaultArea two) {
                int width1 = one.getWidth();
                int height1 = one.getHeight();
                int width2 = two.getWidth();
                int height2 = two.getHeight();
                return width2 * height2 - width1 * height1;
            }
        });
        ArrayList<DefaultArea> dlb = new ArrayList<DefaultArea>();
        for (DefaultArea db : elements) {
            dlb.add(db);
        }
        return dlb;
    }

    private void appendTo(DefaultArea appendInd, List<DefaultArea> sourceList) {
        if (sourceList == null || sourceList.size() == 0) {
            return;
        }
        DefaultArea actual = sourceList.get(0);
        appendInd.add((GenericTreeNode)actual);
        sourceList.remove(sourceList.get(0));
        if (sourceList.size() == 0) {
            return;
        }
        List<DefaultArea> inner = this.getInnerIndividuals(actual, sourceList);
        List<DefaultArea> outer = this.getOuterIndividuals(actual, sourceList);
        if (inner.size() > 0) {
            this.appendTo(actual, inner);
        }
        if (outer.size() > 0) {
            this.appendTo(appendInd, outer);
        }
    }

    private List<DefaultArea> getInnerIndividuals(DefaultArea individual, List<DefaultArea> sourceList) {
        ArrayList<DefaultArea> listNested = new ArrayList<DefaultArea>();
        for (DefaultArea ind : sourceList) {
            if (!this.isNested(individual, ind).booleanValue()) continue;
            listNested.add(ind);
        }
        return listNested;
    }

    private List<DefaultArea> getOuterIndividuals(DefaultArea individual, List<DefaultArea> sourceList) {
        ArrayList<DefaultArea> listNested = new ArrayList<DefaultArea>();
        for (DefaultArea ind : sourceList) {
            if (this.isNested(individual, ind).booleanValue()) continue;
            listNested.add(ind);
        }
        return listNested;
    }

    private Boolean isNested(DefaultArea in1, DefaultArea in2) {
        int width1 = in1.getWidth();
        int height1 = in1.getHeight();
        int posYAbs1 = in1.getY1();
        int posXAbs1 = in1.getX1();
        int width2 = in2.getWidth();
        int height2 = in2.getHeight();
        int posYAbs2 = in2.getY1();
        int posXAbs2 = in2.getX1();
        if (posXAbs1 <= posXAbs2 && posXAbs1 + width1 >= posXAbs2 + width2 && posYAbs1 <= posYAbs2 && posYAbs1 + height1 >= posYAbs2 + height2) {
            return true;
        }
        return false;
    }

    public Area getAreaAt(int x, int y) {
        return null;
    }

    public Area getAreaByName(String name) {
        return null;
    }

    public DefaultArea getRoot() {
        return this.root;
    }

    public void setRoot(DefaultArea area) {
        this.root = area;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

