/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.model;

import java.awt.Color;
import org.fit.layout.impl.DefaultBox;
import org.fit.layout.model.Box;
import org.fit.layout.model.Rectangular;
import org.fit.layout.storage.ontology.BOX;
import org.openrdf.model.Model;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;

public class BigdataBox
extends DefaultBox
implements Box {
    Integer width = null;
    Integer height = null;
    Integer x = null;
    Integer y = null;

    public BigdataBox(Model attributes) {
        this.setText("");
        for (Statement attribute : attributes) {
            this.setAttribute(attribute);
        }
        if (this.height != null) {
            System.out.println("Velikost height " + this.height);
        }
        if (this.height != null && this.width != null && this.x != null && this.y != null) {
            this.setBounds(new Rectangular(this.x.intValue(), this.y.intValue(), this.x + this.width, this.y + this.height));
            this.setVisualBounds(new Rectangular(this.x.intValue(), this.y.intValue(), this.x + this.width, this.y + this.height));
        }
    }

    public void setAttribute(Statement attribute) {
        URI uri = attribute.getPredicate();
        if (BOX.backgroundColor.equals((Object)uri)) {
            String bgColor = attribute.getObject().stringValue();
            this.setBackgroundColor(this.hex2Rgb(bgColor));
        } else if (!BOX.backgroundImagePosition.equals((Object)uri) && !BOX.backgroundImageUrl.equals((Object)uri)) {
            if (BOX.color.equals((Object)uri)) {
                String color = attribute.getObject().stringValue();
                this.setColor(this.hex2Rgb(color));
            } else if (BOX.underline.equals((Object)uri)) {
                this.setUnderline(Float.parseFloat(attribute.getObject().stringValue()));
            } else if (BOX.lineThrough.equals((Object)uri)) {
                this.setUnderline(Float.parseFloat(attribute.getObject().stringValue()));
            } else if (BOX.fontFamily.equals((Object)uri)) {
                this.setFontFamily(attribute.getObject().stringValue());
            } else if (BOX.fontSize.equals((Object)uri)) {
                this.setFontSize(Float.parseFloat(attribute.getObject().stringValue()));
            } else if (BOX.fontStyle.equals((Object)uri)) {
                this.setFontStyle(Float.parseFloat(attribute.getObject().stringValue()));
            } else if (BOX.fontWeight.equals((Object)uri)) {
                this.setFontWeight(Float.parseFloat(attribute.getObject().stringValue()));
            } else if (BOX.hasBottomBorder.equals((Object)uri)) {
                this.setBottomBorder(Integer.parseInt(attribute.getObject().stringValue()));
            } else if (BOX.hasLeftBorder.equals((Object)uri)) {
                this.setLeftBorder(Integer.parseInt(attribute.getObject().stringValue()));
            } else if (BOX.hasRightBorder.equals((Object)uri)) {
                this.setRightBorder(Integer.parseInt(attribute.getObject().stringValue()));
            } else if (BOX.hasTopBorder.equals((Object)uri)) {
                this.setTopBorder(Integer.parseInt(attribute.getObject().stringValue()));
            } else if (BOX.hasText.equals((Object)uri)) {
                this.setType(Box.Type.TEXT_CONTENT);
                this.setText(attribute.getObject().stringValue());
            } else if (BOX.height.equals((Object)uri)) {
                this.height = Integer.parseInt(attribute.getObject().stringValue());
            } else if (BOX.width.equals((Object)uri)) {
                this.width = Integer.parseInt(attribute.getObject().stringValue());
            } else if (BOX.positionX.equals((Object)uri)) {
                this.x = Integer.parseInt(attribute.getObject().stringValue());
            } else if (BOX.positionY.equals((Object)uri)) {
                this.y = Integer.parseInt(attribute.getObject().stringValue());
            }
        }
    }

    private Color hex2Rgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }
}

