/*
 * Decompiled with CFR 0.152.
 */
package org.fit.layout.storage.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.fit.layout.impl.DefaultBox;
import org.fit.layout.impl.DefaultPage;
import org.fit.layout.impl.GenericTreeNode;
import org.fit.layout.model.Box;
import org.fit.layout.storage.model.BigdataBox;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.vocabulary.RDF;

public class BigdataPage
extends DefaultPage {
    public BigdataPage(Model pageStatements, String urlString) throws MalformedURLException {
        super(new URL(urlString));
        List<DefaultBox> boxes = this.getAllPageBoxes(pageStatements);
        this.createDocumentTree(boxes);
    }

    private List<DefaultBox> getAllPageBoxes(Model pageStatements) {
        ArrayList<DefaultBox> allElements = new ArrayList<DefaultBox>();
        try {
            for (Statement s : pageStatements.filter(null, RDF.TYPE, null, new Resource[0])) {
                Model attributes = pageStatements.filter(s.getSubject(), null, null, new Resource[0]);
                allElements.add(new BigdataBox(attributes));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allElements;
    }

    private void createDocumentTree(List<DefaultBox> elements) {
        List<DefaultBox> list = BigdataPage.sortBySize(elements);
        DefaultBox root = list.get(0);
        this.setHeight(root.getHeight());
        this.setWidth(root.getWidth());
        this.setRoot((Box)root);
        list.remove(list.get(0));
        this.appendTo(root, this.getInnerIndividuals(root, list));
    }

    public static List<DefaultBox> sortBySize(List<DefaultBox> elements) {
        Collections.sort(elements, new Comparator<DefaultBox>(){

            @Override
            public int compare(DefaultBox one, DefaultBox two) {
                int width1 = one.getWidth();
                int height1 = one.getHeight();
                int width2 = two.getWidth();
                int height2 = two.getHeight();
                return width2 * height2 - width1 * height1;
            }
        });
        ArrayList<DefaultBox> dlb = new ArrayList<DefaultBox>();
        for (DefaultBox db : elements) {
            dlb.add(db);
        }
        return dlb;
    }

    private void appendTo(DefaultBox appendInd, List<DefaultBox> sourceList) {
        if (sourceList == null || sourceList.size() == 0) {
            return;
        }
        DefaultBox actual = sourceList.get(0);
        appendInd.add((GenericTreeNode)actual);
        sourceList.remove(sourceList.get(0));
        if (sourceList.size() == 0) {
            return;
        }
        List<DefaultBox> inner = this.getInnerIndividuals(actual, sourceList);
        List<DefaultBox> outer = this.getOuterIndividuals(actual, sourceList);
        if (inner.size() > 0) {
            this.appendTo(actual, inner);
        }
        if (outer.size() > 0) {
            this.appendTo(appendInd, outer);
        }
    }

    private List<DefaultBox> getInnerIndividuals(DefaultBox individual, List<DefaultBox> sourceList) {
        ArrayList<DefaultBox> listNested = new ArrayList<DefaultBox>();
        for (DefaultBox ind : sourceList) {
            if (!this.isNested(individual, ind).booleanValue()) continue;
            listNested.add(ind);
        }
        return listNested;
    }

    private List<DefaultBox> getOuterIndividuals(DefaultBox individual, List<DefaultBox> sourceList) {
        ArrayList<DefaultBox> listNested = new ArrayList<DefaultBox>();
        for (DefaultBox ind : sourceList) {
            if (this.isNested(individual, ind).booleanValue()) continue;
            listNested.add(ind);
        }
        return listNested;
    }

    private Boolean isNested(DefaultBox in1, DefaultBox in2) {
        int width1 = in1.getWidth();
        int height1 = in1.getHeight();
        int posYAbs1 = in1.getY1();
        int posXAbs1 = in1.getX1();
        int width2 = in2.getWidth();
        int height2 = in2.getHeight();
        int posYAbs2 = in2.getY1();
        int posXAbs2 = in2.getX1();
        if (posXAbs1 <= posXAbs2 && posXAbs1 + width1 >= posXAbs2 + width2 && posYAbs1 <= posYAbs2 && posYAbs1 + height1 >= posYAbs2 + height2) {
            return true;
        }
        return false;
    }
}

